//* @(#)About.java  1  2003
  //Copyright (c) 2006 Ric Bottomley
  //All rights reserved. 
  //This material is provided "as is", with absolutely no warranty expressed
  //or implied. Any use is at your own risk.
  //Permission to use or copy this software is hereby granted without fee,
  //provided this copyright notice is retained on all copies.
package gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import javax.swing.*;
import java.awt.Component;
import java.io.*;
import javax.swing.text.*;
import java.net.URL;
import java.awt.Toolkit;

final public class About  {
protected JButton end;
private ImageIcon rixlogo;
private JTabbedPane tabbedPane = new JTabbedPane();
private JPanel panelJ;
private boolean alreadyMade = false;
private JFrame frame = new JFrame("Info . . . ");
//private DefaultStyledDocument doc = new DefaultStyledDocument();
//private JTextPane areaHist=new JTextPane(doc);
//private MutableAttributeSet mas = new SimpleAttributeSet();

public About() {
        panelJ = new JPanel(new BorderLayout());
        rixlogo = new ImageIcon(getResource("/toolBarPics/rixLogo.gif"));
        
        tabbedPane.addTab("Help",makeHelpPane());
        tabbedPane.setMnemonicAt(0, KeyEvent.VK_H);

        tabbedPane.addTab("Author", makeAbout());
        tabbedPane.setMnemonicAt(1, KeyEvent.VK_A);

        tabbedPane.addTab("Licence", makeLicence());
        tabbedPane.setMnemonicAt(2, KeyEvent.VK_L);
        //Add the tabbed pane to this panel.
        panelJ.add(tabbedPane,BorderLayout.CENTER);
        tabbedPane.setSelectedIndex(1);
        tabbedPane.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
        frame.setVisible(false);
}
    
private URL getResource(String thePath) {
    URL urlCard = About.class.getResource(thePath);
    return urlCard;  
}

private JComponent makeAbout(){
    JPanel panelA = new JPanel();
    panelA.setLayout(new BoxLayout(panelA, BoxLayout.Y_AXIS));
    JLabel pict = new JLabel(rixlogo);
    pict.setAlignmentX(Component.CENTER_ALIGNMENT);
    panelA.add(Box.createRigidArea(new Dimension(0,20)));
    panelA.add(pict);
    JLabel text = new JLabel("\n\nVerbOS, Version 1.7 (2005)");
    text.setAlignmentX(Component.CENTER_ALIGNMENT);
    JLabel textM = new JLabel("\n\n(c)2005 darkroom@users.sourceforge.net");
    textM.setAlignmentX(Component.CENTER_ALIGNMENT);
    panelA.add(Box.createRigidArea(new Dimension(0,10)));
    panelA.add(text);
    panelA.add(Box.createRigidArea(new Dimension(0,10)));
    panelA.add(textM);
    return panelA;
}

private JComponent makeLicence(){
    JEditorPane area = new JEditorPane();
    try {
        InputStream is = getClass().getResourceAsStream("/text/gpl.txt");
        area.read( is,"gpl.txt" );
    	}
    	catch( FileNotFoundException e ){System.out.println( "File not found, licence missing" );}
    	catch( IOException e ){System.out.println( "IOException occurred reading licence" );}
    area.setEditable(false);
    JScrollPane scroller = new JScrollPane(area);
    scroller.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
    scroller.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
    return scroller;
}

//load in the html page
protected JComponent makeHelpPane() {
        JScrollPane scrollerR=null;
        try {        
        URL url = getClass().getResource("/text/VerbOS_Help.html");
        JEditorPane help = new JEditorPane();     
        help.setPage(url);
        help.setEditable(false);
        scrollerR = new JScrollPane(help);
        scrollerR.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        scrollerR.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        }
    	catch( FileNotFoundException e ){ e.printStackTrace(); }
    	catch( IOException e ) { e.printStackTrace(); }
        catch( NullPointerException e){e.printStackTrace();}
return scrollerR;   
}
    
protected void closeMe(){if (frame.isShowing()){frame.dispose();}}
    
private void centre(){
	Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
	int x = (screenSize.width - 500)/2;
	int y = (screenSize.height - 250)/2;
	frame.setLocation(x,y);
}

protected void showMe(int tab){
        tabbedPane.setSelectedIndex(tab);
        if (alreadyMade == false) 
            {
        frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        frame.setSize(500,225);
        frame.setIconImage(new ImageIcon(getResource("/menuPics/Globe.jpeg")).getImage());
        JComponent newContentPane = panelJ;
        newContentPane.setOpaque(true);
        frame.getContentPane().add(panelJ);
        centre();
        frame.setVisible(true);
        alreadyMade = true;    
        }
        else {           
            centre();
            frame.setVisible(true);
        }    
}

}
