  //* @(#)celledit.java  1  2004
  //Copyright (c) 2006 Ric Bottomley
  //All rights reserved. 
  //This material is provided "as is", with absolutely no warranty expressed
  //or implied. Any use is at your own risk.
  //Permission to use or copy this software is hereby granted without fee, 
  //provided this copyright notice is retained on all copies
package gui;

import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.event.*;


//we overide this class simply to change the setclick
//and also to implement the carot listener . . 
public class CellEdit extends DefaultCellEditor implements CaretListener {
    JFormattedTextField ftf;
    private int caretPos=0;   
    
    public CellEdit() {
        super(new JFormattedTextField());
        ftf = (JFormattedTextField)getComponent();
        ftf.setFocusLostBehavior(JFormattedTextField.PERSIST);
        //change the really anoying default behaviour of jtable clickin ;)
        setClickCountToStart(1);
        ftf.addCaretListener(this);
    }

  protected int getCaretPos(){ return caretPos; }

  public void caretUpdate(CaretEvent e){ caretPos = e.getDot(); }
  
  
}
