package gui;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
//import org.hsqldb.*;
import java.util.StringTokenizer;
import java.io.*;

public class DataCtrl {

    private static String sWhere = " where verb = '";
    static Connection conn;    
   
    //our connnection to the db - presist for life of program

    // we dont want this garbage collected until we are done

    
public DataCtrl() throws Exception {    // note more general exception
//String db_file_name_prefix
        // Load the HSQL Database Engine JDBC driver
        // hsqldb.jar should be in the class path or made part of the current jar
        Class.forName("org.hsqldb.jdbcDriver");

        // connect to the database.   This will load the db files and start the
        // database if it is not already running.
        // db_file_name_prefix is used to open or create files that hold the state
        // of the db.
        // It can contain directory names relative to the
        // current working directory
        conn = DriverManager.getConnection("jdbc:hsqldb:"
                                           + "./verbsDB/verbsDB",    // filenames
                                           "sa",                     // username
                                           "");                      // password
    conn.setAutoCommit(true);
    }


public static void shutdownCompact() throws SQLException {

        Statement st = conn.createStatement();

        // db writes out to files and performs clean shuts down
        // otherwise there will be an unclean shutdown
        // when program ends
        st.execute("SHUTDOWN COMPACT");
        conn.close();    // if there are no other open connection
    }    

public static void shutdown() throws SQLException {

        Statement st = conn.createStatement();

        // db writes out to files and performs clean shuts down
        // otherwise there will be an unclean shutdown
        // when program ends
        //can call "SHUTDOWN COMPACT" to make the db smaller, slows down window closing
        st.execute("SHUTDOWN");
        conn.close();    // if there are no other open connection
    }

//use for SQL command SELECT
    public synchronized ResultSet query(String expression) throws SQLException {

        Statement st = null;
        ResultSet rs = null;
        ResultSet rsOpen = null;
        st = conn.createStatement();         
        // statement objects can be reused with
        // repeated calls to execute but we
        // choose to make a new one each time
        rs = st.executeQuery(expression);    // run the query

        // do something with the result set.
      //dump(rs);
       rsOpen = rs;
        st.close();    // NOTE!! if you close a statement the associated ResultSet is

        // closed too
        // so you should copy the contents to some other object.
        // the result set is invalidated also  if you recycle an Statement
        // and try to execute some other query before the result set has been
        // completely examined.
    return rsOpen;
    }

//use for SQL commands CREATE, DROP, INSERT and UPDATE
    public synchronized void update(String expression) throws SQLException {

        Statement st = null;

        st = conn.createStatement();    // statements

        int i = st.executeUpdate(expression);    // run the query

        if (i == -1) {
            System.out.println("db error : " + expression);
        }

        st.close();
    }    // void update()
    
    public void test(){
           try { query("SELECT verb FROM spanish"); }
           catch(SQLException e){e.printStackTrace();} 
    }

//format the verbs so first letter is capitalisied    
private String formatVerbs(String verb) {
    verb = verb.substring(0, 1).toUpperCase() + verb.substring(1, verb.length()).toLowerCase();
    return verb;
} 
       

//returns all the verbs for whichever table is queried
//it will be the responisbility of the language object to format this list correctly
//with the given collator
protected ArrayList getVerbs(String table) throws SQLException {
    ArrayList entries = new ArrayList(1000); 
    Statement st = null;
            ResultSet rs = null;
            st = conn.createStatement();
            rs = st.executeQuery("SELECT verb FROM " + table); 
            String str = "";
              for (; rs.next(); ) {
                    str = rs.getString(1);
                    entries.add(formatVerbs(str));           
                    }
            st.close();            
return entries;    
} 

//return the description for verb
protected String getDesc(String verb, String table) throws SQLException {        
            String desc = null;
            Statement st = null;
            ResultSet rs = null;
            st = conn.createStatement();
            rs = st.executeQuery("SELECT desc FROM " + table + sWhere + verb.toLowerCase() + "';"); 
            if (rs.next()) { desc = rs.getString(1); }
            st.close();
return desc;
}

//return the data for main conjugations for verb
//dependant on db structure, additional languages must be input the same way
//a query on the table will return 8 coloumns for the main data
//and 1 coloumn for the sub data.  
static protected String[][] getMainData(String verb, String table, String view) throws SQLException {     
    Statement st = null;
    ResultSet rs = null;
        Object o = null;
        st = conn.createStatement();
        //select everything except name, desc, and imps
        rs = st.executeQuery("select " + view + " from " + table + sWhere + verb.toLowerCase() + "';");    

//now put the result in a 2d array and pass it to the table model
        ResultSetMetaData meta = rs.getMetaData();
        int cols = meta.getColumnCount();
        //add an extra column for the rows
        String[] data = new String[cols+1];
        for (; rs.next(); ) {
            for (int i = 0; i < cols; ++i) {
                o = rs.getObject(i+1); 
                data[i+1]=o.toString();
            }//end col loop
        }//end rs loop
        st.close();
        return convertStatement(data);
}


//like below but with a delimiter
static private String[][] convertStatement(String[] stringAry, String delim){
    //+1 because the first element is empty, it will be used for the rows
    StringTokenizer st = new StringTokenizer(stringAry[1],delim);
    int rows = st.countTokens();  
    String[][] data = new String[rows][stringAry.length];
    for (int i=1;i<stringAry.length;i++) { 
         st = new StringTokenizer(stringAry[i],delim);
         for (int j=0;j<rows;j++) {                
             data[j][i]=st.nextToken();      
         }
    }   
return data;
}

//convert the array from the statement to the 2d array needed for the table
//the array that is returned has the first column(0) empty
static private String[][] convertStatement(String[] stringAry){
    //+1 because the first element is empty, it will be used for the rows
    StringTokenizer st = new StringTokenizer(stringAry[1]);
    int rows = st.countTokens();  
    String[][] data = new String[rows][stringAry.length];
    for (int i=1;i<stringAry.length;i++) { 
         st = new StringTokenizer(stringAry[i]);
         for (int j=0;j<rows;j++) {                
             data[j][i]=st.nextToken();      
         }
    }   
return data;
}

//confusingly returns the opposite of above due to db format
//the number of tokens are the columns, not the rows
protected String[][] getSubData(String verb, String table) throws SQLException {
        Statement st = null;
        ResultSet rs = null; 
        st = conn.createStatement();
        rs = st.executeQuery("select imps from " + table + sWhere + verb.toLowerCase() + "' ");           
                rs.next();//move the rs on one
                StringTokenizer stk = new StringTokenizer(rs.getString(1));
                
                int length = stk.countTokens();
                String[][] data = new String[1][length];
                
                for (int i=0;i<length;i++) 
                {
                    data[0][i] = stk.nextToken();
                }              
                st.close();
 return data;       
}

//System.out.println(term + "term");
//System.out.println(inflectQ + "inflectQ");
//searches all the verbs for an inflected form 
static protected String inflectSearch(String inflectQ, String term, String table) throws SQLException {
String queryStr = "select verb From " + table + " where verb in (select verb from "+ table + " where ' ' +" + 
                  inflectQ + " '% " + term + " %')";   
       Statement st = null;
       ResultSet rs = null; 
       String result = null;
       st = conn.createStatement();
       rs = st.executeQuery(queryStr);           
       if (rs.next()){ result = rs.getString(1); } 
       st.close();
       return result;    
}                 

//data for the auxillary table
protected String[][] getAuxData(String table) throws SQLException {
       Statement st = null;
       ResultSet rs = null; 
       Object o = null;
       st = conn.createStatement();
       rs = st.executeQuery("select * from " + table);    

       ResultSetMetaData meta = rs.getMetaData();
       int cols = meta.getColumnCount();
        //add an extra column for the rows
       String[] data = new String[cols+1];
        for (; rs.next(); ) {
            for (int i = 0; i < cols; ++i) {
                o = rs.getObject(i+1); 
                data[i+1]=o.toString();
            }//end col loop
        }//end rs loop
        st.close();
        return convertStatement(data,",");
}

protected void deleteVerb(String table, String verb) throws SQLException {
     Statement st = conn.createStatement();
     int recordsUpdated;
     recordsUpdated = st.executeUpdate("DELETE FROM " + table + sWhere + verb.toLowerCase() + "' ");
     st.close();
     if (recordsUpdated!=1) { System.out.println("Problem with database update"); }
}


protected void addVerb(String table, String verb, String[] insert, String desc) throws SQLException {
     Statement st = conn.createStatement();
     int recordsUpdated;
     //build the query
     String query="";
     for (int i=0;i<insert.length;i++) {
         if (i == insert.length-1) { query = query + "'" + insert[i] + "');"; }
         else { query = query + "'" + insert[i] + "',"; }
        }
     recordsUpdated = st.executeUpdate("INSERT INTO " + table + " VALUES('" + verb.toLowerCase() + "'," +
             "'" + desc + "'," + query);
     st.close();
     if (recordsUpdated!=1) { System.out.println("Problem with database update"); }
}





protected void editVerb(Language lang, String[][] m, String[][] s, String desc, String verb, Boolean replace) throws SQLException {
    //if (desc.equals("")){ desc = getDesc(lang.returnVerb(), lang.returnTable2Q()); }
    //make an array to contain all the entries
    String[] insert = new String[m[0].length ];
    String row="";
    String temp;
    int i = 0;
    //read into insert all the rows, start at 1 becos col0 reserved for table data
    for (i=1;i<m[0].length;i++) {
        row = "";
        for (int j=0;j<m.length;j++){
            temp = m[j][i].trim();
            if (temp.equals("") | (temp==null)) { temp = "**";}
            row = row + " " + temp;
        }
    insert[i-1]=row.trim();
    }
    for (int k=0;k<s.length;k++) {
        row = "";
        for (int j=0;j<s[0].length;j++){
            temp = s[k][j].trim();
            if (temp.equals("") | (temp==null)) { temp = "**";}
            row = row + " " + temp;
        }
    insert[i-1]=row.trim();i++;
    }
    
  //  for (int y=0;y<insert.length;y++){
  //     System.out.println(insert[y]);
  //  }
    
    //drop the existing verb and add the new version
    if (replace.booleanValue()) { deleteVerb(lang.returnTable2Q(), lang.returnVerb()); 
                   addVerb(lang.returnTable2Q(),verb,insert,desc);
                 }
    //or just add the new version
    else { addVerb(lang.returnTable2Q(),verb,insert,desc); }    
}




 }    // class Testdb