  //* @(#)DictInterface.java  1  2006
  //Copyright (c) 2004 Ric Bottomley
  //All rights reserved. 
  //This material is provided "as is", with absolutely no warranty expressed
  //or implied. Any use is at your own risk.
  //Permission to use or copy this software is hereby granted without fee, 
  //provided this copyright notice is retained on all copies

package gui;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import java.awt.event.ActionListener;
import dict.DatabaseFactory;
import dict.IDictEngine;
import dict.IRequest;
import dict.IAnswer;
import dict.SimpleRequest;
import dict.Answer;
import java.awt.Color;
import dict.IDatabase;
import java.io.*;
import java.util.StringTokenizer;
import java.util.Vector;
import java.text.Collator;
import java.util.Locale;
import java.util.Collections;

//this class simply interface withs the dictionary package
public class DictInterface implements ActionListener, ListSelectionListener {

private JList index = new JList();    
private JTextPane defs = new JTextPane();
private JTextField searchBox = new JTextField(15);  
private IDictEngine e;
private File es = new File("./span_eng/eng-spa.index");
private File se = new File("./span_eng/spa-eng.index");
private File ef = new File("./fran_eng/eng-fra.index");
private File fe = new File("./fran_eng/fra-eng.index");
private File opt1;
private File opt2;
private Collator esp = Collator.getInstance(new Locale("es","ES"));
private Collator fra = Collator.getInstance(new Locale("fr","FR"));
private Collator eng = Collator.getInstance(new Locale("us","US"));
private Collator optC1;
private Collator optC2; 
//however much better way, 
//initialise the files above in a loop by a query the engine for db's
//set the collaters from the index file as well
//get the 2 char string from db get name
//jobs a good one.

/** Creates a new instance of DictInterface */
    public DictInterface() {
    //should start the db process with default config file
    //check for probs etc
    //return the index and first definition ready
    //then simply wait for requests to serve
    
    //File f = new File("./config/conf.ini");    
    //File f = new File("./span_eng/conf.ini");
    //java.util.Properties p = new java.util.Properties();
        try {
		//InputStream in = new FileInputStream(f);
		//p.load(in);
		//in.close();
                e = DatabaseFactory.getEngine("./config/conf.ini");
                setIndex(es);
        } catch (Throwable t) {
            JOptionPane.showMessageDialog(null,"An error has occured with the dictionary configuration" +
                    " refer to your documentation","Critical Error",
                    JOptionPane.WARNING_MESSAGE);     
	}
        //sort all the index files to make sure they are ok
        //DatabaseFactory.sort("/home/rix/verbOS/verbOS/build/classes/span_eng/spa-eng.index");
    //adds a listener to the search box
    addListener();
    //method to initialise all the files
    setFiles();
    }
    
private void setFiles(){
    String c1, c2;
    IDatabase[] bases = e.getDatabases();
    if (bases.length > 4){ opt1 = bases[4].getIndexFile();
    c1 = bases[4].getCollate();
    optC1 = Collator.getInstance(new Locale(c1,c1.toUpperCase())); 
    }
   
    if (bases.length > 5){ opt2 = bases[5].getIndexFile();
    c2 = bases[5].getCollate();
    optC2 = Collator.getInstance(new Locale(c2,c2.toUpperCase())); 
    
    }
//all we need to do now is set a string to each button

}

private String db = "db=es&word=";
//use this so gui can adjust dictionary view
private void setDataBase(String dbChange, File indexF){
    //if there is no opt dict, give a optionPane and leave
    if (dbChange.equals("db=opt1&word=") || dbChange.equals("db=opt2&word=")) {
        if (indexF == null) {
JOptionPane.showMessageDialog(null,"There is no dictionary configured for this button","Info",JOptionPane.INFORMATION_MESSAGE);
        return;
        }
        
    }
    db = dbChange;
    try { setIndex(indexF); }
    catch (java.lang.NullPointerException e ) { e.printStackTrace(); }
    catch (java.io.FileNotFoundException e ) { e.printStackTrace(); }
    catch (java.io.IOException e ) { e.printStackTrace(); }
    setDef();
}

//answer a simple query from database    
private IAnswer[] newQuery(String query) { 
//need to specify encoding utf or the database will fail to find word
   try {
    query = new String(query.getBytes("UTF-8")); }
    catch (UnsupportedEncodingException u) {u.printStackTrace();}
    IRequest req = new SimpleRequest(db + query);
        IAnswer[] arr = e.lookup(req);       
return arr;
}


private void formatAnswer(){
    //just have to define the section where we want colours
    //interface the first line up to []
    //then the text with [] in a different color
    
    String def = defs.getText();
    StyledDocument doc = defs.getStyledDocument();
    MutableAttributeSet sectionAttributes = new SimpleAttributeSet();
    
    if (def.equals("No definition found")){
    StyleConstants.setForeground(sectionAttributes, Color.BLUE);
    doc.setCharacterAttributes(0, doc.getLength(), sectionAttributes, true);
    }
    
    else {
    StringTokenizer st = new StringTokenizer(def, "\n");
    String line = st.nextToken();
    int lineLength = line.length();
//parse line to make sure it don't contain a [
//if it contains a split it a [, color everything before red, everything after blue.
    int pos = line.indexOf('[');
    
    if (pos==-1) {
    StyleConstants.setForeground(sectionAttributes, Color.RED);
    doc.setCharacterAttributes(0, line.length(), sectionAttributes, true);   
    }
    else {
    int end = line.indexOf(']'); 
    StyleConstants.setForeground(sectionAttributes, Color.RED);
    doc.setCharacterAttributes(0, pos-1, sectionAttributes, false);      
    StyleConstants.setForeground(sectionAttributes, Color.BLUE);
    doc.setCharacterAttributes(pos, end-pos+1, sectionAttributes, false);      
    }   
    
    //work around for french dictionary which doesn't seem to follow the format :|
    if (st.hasMoreTokens()) { line = st.nextToken(); }
    pos = line.indexOf('[');
    if (pos!=-1) { 
    int end = line.indexOf(']');   
    StyleConstants.setForeground(sectionAttributes, Color.BLUE);
    doc.setCharacterAttributes(lineLength, end-pos+3, sectionAttributes, false);      
    }   
    
    }
}



private void definition(IAnswer[] arr){
    defs.setText("");            
    Answer anAnswer;
    StyledDocument doc = defs.getStyledDocument();
    
    for (int i=0;i<arr.length;i++) {
            anAnswer = (Answer) arr[i];
             if (anAnswer.getDefinition()==null) { defs.setText("No definition found"); }
             else { 
             //int end = doc.getLength();
             //method to append to the text area
             try {
             if ( arr[i].usedMorph() ) { String line = "Morph analyzer suggests:  "; 
             doc.insertString(0, line, new SimpleAttributeSet());
             }
                 doc.insertString(doc.getLength(), anAnswer.getDefinition(), new SimpleAttributeSet());}
             catch (BadLocationException b){ b.printStackTrace(); }
             }   }
formatAnswer();
}

protected JTextPane getDef(){
    definition(newQuery( (String)index.getSelectedValue()));
     defs.setEditable(false);
     return defs;
}


private void setDef() { }


//changes the index to the new value
//need to use utf-8 for this part
private void setIndex(File indexF)throws java.lang.NullPointerException,java.io.FileNotFoundException,java.util.NoSuchElementException,
                                 java.io.IOException,java.lang.IndexOutOfBoundsException{
    
    
    FileInputStream fis=new FileInputStream(indexF);
    BufferedReader reader=new BufferedReader(new InputStreamReader(fis, "UTF-8"));   

    
    //BufferedReader reader= new BufferedReader(new FileReader(indexF));
    StringTokenizer st;
    String line = reader.readLine();   
    //actually we cud get the exact size and just use an array here
    Vector v = new Vector(50000);
    while (line != null) {

        if (line.startsWith("0")) { line = reader.readLine(); continue; }
        st = new StringTokenizer(line,"\t");
        v.add(st.nextToken("\t"));
        line = reader.readLine();
    }
    reader.close();         
    
    //sort the list with given comparator
    if (db.equals("db=se&word=")) { Collections.sort(v,esp); }
    if (db.equals("db=fe&word=")) { Collections.sort(v,fra); }
    if (db.equals("db=opt1&word=")) { Collections.sort(v,optC1); }
    if (db.equals("db=opt1&word=")) { Collections.sort(v,optC2); }
    else { Collections.sort(v,eng); }

index.setListData(v);
index.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
index.setSelectedIndex(0);
index.addListSelectionListener(this);        
}

//returns first instance of index for GUI
protected JList getIndex(){ return index; }

protected JTextField getSearchBox(){    
    searchBox.setActionCommand("search");
    searchBox.addActionListener(this);
return searchBox;
}


//gives the search box a listener so as the user types we can query the JList
private void addListener(){
    searchBox.getDocument().addDocumentListener(new DocumentListener() {
	public void insertUpdate(DocumentEvent e) {
        int pos = index.getNextMatch(searchBox.getText(), 0, Position.Bias.Forward);
        index.ensureIndexIsVisible(pos);
        index.setSelectedIndex(pos);
        }                  
 
	public void removeUpdate(DocumentEvent e) { 
        int pos = index.getNextMatch(searchBox.getText(), 0, Position.Bias.Forward);
        index.ensureIndexIsVisible(pos);
        index.setSelectedIndex(pos);       
        }
 
	public void changedUpdate(DocumentEvent e) { }		
    });}

public void valueChanged(ListSelectionEvent e) {
    if (e.getValueIsAdjusting()) { return; }
    
    if (index.isSelectionEmpty()) { return; } 
    else {
      String myStr = (String)index.getSelectedValue();
    definition(newQuery(myStr));
    }
}

public void actionPerformed(java.awt.event.ActionEvent e) {
   String eventStr;
   eventStr = e.getActionCommand();  
   if (eventStr.equals("search")) { definition(newQuery(searchBox.getText())); }
   if (eventStr.equals("spanEng")){ setDataBase("db=se&word=", se); }
   if (eventStr.equals("engFren")){ setDataBase("db=ef&word=", ef); }
   if (eventStr.equals("frenEng")){ setDataBase("db=fe&word=", fe); }
   if (eventStr.equals("engSpan")){ setDataBase("db=es&word=", es); }
   if (eventStr.equals("opt1")){ setDataBase("db=opt1&word=",opt1); }
   if (eventStr.equals("opt2")){ setDataBase("db=opt2&word=",opt2); }
//if equals an opt button, check for config
//if it exist get info, if not return a message...

}

}
