  //* @(#)GUI.java  1  2006
  //Copyright (c) 2006 Ric Bottomley
  //All rights reserved. 
  //This material is provided "as is", with absolutely no warranty expressed
  //or implied. Any use is at your own risk.
  //Permission to use or copy this software is hereby granted without fee, 
  //provided this copyright notice is retained on all copies
package gui;

import javax.swing.*;
import javax.swing.border.*;
import java.sql.SQLException;
import java.awt.Image.*;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.*;
import javax.swing.event.*;
import java.awt.Color;
import java.awt.FlowLayout;
import java.io.*;
import java.util.ArrayList;

public class Gui extends JFrame implements ActionListener , ChangeListener, WindowListener {

private JOptionPane tellUser = new JOptionPane();    
private Input input = new Input(); 
private DictInterface di = new DictInterface();

public Gui() {
        super("VerbOS");
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setIconImage(new ImageIcon("./menuPics/Globe.jpeg").getImage());
        setMenu(); 
        //if we call get content pane we get a awt container, better to use swing so hence this method
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setOpaque(true);
        //contentPane.setAlignmentX(Component.LEFT_ALIGNMENT);
        getToolBar();        
        //this.setDefaultLookAndFeelDecorated(true);
        setAll(contentPane); 
        pack();
        setExtendedState(JFrame.MAXIMIZED_BOTH);
        input.align((Language)input.returnLangs().get(0),"Centre");
        setVisible(true);
        input.intialise = true;
        verbTabs.addChangeListener(this);
        addWindowListener(this);     
}

public static void main(String args[]){ 
             try { 
       javax.swing.UIManager.setLookAndFeel("com.birosoft.liquid.LiquidLookAndFeel");
         //JFrame.setDefaultLookAndFeelDecorated(true);	
         //JDialog.setDefaultLookAndFeelDecorated(true);
            }
        catch (Exception e) {e.printStackTrace();}
    Gui gui = new Gui();
}    

//create menu items
private JMenuItem addToMenu(String name, String imgPath, int mnemonic, String keStroke, int inUse){
    JMenuItem addNew = new JMenuItem(name,new ImageIcon(imgPath));
    addNew.addActionListener(this);    
    if (mnemonic != 0) {addNew.setMnemonic(mnemonic);}
    if (keStroke != null) {addNew.setAccelerator(KeyStroke.getKeyStroke(keStroke));}
    if (inUse == 0) {addNew.setEnabled(false);}
    return addNew;
}

private JPanel verbTab(Language lang) {
    JPanel tabContentPane = new JPanel();
    tabContentPane.setLayout(new BoxLayout(tabContentPane, BoxLayout.Y_AXIS));
    
    JPanel panelVerb = new JPanel(new BorderLayout());
    JComboBox select = input.popCombo(lang);
    select.setPreferredSize(new Dimension(120,35));    
    //roach this off
    //instead the lang object will hold its own label
    JLabel labVerb = input.returnVerbLab(lang,(String)select.getItemAt(0));
    panelVerb.add(labVerb, BorderLayout.WEST);
    panelVerb.add(select, BorderLayout.EAST); 
    panelVerb.setAlignmentX(Component.LEFT_ALIGNMENT);
    //panelVerb.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.gray),
      //                                              BorderFactory.createEmptyBorder(5,5,5,5))); 
    
    panelVerb.setBorder(BorderFactory.createEmptyBorder(5,5,5,2));
    panelVerb.setMaximumSize(new Dimension(Integer.MAX_VALUE,45));    
    panelVerb.setPreferredSize(new Dimension(Integer.MAX_VALUE, 45));
    tabContentPane.add(panelVerb,getInsets());
    
    //JPanel bigTable = new JPanel();
    //bigTable.setLayout(new BoxLayout(bigTable, BoxLayout.X_AXIS));
    //bigTable.add(input.returnTable());
    //bigTable.setBorder(BorderFactory.createEmptyBorder(0,10,0,10));
    //JPanel smTable = new JPanel();
    //smTable.setLayout(new BoxLayout(smTable, BoxLayout.X_AXIS));
    //smTable.add(input.returnTableSm());
    tabContentPane.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
    //tabContentPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, 400));
    //tabContentPane.add(bigTable);
    //tabContentPane.add(smTable);
    tabContentPane.add(getSplit(lang));  
    
    return tabContentPane;
}


private JPanel testTab(){
    JPanel testP = new JPanel();
    testP.setBorder(BorderFactory.createEmptyBorder(5,10,5,10));
    testP.setLayout(new BoxLayout(testP, BoxLayout.Y_AXIS));
    testP.add(accentButtons());
    testP.add(getBar());
    testP.add(moreButts());
    //test.add(quikTest());
    testP.add(infoTable());
    return testP;
}

private JPanel dictTab(){
    JPanel dicts = new JPanel();
    dicts.setLayout(new BoxLayout(dicts,BoxLayout.Y_AXIS));

    
    //make a panel for the buttons
    JPanel dictButts = new JPanel(new FlowLayout(FlowLayout.LEADING));
    JPanel engSpa = new JPanel();
    engSpa.add(makeButton("./toolBarPics/eng-span.gif","engSpan", "English-Espaol", null,30));
    engSpa.add(makeButton("./toolBarPics/span-eng.gif","spanEng", "Espaol-English", null,30));
    JPanel engFre = new JPanel();
    engFre.add(makeButton("./toolBarPics/eng-fran.gif","engFren", "English-French", null,30));
    engFre.add(makeButton("./toolBarPics/fran-eng.gif","frenEng", "French-English", null,30));
    JPanel optP = new JPanel();
    optP.add(makeButton(null,"opt1", "optional dict", "ID",30));
    optP.add(makeButton(null,"opt2", "optional dict", "ID",30));
    dictButts.add(engSpa);
    dictButts.add(engFre);
    dictButts.add(optP);
    
    //buttons are put inside panel with flowLayout . . . . dictButts
    
    JPanel search = new JPanel(new FlowLayout(FlowLayout.LEADING));
        
     JTextField searchBox = di.getSearchBox(); 
    searchBox.setMaximumSize(new Dimension(90,25));
    searchBox.setPreferredSize(new Dimension(90,25));
    //search.setAlignmentX(Component.LEFT_ALIGNMENT);
    search.setBorder(BorderFactory.createEmptyBorder(0,5,0,5));
    search.add(searchBox);
    //searchBox put inside panel with flowLayout . . . . search
    
    
    //JPanel dict = new JPanel(new FlowLayout(FlowLayout.LEADING));
    JPanel dict = new JPanel();
    dict.setLayout(new BoxLayout(dict,BoxLayout.X_AXIS));
    JScrollPane scroller1 = new JScrollPane(di.getIndex()); 
    JScrollPane scroller2 = new JScrollPane(di.getDef());
    //scroller1.setPreferredSize(new Dimension(80,180));
    //scroller2.setPreferredSize(new Dimension(480,180));
    JSplitPane dictSpl = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,scroller1, scroller2);
    scroller1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
    scroller2.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
    //dictSpl.setPreferredSize(new Dimension(600,180));
    //dictSpl.setMaximumSize(new Dimension(Integer.MAX_VALUE,230));
    dictSpl.setDividerLocation(165);
    //dictSpl.setResizeWeight(0.9);
    //dictSpl.setAlignmentX(Component.LEFT_ALIGNMENT);
    //dict.setPreferredSize(new Dimension(Integer.MAX_VALUE,200));
    dict.add(dictSpl);
    //dictSpl put inside panel with flowlayout dict
    //dicts.setAlignmentX(Component.LEFT_ALIGNMENT);
    dict.setBorder(BorderFactory.createEmptyBorder(5,10,5,10)); 
    dicts.add(dictButts);    
    dicts.add(search);
    dicts.add(dict);
return dicts;
}

//returns the verb tables by parsing the arraylist of lang objects
private static JTabbedPane verbTabs;
private JTabbedPane getTabs(){
    verbTabs = new JTabbedPane();
    ArrayList langs = input.returnLangs();
    for (int i=0;i<langs.size();i++){
        Language lang = (Language)langs.get(i); 
        verbTabs.addTab(lang.returnLang(),verbTab(lang));
        verbTabs.setMnemonicAt(i, KeyEvent.VK_E); 
        verbTabs.setPreferredSize(new Dimension(Integer.MAX_VALUE,300));
    }
    return verbTabs;
}

//returns the lower tabs, dictionaries etc
private static JTabbedPane tabbedPane;
private JTabbedPane getLowTabs(){
    tabbedPane = new JTabbedPane();
    tabbedPane.addTab("Dictionary",dictTab());
    tabbedPane.setMnemonicAt(0, KeyEvent.VK_D);
    
    tabbedPane.addTab("Test", testTab());
    tabbedPane.setMnemonicAt(1, KeyEvent.VK_T);
    
    //tabbedPane.addTab("Submit", transTab());
    //tabbedPane.setMnemonicAt(2, KeyEvent.VK_S);
    tabbedPane.setBorder(BorderFactory.createEmptyBorder(5,0,0,0)); 
    return tabbedPane;
}


private void setAll(JPanel pane){
    //contentPane = border layout
    //innerPane = borderLayout, yAxis
        //innerPane contains tabs 
    //content pane has toolbar(north) and innerPane(centre)
    JPanel innerPane = new JPanel();
    innerPane.setLayout(new BoxLayout(innerPane, BoxLayout.Y_AXIS));
    //innerPane.setLayout(new GridLayout(2,0));
    
    pane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.gray),
                                                    BorderFactory.createEmptyBorder(5,5,5,5)));   
    
    //returns top layer of tabs
   innerPane.add(getTabs(),getInsets());
    //returns bottom layer of tabs
    innerPane.add(getLowTabs(),getInsets());
    
    pane.add(getToolBar(),BorderLayout.NORTH);
    pane.add(innerPane,BorderLayout.CENTER);
    totalVerbs = input.getTotalVerbs();
    pane.add(totalVerbs,BorderLayout.SOUTH);
    setContentPane(pane);
}
private static JLabel totalVerbs;
protected static void setTotalVerbs(JLabel lab){ totalVerbs.setText(lab.getText()); }

//leave this as is for now, check for active lang and get the table
//for that lang. when the languiage changes this needs to be updated
private JTable auxInfo;
private JScrollPane subInfo;
private JScrollPane infoTable(){
    Language lang = getActiveLang();
    //JPanel panel = new JPanel();
    TitledBorder title = new TitledBorder(BorderFactory.createTitledBorder("Pronouns and compound tenses"));
    //panel.setBorder(title);     
    //panel.setLayout(new GridBagLayout());
    auxInfo = lang.returnAuxTable();
    subInfo = new JScrollPane(auxInfo);
    subInfo.setPreferredSize(new Dimension(580,150));
    subInfo.setAlignmentX(Component.LEFT_ALIGNMENT);
    subInfo.setBorder(title);     
    return subInfo;
}

private JPanel moreButts(){
    JPanel jP = new JPanel();    
    jP.add(makeButton(null,"Skip", "Siguiente", "Next",100));
    jP.add(makeButton(null,"Hinta", "Pista", "Hint",100));
    jP.add(makeButton(null,"Mark", "Nota", "Mark All",100)); 
    jP.add(makeButton(null,"Sol", "Solucin", "Solution",100)); 
    jP.setPreferredSize(new Dimension(Integer.MAX_VALUE,40));
    jP.setMaximumSize(new Dimension(Integer.MAX_VALUE,40));       
    jP.setAlignmentX(Component.LEFT_ALIGNMENT);
    return jP;
}

private JPanel accentButtons(){
    JPanel accButts = new JPanel();
    accButts.add(makeButton(null,"addN", "", "",0)); 
    accButts.add(makeButton(null,"addA", "", "",0)); 
    accButts.add(makeButton(null,"addE", "", "",0)); 
    accButts.add(makeButton(null,"addI", "", "",0)); 
    accButts.add(makeButton(null,"addO", "", "",0)); 
    accButts.add(makeButton(null,"addU", "", "",0)); 
    accButts.add(makeButton(null,"addUU", "", "",0)); 
    JLabel space = new JLabel("(+fr)");
    accButts.add(space);
    accButts.add(makeButton(null,"fra1", "", "",0));
    accButts.add(makeButton(null,"fra2", "", "",0));
    accButts.add(makeButton(null,"fra3", "", "",0));
    accButts.add(makeButton(null,"fra4", "", "",0));
    accButts.add(makeButton(null,"fra5", "", "",0));
    accButts.add(makeButton(null,"fra6", "", "",0));
    accButts.add(makeButton(null,"fra7", "", "",0));
    accButts.add(makeButton(null,"fra8", "", "",0));
    accButts.add(makeButton(null,"fra9", "", "",0));
    accButts.add(makeButton(null,"fra10", "", "",0));
    accButts.add(makeButton(null,"fra11", "", "",0));
    accButts.add(makeButton(null,"fra12", "", "",0));
 
    accButts.setAlignmentX(Component.LEFT_ALIGNMENT);
    accButts.setPreferredSize(new Dimension(Integer.MAX_VALUE,40));
    accButts.setMaximumSize(new Dimension(Integer.MAX_VALUE,40));                                                   
    return accButts;
}

private JProgressBar getBar(){
    JProgressBar progressBar = input.returnProgressBar();   
    progressBar.setStringPainted(true);
    progressBar.setAlignmentX(Component.LEFT_ALIGNMENT);
    progressBar.setPreferredSize(new Dimension(Integer.MAX_VALUE, 20));
    return progressBar;
}

private JSplitPane getSplit(Language lang){
    JScrollPane scroller1 = new JScrollPane(lang.returnMainTable());
   JScrollPane scroller2 = new JScrollPane(lang.returnSubTable());
    //JScrollPane scroller1 = new JScrollPane(); 
   scroller1.setPreferredSize(new Dimension(560,190));
   scroller2.setPreferredSize(new Dimension(560,170));
   JSplitPane tableSpl = new JSplitPane(JSplitPane.VERTICAL_SPLIT,scroller1, scroller2);

    scroller1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
scroller2.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
    
//tableSpl.setPreferredSize(new Dimension(Integer.MAX_VALUE,200));
    tableSpl.setMaximumSize(new Dimension(Integer.MAX_VALUE,240));
    tableSpl.setDividerLocation(154 + tableSpl.getInsets().top);
    //tableSpl.setResizeWeight(0.9);
    return tableSpl;   
}

private static JButton del;private static JButton ad;private static JButton edit;
private static JButton save;private static JButton back;private static JButton forward;
private static JButton find;
private JToolBar getToolBar(){
    JToolBar toolBar = new JToolBar("Tools"); 
    ad = makeButton("./toolBarPics/Add.gif","Add", "Add New Verb", null,0);
    edit = makeButton("./toolBarPics/Edit.gif","Edit", "Edit Description/Conjugations", null,0);   
    save = makeButton("./toolBarPics/Save.gif","Save", "Save Verb", null,0);
    del = makeButton("./toolBarPics/Delete.gif","Delete", "Delete Verb", null,0);
    back = makeButton("./toolBarPics/Back.gif","Back", "Back", null,0); 
    forward = makeButton("./toolBarPics/Forward.gif","Forward", "Forward", null,0);
    find = makeButton("./toolBarPics/Find.gif","Find", "Search", null,0);
    toolBar.add(ad);toolBar.add(edit);
    toolBar.add(save);modeOptions(0); 
    toolBar.add(del);modeOptions(0); 
    toolBar.addSeparator();
    toolBar.add(makeButton("./toolBarPics/Preferences.gif","Prefs", "Preferences", null,0));
    toolBar.add(find);
    toolBar.addSeparator();
    toolBar.add(makeButton("./toolBarPics/Left.gif","Left", "Align Left", null,0));
    toolBar.add(makeButton("./toolBarPics/Centre.gif","Centre", "Align Centre", null,0));
    toolBar.add(makeButton("./toolBarPics/Right.gif","Right", "Align Right", null,0));
    toolBar.addSeparator();
    toolBar.add(back);toolBar.add(forward);
    toolBar.addSeparator();
    toolBar.add(makeButton("./toolBarPics/Help.gif","Help", "Help", null,0));
    //toolBar.setAlignmentX(Component.LEFT_ALIGNMENT);
    toolBar.setFloatable(false);
    return toolBar;
}
           
//center window on screen
//private void centre(){
	//Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
	//int x = (screenSize.width - 850)/2;
	//int y = (screenSize.height - 700)/2;
	//setLocation(x,y);
//}

//button maker
private JButton makeButton(String imageName, String actionCommand, String toolTipText, String altText, int length){
        JButton button;
        int len = length;
        if (altText == null) {button = new JButton();}
        else {button = new JButton(altText);} 
        button.setActionCommand(actionCommand);
        button.setToolTipText(toolTipText);
        if (len !=0) {button.setPreferredSize(new Dimension(len,30));}
        if (imageName != null) {button.setIcon(new ImageIcon(imageName));}
        if (len==30){button.addActionListener(di);return button;}
        if (actionCommand.equals("Edit") || actionCommand.equals("Add")) { button.addActionListener(this); }
        else { button.addActionListener(input); }
        return button;
}

private static JMenuItem newVerb;
private static JMenuItem saveVerb;
private static JMenuItem delVerb;
private static JRadioButtonMenuItem view;
private static JRadioButtonMenuItem editRb;
private static JRadioButtonMenuItem test;

private void setMenu(){
        JMenuBar mnb = new JMenuBar();
        JMenu mn1 = new JMenu("File");
            mn1.setMnemonic(KeyEvent.VK_F);
        JMenu mn2 = new JMenu("Mode");
            mn2.setMnemonic(KeyEvent.VK_M);
        JMenu mn3 = new JMenu("Help");
            mn3.setMnemonic(KeyEvent.VK_H);
        JMenu mn4 = new JMenu("L&F");
            mn4.setMnemonic(KeyEvent.VK_L);       
            //file menu
            newVerb = addToMenu(" New Verb","menuPics/Add.gif", KeyEvent.VK_N, null, 1);
            //newVerb.removeActionListener(this);
            //newVerb.addActionListener(input);newVerb.setActionCommand("Add");
            mn1.add(newVerb);
            saveVerb = addToMenu(" Save Verb","menuPics/Save.gif", KeyEvent.VK_S, null, 1);
            mn1.add(saveVerb);saveVerb.setActionCommand("Save");
            saveVerb.removeActionListener(this);
            saveVerb.addActionListener(input);
            
            delVerb = addToMenu(" Delete Verb","menuPics/Delete.gif", KeyEvent.VK_D, null, 1);
            mn1.add(delVerb);saveVerb.setActionCommand("Del");
            saveVerb.removeActionListener(this);
            saveVerb.addActionListener(input);
            
            mn1.add(addToMenu(" Search","menuPics/Find.gif",KeyEvent.VK_A, "control S", 1));
            mn1.addSeparator();
            mn1.add(addToMenu(" Preferences","menuPics/Preferences.gif", KeyEvent.VK_P, "control P", 1));
            mn1.addSeparator();
            mn1.add(addToMenu(" Compact Shutdown","menuPics/End.gif", KeyEvent.VK_C, "control C", 1));
            mn1.add(addToMenu(" End Session","menuPics/End.gif", KeyEvent.VK_E, "control E", 1));
            //mode button group
            ButtonGroup bGrp=new ButtonGroup();
            view =new JRadioButtonMenuItem("View",true);
            editRb =new JRadioButtonMenuItem("Edit");
            editRb.setActionCommand("EditMode");
            test =new JRadioButtonMenuItem("Test");
                view.setAccelerator(KeyStroke.getKeyStroke("control V"));
                editRb.setAccelerator(KeyStroke.getKeyStroke("control E"));
                test.setAccelerator(KeyStroke.getKeyStroke("control T"));
                view.addActionListener(this);editRb.addActionListener(this);test.addActionListener(this);
            bGrp.add(view);bGrp.add(editRb);bGrp.add(test);
            mn2.add(view);mn2.add(editRb);mn2.add(test);     
            //user / help menus
            mn3.add(addToMenu(" Help File","menuPics/Help.gif", KeyEvent.VK_F, "control H", 1));
            mn3.add(addToMenu(" About","menuPics/Information.gif", KeyEvent.VK_A, "control A", 1)); 
            mn4.add(addToMenu(" Liquid L&F","menuPics/lf.gif", KeyEvent.VK_L, "control L", 1));
            mn4.add(addToMenu(" Swing L&F","menuPics/lf.gif", KeyEvent.VK_S, "control S", 1));
        mnb.add(mn1);
	mnb.add(mn2);
	mnb.add(mn4);
        mnb.add(mn3);
        //set menu to frame
        setJMenuBar(mnb);		
}
    
protected static void save(boolean yn){
 save.setEnabled(yn);
 saveVerb.setEnabled(yn);
}

protected static void modeOptions(int mode){
    switch(mode){
        case 0:{
        save.setEnabled(true);
        forward.setEnabled(true);back.setEnabled(true);
        saveVerb.setEnabled(true);
        view.setSelected(true);
        edit.setEnabled(true);
        del.setEnabled(true);
        find.setEnabled(true);
        break;}
        
        case 1:{
        ad.setEnabled(true); 
        save.setEnabled(true);
        forward.setEnabled(true);back.setEnabled(true);
        newVerb.setEnabled(true);saveVerb.setEnabled(false);
        save.setEnabled(false);
        editRb.setSelected(true);
        edit.setEnabled(true);
        del.setEnabled(true);
        find.setEnabled(true);
        break;}
        case 2:{
        ad.setEnabled(false);
        save.setEnabled(false);
        forward.setEnabled(false);back.setEnabled(false);
        newVerb.setEnabled(false);saveVerb.setEnabled(false);
        edit.setEnabled(false);
        del.setEnabled(false);
        find.setEnabled(false);
        test.setSelected(true);
        tabbedPane.setSelectedIndex(1);
        break;}
        default:{break;}
    }
}

protected static int getActiveTab() {
    int tab = verbTabs.getSelectedIndex();
    return tab;
}

//need a method to recognise the active language, designated by the active tab#
public Language getActiveLang(){
    int tab = verbTabs.getSelectedIndex();
    //System.out.println("no of langs=" + input.returnLangs().size() + " " + tab);
    return (Language)input.returnLangs().get(tab);
}

//called when the user changes the language tab
public void stateChanged(ChangeEvent e){

Language lang = getActiveLang();
subInfo.getViewport().remove(auxInfo);
subInfo.getViewport().add(lang.returnAuxTable(), null);;
//update the renderer so that old testing data is not left in the system
ArrayList langs = input.returnLangs();  
Language lan;
for (int i=0;i<langs.size();i++){
        lan = (Language)langs.get(i);
        lan.getRenderer().clearPoints();
    }
//update the mode for new selected lang
if (input.mode==0){modeOptions(0);input.viewMode(lang);}
if (input.mode==1){modeOptions(1);input.editMode(lang);}
if (input.mode==2){modeOptions(2); input.testMode(lang);}
}

private void changeLF(boolean lf){

if (lf){
    try{
    UIManager.setLookAndFeel("com.birosoft.liquid.LiquidLookAndFeel");
    SwingUtilities.updateComponentTreeUI(this);
    input.updateTables();
    }
    catch (Exception e) {e.printStackTrace();} 
}
else {
    try{
    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());    
    SwingUtilities.updateComponentTreeUI(this);
    input.updateTables();
    }
    catch (Exception e) {e.printStackTrace();}
}
}

public void actionPerformed(java.awt.event.ActionEvent e) {
    String eventStr;
    int rtnMsg = -1;
    Object[] options = { "Yes", "Cancel" };
    eventStr = e.getActionCommand();
    if (eventStr.equals(" Compact Shutdown")){ rtnMsg  = tellUser.showOptionDialog(this, "This command will shutdown VerbOS and compact the database, this process takes around 20 seconds", "Confirm Shutdown",
                 JOptionPane.DEFAULT_OPTION, JOptionPane.WARNING_MESSAGE,null, options, options[0]);
                 if (rtnMsg == 0){try {DataCtrl.shutdownCompact();} 
                 catch(SQLException s){System.out.println("Problem shutting down database");} 
                 }
                 System.exit(0);
                 }
    if (eventStr.equals(" End Session")){ rtnMsg  = tellUser.showOptionDialog(this, "Really Quit ?", "Confirm Quit",
                 JOptionPane.DEFAULT_OPTION, JOptionPane.WARNING_MESSAGE,null, options, options[0]);
                 if (rtnMsg == 0){System.exit(0);}}
    if (eventStr.equals(" Search")){input.showSearch(getActiveLang());}
    if (eventStr.equals(" Help File")){input.showAbout(0);}
    if (eventStr.equals(" About")){input.showAbout(1);}
    if (eventStr.equals(" Preferences")){ input.showPrefs(getActiveLang()); }
    if (eventStr.equals("View")){modeOptions(0);input.viewMode(getActiveLang());}
    if (eventStr.equals("Edit")) { input.editVerbDesc(getActiveLang());}
    if (eventStr.equals("EditMode")){ modeOptions(1);input.editMode(getActiveLang()); }
    if (eventStr.equals(" Delete Verb")){ input.deleteEntry(getActiveLang());}
    if (eventStr.equals("Add")){ input.addEntry(getActiveLang()); }
    if (eventStr.equals(" New Verb")){ input.addEntry(getActiveLang()); }  
    if (eventStr.equals("Save")){ modeOptions(1); input.saveChange(getActiveLang()); }  
    if (eventStr.equals("Test")){ modeOptions(2); input.testMode(getActiveLang()); }
    if (eventStr.equals(" Liquid L&F")){ changeLF(true); }
    if (eventStr.equals(" Swing L&F")){ changeLF(false); }
}


public void windowActivated(WindowEvent e) {}
public void windowClosed(WindowEvent e) {}
public void windowClosing(WindowEvent e) {try {DataCtrl.shutdown();} catch(SQLException s){System.out.println("Database did not shutdown cleanly");}}
public void windowDeactivated(WindowEvent e) {}
public void windowDeiconified(WindowEvent e) {}
public void windowIconified(WindowEvent e) {}
public void windowOpened(WindowEvent e) {}





}
 
