  //* @(#)Input.java  1  2006
  //Copyright (c) 2006 Ric Bottomley
  //All rights reserved. 
  //This material is provided "as is", with absolutely no warranty expressed
  //or implied. Any use is at your own risk.
  //Permission to use or copy this software is hereby granted without fee, 
  //provided this copyright notice is retained on all copies

package gui;

import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.awt.Component;
import java.awt.Point;
import javax.swing.text.*;
import java.sql.SQLException;
import java.awt.event.*; 
import java.io.File;
import languages.*;

public class Input implements ActionListener, ListSelectionListener {
  private About about; 
  protected int mode = 0;
  private JProgressBar progressBar = new JProgressBar(0, 100);
  private Prefs addVerb;
  private ArrayList languages;
  private DataCtrl dataCtrl; 
  private String crit = "A critical error has occured.  Please consult the help file in the install directory";
  private String critE = "Critical Error";
  private String dataP = "Database problem";
  
public Input() {
    try { initialise(); }
    
    catch (java.lang.NullPointerException e){ critical(crit,critE);
    System.out.println("null pointer" + e.toString());
    }
    catch (java.sql.SQLException e) { critical(crit,critE); 
    System.out.println("sql exception");
    }
    catch (java.util.NoSuchElementException e){ critical(crit,critE); 
    System.out.println("no such element");
    }
    catch (Exception e) { critical(crit,critE); 
    System.out.println(e.toString());
    }
}

protected ArrayList returnLangs() { return languages; }

//create the language obs
private void initialise() throws SQLException, Exception {    
    dataCtrl = new DataCtrl(); 
    Loader l = new Loader();

    languages = l.returnLangs();  
    TableFactory tf = new TableFactory();
    //populate the language objects
    Language lang;
    languages = tf.initialiseLangs(languages,dataCtrl,this);  
 
    //make it only possible to select one table at once
    for (int i=0;i<languages.size();i++){
          lang = (Language)languages.get(i);
    
    tableSelect(lang.returnMainTable(), lang.returnSubTable());
    tableSelect(lang.returnSubTable(), lang.returnMainTable());
      
    }
}

//update the swing look by installing a row renderer for col1
//liquid look an feel does not use this method !
protected void updateTables(){
    Language lang;   
    RowRenderer rr;
    for (int i=0;i<languages.size();i++){
        //update main table
        lang = (Language)languages.get(i);
        rr = new RowRenderer(lang.returnMainTable(), lang.returnRowRenderer());
      //  rr.setLook(look);
        SwingUtilities.updateComponentTreeUI(lang.returnMainTable());
        TableColumnModel columnModel = lang.returnMainTable().getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        column.setCellRenderer(rr);
        //update subtable
        rr = new RowRenderer(lang.returnAuxTable(),lang.returnAuxRenderer()); 
       // rr.setLook(look);
        SwingUtilities.updateComponentTreeUI(lang.returnAuxTable());
        columnModel = lang.returnAuxTable().getColumnModel();
        column = columnModel.getColumn(0);
        column.setCellRenderer(rr);
    }
}


//set and return the verb label of the current verb - only called during setup
protected JLabel returnVerbLab(Language lang, String verb) { 
    try {
      lang.setLabl(" Verb:  " + verb + ", " + dataCtrl.getDesc(verb, lang.returnTable2Q()));
        }
    catch (SQLException e){System.out.println("Sql exception with description query");}    
    return lang.returnLabl(); 
}

private void mark(Language lang){
    JTable theTable = lang.returnMainTable();
    JTable theTableSm = lang.returnSubTable();
    Table model = (Table)theTable.getModel();
    Table modelS = (Table)theTableSm.getModel();
    Renderer render = (Renderer)theTable.getDefaultRenderer(Object.class);
    render.clearPoints();
    render = (Renderer)theTableSm.getDefaultRenderer(Object.class);
    int totalVerbs = ((model.getRowCount() * model.getColumnCount()) + (modelS.getRowCount() 
    * modelS.getColumnCount()) - model.getRowCount());
    int percentage = totalVerbs;
    String tableVal; String realVal;
    stopTableEdits(theTable);
    stopTableEdits(theTableSm);     
    Collator esp = lang.returnCol();
    String[][] main=null; String[][] sub=null;
    try {
    main = returnData(lang.returnTable2Q(), lang.returnVerb(), lang.returnView());
    sub = returnSubData(lang.returnTable2Q(),lang.returnVerb());
    }
    catch (SQLException e){ critical(dataP, "Unknown database problem"); }
    for (int x = 0;x<main.length;x++){
        for (int y = 0;y<main[0].length;y++){
        if (x==0 && y==0){continue;}
            if (y==0) { continue; }
        tableVal = (String)theTable.getValueAt(x,y);   
        tableVal.trim();
        realVal = main[x][y];
        if (esp.compare(tableVal,realVal) != 0) {if (tableVal.length() != 1 || tableVal.length() != 0) {collectMistakes(x,y,model,render);}percentage--;}
        }
    }
    
    for (int a = 0;a<sub.length;a++){
        for (int b = 0;b<sub[0].length;b++){
        tableVal = (String)theTableSm.getValueAt(a,b);   
        realVal = sub[a][b];
        if (esp.compare(tableVal,realVal) != 0) {if (tableVal.length() != 1 || tableVal.length() != 0) {collectMistakesSm(a,b,modelS,render);}percentage--;}
        }
}
    //calculate %
    double total = ((double)percentage / (double)totalVerbs) * 100;  
    
    if (total < 50) { realVal = "Try again, " + (int)total + "%"; }
            else if (total < 80){ realVal = "Not bad, " + (int)total + "%"; }
            else if (total < 100){ realVal = "Good, " + (int)total + "%"; }
            else {realVal = "Perfect :)";}
    resetProgressBar((int)total,realVal);
}

private void collectMistakes(int x, int y,Table model,Renderer renderer){
    //if blank we leave it. else we color text in red
    Point point = new Point(x,y);
    renderer.pointToColor(point);
    model.fireTableCellUpdated(x, y);
}

private void collectMistakesSm(int x, int y,Table modelS,Renderer renderer){
    Point point = new Point(x,y);
    renderer.pointSmToColor(point);
    modelS.fireTableCellUpdated(x, y);
}

//populate the table with right answers
private void solution(Language lang){
    JTable theTable = lang.returnMainTable();
    JTable theTableSm = lang.returnSubTable();
    Table model = (Table)theTable.getModel();
    Table modelS = (Table)theTableSm.getModel();
    Renderer render = (Renderer)theTable.getDefaultRenderer(Object.class);
    render.clearPoints();
    render = (Renderer)theTableSm.getDefaultRenderer(Object.class);
    stopTableEdits(theTable);
    stopTableEdits(theTableSm);
    //now fill with data
    try {
    String[][] main = returnData(lang.returnTable2Q(), lang.returnVerb(), lang.returnView());
    String[][] sub = returnSubData(lang.returnTable2Q(),lang.returnVerb());
    model.resetData(main);
    modelS.resetData(sub);
    }
    catch (SQLException e){ critical(dataP, "Unknown database problem"); }
}

private void hinta(Language lang) {
    JTable theTable = lang.returnMainTable();
    JTable theTableSm = lang.returnSubTable();
    Table model = (Table)theTable.getModel();
    Table modelS = (Table)theTableSm.getModel();
    Renderer render = (Renderer)theTable.getDefaultRenderer(Object.class);
    render.clearPoints();
    render = (Renderer)theTableSm.getDefaultRenderer(Object.class);
    render.clearPoints();
    String[][] main=null; String[][] sub=null;
    try {
    main = returnData(lang.returnTable2Q(), lang.returnVerb(), lang.returnView());
    sub = returnSubData(lang.returnTable2Q(),lang.returnVerb());
    }
    catch (SQLException e){ critical(dataP, "Unknown database problem"); }
    int x;int y;
    String hint;
    if  (theTable.isEditing()) {
        y = theTable.getSelectedColumn();
        x = theTable.getSelectedRow();
        hint = main[x][y];
        theTable.getCellEditor().stopCellEditing();
        theTable.setValueAt(hint,x,y);
        theTable.editCellAt(x,y);
        Component aComp = theTable.getEditorComponent();aComp.requestFocus();
        model.upDate();
       }
    
    else if (theTableSm.isEditing()){
        y = theTableSm.getSelectedColumn();
        x = theTableSm.getSelectedRow();   
        hint = sub[x][y];
      if (theTableSm.isEditing()) {
        theTableSm.getCellEditor().stopCellEditing();
        theTableSm.setValueAt(hint,x,y);
        theTableSm.editCellAt(x,y);
        Component aComp = theTableSm.getEditorComponent();aComp.requestFocus();
        modelS.upDate();
        }
    }    
}

//provides the search window
protected void showSearch(Language lang){
        Prefs prefs = new Prefs();
        prefs.jCan.addActionListener(this);
        Object[] strVerbs = lang.returnEntries().toArray();
        Arrays.sort(strVerbs,lang.returnCol()); 
        JList select = new JList(strVerbs);
        select.addListSelectionListener(this);  
        JScrollPane scroller1 = new JScrollPane(select); 
        prefs.setLang(lang);
        prefs.displayInputDialog(null, "", "Search", prefs.fastSearch(scroller1,select),123);       
        //we use the prefs object to handle the inflect search
}
//the option boxes need to be kept in language objects// so when they are asked
//for they come from the lang ob
private void dataChange(Language lang, String verb) {
try {  
        JTable main = lang.returnMainTable();
        JTable sub = lang.returnSubTable();
        Table model = (Table)main.getModel();
        Table modelSub = (Table)sub.getModel();
        if (mode == 1 && main.isEditing()){
            int row = main.getEditingRow();
            int col = main.getEditingColumn();
            main.getCellEditor(row,col).stopCellEditing();
        }
        if (mode == 1 && sub.isEditing()){
            int row = sub.getEditingRow();
            int col = sub.getEditingColumn();
            sub.getCellEditor(row,col).stopCellEditing();        
        }
        model.resetData(returnData(lang.returnTable2Q(), verb, lang.returnView()));
        modelSub.resetData(returnSubData(lang.returnTable2Q(),verb));
        lang.setVerb(verb);
        int x = searchBin(lang);
        lang.returnCombo().setSelectedIndex(x);
        lang.setLabl("Verb: " + verb + ", " + dataCtrl.getDesc(verb, lang.returnTable2Q()));
        desc="";
        verbName="";
        if (mode==1){ Gui.save(true); }
}
catch (SQLException e){ critical(dataP, "Database update failed"); }  
}

//listen on the list in the search window for changes
public void valueChanged(ListSelectionEvent e) {
    JList tempJl;
    int indX;
    if (e.getValueIsAdjusting()) { return; }
    
    tempJl = (JList)e.getSource();
    if (tempJl.isSelectionEmpty()) { return; } 
    else {
    String verb = (String)tempJl.getSelectedValue();
    indX = tempJl.getSelectedIndex();
    //have to add this line for earlier java versions which dont do this by auto
    tempJl.scrollRectToVisible(tempJl.getCellBounds(indX,indX));
    int i = Gui.getActiveTab();
    Language lang = (Language)languages.get(i);
    dataChange(lang,verb);
    };   
}

//backwards forwards buttons
private void navButs(Language lang, String eventStr){
    int x = searchBin(lang);
    ArrayList verbAry = lang.returnEntries();  
    switch(x){
            case -1:{ System.out.println("Unexpected"); break; }            
            case 0:{
                if (eventStr.equals("Back")) { dataChange(lang,(String)verbAry.get(verbAry.size()-1));break; }
                   
                else { dataChange(lang,(String)verbAry.get(x+1));break; }
                    }
            default:
                if ((x == verbAry.size()-1) && eventStr.equals("Forward")){dataChange(lang, (String)verbAry.get(0));break;}
                if (eventStr.equals("Back")){dataChange(lang,(String)verbAry.get(x-1));}
                            else { dataChange(lang,(String)verbAry.get(x+1)); }             
        }   
}

private int searchBin(Language lang){
    String curVerb = lang.returnVerb();
    int x = lang.returnEntries().indexOf(curVerb);
    return x;
}

//changes alignment of text in table
protected void align(Language lang,String align){
    Renderer renderer = lang.getRenderer();
    renderer.align(align);

    Table model = (Table)lang.returnMainTable().getModel();
    Table modelSub = (Table)lang.returnSubTable().getModel();
    Table modelAux = (Table)lang.returnAuxTable().getModel();
    Renderer render = (Renderer)lang.returnAuxTable().getDefaultRenderer(Object.class);
    render.align(align);
    model.upDate();
    modelSub.upDate();
    modelAux.upDate();
}

private JComboBox select;
protected JComboBox popCombo(Language lang)   {
    Object[] strVerbs = lang.returnEntries().toArray();
    select = new JComboBox(strVerbs);
    select.setActionCommand("combo");
    select.addActionListener(this);
    select.setSelectedIndex(0);
    lang.setCombo(select);
    return select;
}

//returns the data to update the table model
private String[][] returnData(String table, String verb, String view) throws SQLException {
    String[][] mainData = dataCtrl.getMainData(verb, table, view);
    return mainData; 
}

protected JProgressBar returnProgressBar(){ return progressBar; }

//returns the subdata to update the table model
private String[][] returnSubData(String table, String verb) throws SQLException {
    String[][] subData = dataCtrl.getSubData(verb,table);
    return subData;
}

//show the about dialog
//this wud be better static, cud do away with the boolean then
boolean notCalled = true;
protected void showAbout(int tab){
    if(notCalled){about = new About();notCalled=false;}
    about.showMe(tab);  
}

//query each language ob for verb count
protected String noVerbs(){
    String counts = "";
    for ( int i=0;i<languages.size();i++ ) {
        Language lang = (Language)languages.get(i);
        counts += lang.returnLang() + " " + lang.returnEntries().size() + " ";
    }
return counts;
}

//label displayin verb count
protected JLabel getTotalVerbs(){
   JLabel totVerbs = new JLabel("Total Verbs:  " + noVerbs());
    return totVerbs;
}

//show the marking preferences window
//each language has a preference for marking
protected void showPrefs(Language lang){
    String langStr = lang.returnLang();
    Prefs pref = new Prefs();
    pref.si.addActionListener(this);
    pref.no.addActionListener(this);
    pref.displayInputDialog(null, "Select your marking preference for: " + langStr, "Marking Preference", pref.prefsDialog(), JOptionPane.QUESTION_MESSAGE);   
}

//dealing with view
protected void viewMode(Language lang){mode = 0;
    //Gui.modeOptions(mode);  
    lang.getRenderer().mode(true); 
    lang.returnCombo().setEnabled(true);
    Table table = (Table)lang.returnMainTable().getModel();
    table.changeEdit(false);
    table = (Table)lang.returnSubTable().getModel();
    table.changeEdit(false);    
    dataChange(lang, lang.returnVerb());
}

//dealing with editing
protected void editMode(Language lang){mode = 1;
    //Gui.modeOptions(mode);
    lang.returnCombo().setEnabled(true);
    lang.getRenderer().mode(false);    
    Table table = (Table)lang.returnMainTable().getModel();
    table.changeEdit(true);
    table = (Table)lang.returnSubTable().getModel();
    table.changeEdit(true);  
    dataChange(lang, lang.returnVerb());
}

protected void testMode(Language lang){  
    mode = 2;      
    //make random choice
    //if (item == null) {
    Random random = new Random();
    lang.returnCombo().setEnabled(false);
    String test = (String)lang.returnEntries().get((Math.abs(random.nextInt())%lang.returnEntries().size()));
    //}
    //currentVerb = item; //was item
    dataChange(lang, test);
    lang.getRenderer().mode(true);
    lang.getRenderer().clearPoints();
    Table m = (Table)lang.returnMainTable().getModel();
    m.changeEdit(true);  
    Table s = (Table)lang.returnSubTable().getModel();
    s.changeEdit(true);  
    stopTableEdits(lang.returnMainTable());stopTableEdits(lang.returnSubTable());
    m.fillArraysEmpty();
    s.fillArraysEmpty();   
    resetProgressBar(0,"0%");
}

private void resetProgressBar(int total, String str){ 
    progressBar.setValue(total);
    progressBar.setString(str);
}

private void accentButs(int accent, Language lang){     
    Object value;
    String acent = "";
    JTable theTable = lang.returnMainTable();
    JTable theTableSm = lang.returnSubTable();
    Table model = (Table)theTable.getModel();
    Table modelS = (Table)theTableSm.getModel();
    int x;int y;
    switch (accent){
        case 0:{acent = "";break;}
        case 1:{acent = "";break;}
        case 2:{acent = "";break;}
        case 3:{acent = "";break;}
        case 4:{acent = "";break;}
        case 5:{acent = "";break;}
        case 6:{acent = "";break;}
        
        case 7:{acent = "";break;}
        case 8:{acent = "";break;}
        case 9:{acent = "";break;}
        case 10:{acent = "";break;}
        case 11:{acent = "";break;}
        case 12:{acent = "";break;}
        case 13:{acent = "";break;}
        case 14:{acent = "";break;}
        case 15:{acent = "";break;}
        case 16:{acent = "";break;}
        case 17:{acent = "";break;}
        case 18:{acent = "";break;}
        default:{break;}
    }
    
    if (theTable.isEditing()   && (mode == 2 || mode == 1 )) {
        x = theTable.getEditingRow();
        y = theTable.getEditingColumn();
        
        theTable.getCellEditor().stopCellEditing();  
        value = theTable.getValueAt(x,y);
        acent = returnAccent((CellEdit)theTable.getCellEditor(x,y), value.toString(),acent);

        theTable.setValueAt(acent,x,y);
        theTable.editCellAt(x,y);
        Component aComp = theTable.getEditorComponent();aComp.requestFocus();
        model.upDate();
        }
    
    else if (theTableSm.isEditing() && ( mode == 2 || mode == 1)) {
        x = theTableSm.getEditingRow();
        y = theTableSm.getEditingColumn();
         
        theTableSm.getCellEditor().stopCellEditing();
        value = theTableSm.getValueAt(x,y);
        acent = returnAccent((CellEdit)theTableSm.getCellEditor(x,y), value.toString(),acent);

        theTableSm.setValueAt(acent,x,y);
        theTableSm.editCellAt(x,y);
        Component aComp = theTableSm.getEditorComponent();aComp.requestFocus();
        modelS.upDate();   
    } 
}

private String returnAccent(CellEdit ce, String val, String acent ){
    int pos = ce.getCaretPos();
       if (pos < val.length()) { 
            String one = val.substring(0, pos); 
            String two = val.substring(pos, val.length()); 
            return one + acent + two;
            }
    
    if (pos >= val.length()) { return val + acent; }  
return acent + val;
}

private String desc="";
private String verbName="";
protected void editVerbDesc(Language lang){
int user = userVerify("Edit Description !", "Edit this verbs' description ? ");
    if (user == 0) {     
    //change the label etc, and temporarily store the new verb and desc here in input
    addVerb = new Prefs();
    addVerb.jOk.addActionListener(this);    
    addVerb.displayInputDialog(null, "Enter new description", "Edit Description",addVerb.editDesc(), JOptionPane.QUESTION_MESSAGE);    
    }
}

protected void editVerbDesc(String descSt, Language lang){
    editMode(lang);
    Gui.modeOptions(1);
    //set the language label
    lang.setLabl("Verb: " + lang.returnVerb() + ", " + descSt);
    Gui.save(true);
    desc = descSt;
}

private void stopTableEdits(JTable aTable){
     if (aTable.isEditing()) {
         aTable.clearSelection();
         aTable.getCellEditor().stopCellEditing();
     }
}

protected boolean addLanguage() {
    JFileChooser fc = new JFileChooser();
    //fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
    int returnVal = fc.showOpenDialog(fc);
    
    //get the user file and pass it to datactrl
    if(returnVal == JFileChooser.APPROVE_OPTION) { //fc.getSelectedFile().getName();
    File file = fc.getSelectedFile();
    System.out.println(file.getName());
    System.out.println(file.getAbsolutePath());
    try {
    Language lang = (Language)( Class.forName( file.getAbsolutePath() ).newInstance() );
    System.out.println(lang.returnTable2Q() +" " + lang.returnAuxTable2Q());
    }
    catch (ClassNotFoundException e){e.printStackTrace();}
    catch (InstantiationException e) {e.printStackTrace();}
    catch (IllegalAccessException e) {e.printStackTrace();}
    
    }
    return true;
}


protected void saveChange(Language lang) {

    int user = userVerify("Commit changes!", "Permanently save changes ? ");
    if (user == 0) {
    //when the user changes the desc or the verb
    //this info kept in input
    
    //firstly stop table editing
    stopTableEdits(lang.returnMainTable());
    stopTableEdits(lang.returnSubTable());
    //if verb input string is null then this is not a new verb
    //we are editing an existing verb
    //and send all the data to dataCtrl, and the desc string
    //datactrl takes and edits the existing verb record
    if (verbName.equals("")){
        try {
        Table dataM = (Table)lang.returnMainTable().getModel();
        Table dataS = (Table)lang.returnSubTable().getModel();
        String[][] m = dataM.returnData();
        String[][] s = dataS.returnData();
        dataCtrl.editVerb(lang, m, s, desc,lang.returnVerb(), new Boolean(true));   
        Gui.save(false);
        } //end try
        catch (SQLException e){ critical(dataP, "Database update failed"); }
        }
    //verb in input string is not null, this is a new verb
    //we are making a new record
    //send all the data to datactrl, the verb and desc string
    else {
        try {
        Table dataM = (Table)lang.returnMainTable().getModel();
        Table dataS = (Table)lang.returnSubTable().getModel();
        String[][] m = dataM.returnData();
        String[][] s = dataS.returnData();
        dataCtrl.editVerb(lang, m, s, desc, verbName.toLowerCase(),new Boolean(false));   
        Gui.save(false);
        lang.setEntries(dataCtrl.getVerbs(lang.returnTable2Q()));
        DefaultComboBoxModel newModel = new DefaultComboBoxModel(lang.returnEntries().toArray());
        lang.returnCombo().setModel(newModel);       
        lang.setVerb(verbName.toLowerCase());
        verbName = verbName.substring(0, 1).toUpperCase() + verbName.substring(1, verbName.length()).toLowerCase();
        int x = lang.returnEntries().indexOf(verbName);
        lang.returnCombo().setSelectedIndex(x);
        } //end try
        catch (SQLException e){ critical(dataP, "Database update failed"); }
    }
    Gui.setTotalVerbs(getTotalVerbs());
    }  
}

protected boolean checkExists(Language lang, String verb) {
    verb = verb.substring(0, 1).toUpperCase() + verb.substring(1, verb.length()).toLowerCase();
    int x = lang.returnEntries().indexOf(verb);    
    if (x!= -1) { return true; }
    return false;
}

protected void newEntry(String verb, String descSt, Language lang) {
        if (checkExists(lang, verb))
        {
        critical(verb + " already exists !", "Error");        
        }
        else {//put in edit mode
        editMode(lang);
        Gui.modeOptions(1);
        //set the language label
        lang.setLabl("Verb: " + verb.toLowerCase() + ", " + descSt);
        //set tables blank
        //get the model an call a method to set the data null
        Table main = (Table)lang.returnMainTable().getModel();
        Table sub = (Table)lang.returnSubTable().getModel();
        main.fillArraysEmpty();
        sub.fillArraysEmpty();
        verbName = verb.toLowerCase();
        desc = descSt; 
        Gui.save(true);
        }
}

protected void addEntry(Language lang) {
    int user = userVerify("Add verb!", "Permanently add a new verb to " + lang.returnLang()+" ? ");
    //go ahead and add it 
    if (user == 0) {
    //display the new verb sindow
    addVerb = new Prefs();    
    addVerb.jOk.addActionListener(this);
    addVerb.displayInputDialog(null, "Enter verb name and description", "New Verb",addVerb.editVerbsDialog(), JOptionPane.QUESTION_MESSAGE);   
}
}

protected void deleteEntry(Language lang){
    try {
    //send a warning to the user before they delete the word
    int user = userVerify("Delete verb!", "Permanently delete " + lang.returnVerb() + " from " + lang.returnLang()+" ! ");
    //go ahead and delete it
    if (user == 0) {
    int x = searchBin(lang); //get position of the entry in jcombobox   
    dataCtrl.deleteVerb(lang.returnTable2Q(), lang.returnVerb());
    //update the language arraylist, and set data to next entry    
    lang.returnCombo().removeItemAt(x);  
    lang.setEntries(dataCtrl.getVerbs(lang.returnTable2Q()));   
    //if theres any problems set x-0 and the list will always go to first entry
    dataChange(lang, (String)lang.returnEntries().get(x));    
    //update the verbs label in gui    
    Gui.setTotalVerbs(getTotalVerbs());
    }  
    }//end try block
    catch (SQLException e){ critical(dataP, "Database update failed"); }  
}

protected int userVerify(String ques, String head){
     Object[] options = { "Yes", "Cancel" };
     int rtnMsg  = JOptionPane.showOptionDialog(null, head, ques,
                 JOptionPane.DEFAULT_OPTION, JOptionPane.WARNING_MESSAGE,null, options, options[1]);
    return rtnMsg; 
}

private void tableSelect(JTable main, final JTable small){
    main.addMouseListener(new MouseAdapter(){
		public void mousePressed(MouseEvent e_) {				
                stopTableEdits(small);
                small.getSelectionModel().clearSelection();
		}
});
    
}

boolean intialise = false;
public void actionPerformed(java.awt.event.ActionEvent e) { 
        if (Gui.getActiveTab()==-1 || intialise==false){return;}
        
        String eventStr;
        eventStr = e.getActionCommand(); 
        Language lang = (Language)returnLangs().get(Gui.getActiveTab()); 
        if (eventStr.equals("combo")){
        
        if (mode!=2){
        String item;
        JComboBox cb = (JComboBox)e.getSource();
        item = (String)cb.getSelectedItem();
        //get the current lang from current tab
        dataChange(lang,item);
        }
        }
        if (eventStr.equals("Back") || eventStr.equals("Forward")) { navButs(lang, eventStr); }       
        if (eventStr.equals("Left")) {align(lang, eventStr);}
        if (eventStr.equals("Centre")) {align(lang, eventStr);}
        if (eventStr.equals("Right")) {align(lang, eventStr);}
        if (eventStr.equals("Find")) { showSearch(lang); }
        if (eventStr.equals("Help")) {showAbout(1);}
        if (eventStr.equals("Prefs")) { showPrefs(lang); }
        if (eventStr.equals("Mark Accents")) { lang.markingStrictness(new Boolean(true)); }
        if (eventStr.equals("Ignore Accents")) { lang.markingStrictness(new Boolean(false)); }
        if (eventStr.equals("Delete")) { deleteEntry(lang); }
        if (eventStr.equals("Ok")){ newEntry(addVerb.verbName.getText(),addVerb.verbDesc.getText(),lang); }
        if (eventStr.equals("editDesc")){ editVerbDesc(addVerb.verbDesc.getText(),lang); }
        if (eventStr.equals("Save")){ saveChange(lang); }
        if (eventStr.equals("Skip")) {if (mode != 2) {toUser();} else testMode(lang); }
        if (eventStr.equals("addN")) { accentButs(0, lang); }
        if (eventStr.equals("addA")) { accentButs(1, lang); }
        if (eventStr.equals("addE")) { accentButs(2, lang); }
        if (eventStr.equals("addI")) { accentButs(3, lang); }
        if (eventStr.equals("addO")) { accentButs(4, lang); }
        if (eventStr.equals("addU")) { accentButs(5, lang); }
        if (eventStr.equals("addUU")) { accentButs(6,lang); } 
        
        if (eventStr.equals("fra1")) { accentButs(7,lang); } 
        if (eventStr.equals("fra2")) { accentButs(8,lang); } 
        if (eventStr.equals("fra3")) { accentButs(9,lang); } 
        if (eventStr.equals("fra4")) { accentButs(10,lang); } 
        if (eventStr.equals("fra5")) { accentButs(11,lang); } 
        if (eventStr.equals("fra6")) { accentButs(12,lang); } 
        if (eventStr.equals("fra7")) { accentButs(13,lang); } 
        if (eventStr.equals("fra8")) { accentButs(14,lang); } 
        if (eventStr.equals("fra9")) { accentButs(15,lang); } 
        if (eventStr.equals("fra10")) { accentButs(16,lang); } 
        if (eventStr.equals("fra11")) { accentButs(17,lang); } 
        if (eventStr.equals("fra12")) { accentButs(18,lang); } 

        if (eventStr.equals("Hinta")) { if (mode != 2) { toUser(); } else hinta(lang); }
        if (eventStr.equals("Mark")) { if (mode != 2) { toUser(); } else mark(lang); }
        if (eventStr.equals("Sol")) {if (mode != 2) {toUser();} else solution(lang); } 
}

private void critical(String expl, String header){
JOptionPane.showMessageDialog(null,expl,header,JOptionPane.WARNING_MESSAGE);
}
private void toUser(){
    JOptionPane.showMessageDialog(null,"This option is for use in 'Test' mode only","Info",JOptionPane.INFORMATION_MESSAGE);
}



}