  //* @(#)GUI.Language  1  2006
  //Copyright (c) 2006 Ric Bottomley
  //All rights reserved. 
  //This material is provided "as is", with absolutely no warranty expressed
  //or implied. Any use is at your own risk.
  //Permission to use or copy this software is hereby granted without fee, 
  //provided this copyright notice is retained on all copies

package gui;
import java.util.ArrayList;
import javax.swing.JTable;
import java.text.Collator;
import javax.swing.JLabel;
import javax.swing.JComboBox;

/**
 *
 * @author rix
 */
public interface Language {
    String verb="";
    //return the language name
    public String returnLang();
    //return the name of the db table to query
    public String returnTable2Q();
    //return all tenses in the main table
    public String[] returnCols();
    //return the pronouns (rows of the main table)
    public String[] returnRowRenderer();
    //return all tenses for the subTable, (imperative etc)
    public String[] returnImps();
    
    //may change all this
    //return data for the aux table
    public String[] returnAux();
    //return the rows for the aux table
    public String[] returnAuxRenderer();
    //return the name of the aux table
    public String returnAuxTable2Q();
    

    //return cols for maindata retrieval
    public String returnView();    
    //return the collator
    public Collator returnCol();
    //set the arraylist containing all the entries
    public void setEntries(ArrayList ary);
    //return the arraylist of verbs
    public ArrayList returnEntries();
    //return the main table 
    public JTable returnMainTable();
    //return the sub table
    public JTable returnSubTable();
    //return aux table
    public JTable returnAuxTable();
    //set the tables
    public void setTable(JTable m, JTable s, JTable aux);
    //set desc and current verb
    public void setLabl(String labl);
    //return the label
    public JLabel returnLabl();
    //return/set the current verb held in the table
    public String returnVerb();
    public void setVerb(String verb);
    //return/set the combo for this language
    public JComboBox returnCombo();
    public void setCombo(JComboBox cb);
    //return/set the renderer
    public void setRenderer(Renderer r);
    public Renderer getRenderer();
    //set the marking preference
    public void markingStrictness(Boolean b);
    //get the inflect query
    public String getInflectQ();
    
}

