  //* @(#)Prefs.java  1  2006
  //Copyright (c) 2006 Ric Bottomley
  //All rights reserved. 
  //This material is provided "as is", with absolutely no warranty expressed
  //or implied. Any use is at your own risk.
  //Permission to use or copy this software is hereby granted without fee, 
  //provided this copyright notice is retained on all copies

package gui;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import javax.swing.text.*;
import javax.swing.event.*;
import java.sql.SQLException;

public class Prefs extends JOptionPane implements ActionListener {
    
 protected JRadioButton si = new JRadioButton("Mark Accents",true);
 protected JRadioButton no = new JRadioButton("Ignore Accents");
 protected JButton jOk = new JButton("Ok"); 
 protected JButton jOk2 = new JButton("Ok"); 
 protected JButton jCan = new JButton("Cancel"); 
 protected JButton jSrc = new JButton("Search");
 protected JTextField verbName = new JTextField("Verb",15);
 protected JTextField verbDesc = new JTextField("Description",15);
 protected JTextField strSearch;
 protected JTextField strInflect;
 private JList select;
 private JDialog dialog;
 private Language lang = null;
 public Prefs(){}
 
 public int displayInputDialog(Component parentComponent,
        Object message,
        String title,
        JPanel jP, int messageType)       
        {
         setMessage(message);
         if (messageType==123) {setIcon(new ImageIcon("toolBarPics/Find.gif"));}
         else { setMessageType(messageType); 
         setIcon(null);            
         }
                
                 
         Object[] options =  {jP};   
 
         setOptions(options);
         dialog = this.createDialog(parentComponent, title);
         setSelectionValues(null);
         setInitialSelectionValue(null);
        
         ((JButton)jOk).addActionListener(new ActionListener()  {
		public void actionPerformed(ActionEvent ae)  {
		   dialog.dispose();
                }});
                             
             ((JButton)jCan).addActionListener(new ActionListener()  {
		public void actionPerformed(ActionEvent ae)  {
		   dialog.dispose();
                }});

         dialog.show();
        
            return 1;
 }
//set the langobject, only really used when making inflected searchs 
protected void setLang(Language l) { lang = l; }

//carry out the inflected search, and adjust set tables and lists to word
private String inflectSearch(String query) {
String verb = "";
try {
    verb = DataCtrl.inflectSearch(lang.getInflectQ(),query, lang.returnTable2Q());
    }
catch (SQLException e){System.out.println("sql exception");}  
return verb;
}


//set up dialog for marking preference
protected JPanel prefsDialog(){     
      ButtonGroup group = new ButtonGroup();               
         group.add(si);
         group.add(no);
      JPanel comp = new JPanel();
      comp.setLayout(new BoxLayout(comp,BoxLayout.Y_AXIS));
      comp.add(si);
      si.setAlignmentX(Component.CENTER_ALIGNMENT);
      comp.add(no);
      no.setAlignmentX(Component.CENTER_ALIGNMENT);
      comp.add(Box.createRigidArea(new Dimension(0,10)));
      comp.add(jOk);
      jOk.setAlignmentX(Component.CENTER_ALIGNMENT);
      return comp;
}

//dialog for editing verb name or desc
protected JPanel editDesc(){
JPanel comp = new JPanel();
      comp.setLayout(new BoxLayout(comp,BoxLayout.Y_AXIS));
      comp.add(verbDesc);
      no.setAlignmentX(Component.CENTER_ALIGNMENT);      
      JPanel butons = new JPanel();
      jOk.setActionCommand("editDesc");
      butons.add(jOk);butons.add(jCan);
      comp.add(Box.createRigidArea(new Dimension(0,10)));
      comp.add(butons);     
return comp;
}

//set up dialog for new verb 
protected JPanel editVerbsDialog(){
JPanel comp = new JPanel();
      comp.setLayout(new BoxLayout(comp,BoxLayout.Y_AXIS));
      comp.add(verbName);
      si.setAlignmentX(Component.CENTER_ALIGNMENT);
      comp.add(Box.createRigidArea(new Dimension(0,5)));
      comp.add(verbDesc);
      no.setAlignmentX(Component.CENTER_ALIGNMENT);      
      JPanel butons = new JPanel();
      butons.add(jOk);butons.add(jCan);
      comp.add(Box.createRigidArea(new Dimension(0,10)));
      comp.add(butons);     
return comp;
}

//set up dialog for adding new language
protected JPanel addLanguage(){
    JPanel comp = new JPanel();
    JFileChooser chooser = new JFileChooser();
    chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
int returnVal = chooser.showOpenDialog(this);
    if(returnVal == JFileChooser.APPROVE_OPTION) {
      System.out.println("You chose to open this file: " + returnVal +
           chooser.getSelectedFile().getName());
    }

if(returnVal == JFileChooser.CANCEL_OPTION) {
    System.out.println("here");       
    }
    
comp.add(chooser);
    return comp;
}

protected JPanel fastSearch(JScrollPane search, JList select1){    
//set different action string for jok
    select = select1;
    jSrc.addActionListener(this);
    jSrc.setActionCommand("srcBut");
    JPanel comp = new JPanel();
    strSearch = new JTextField();
    strSearch.setActionCommand("search");
    strSearch.addActionListener(this);
    strSearch.setPreferredSize(new Dimension(90,25));
    JLabel srlbl = new JLabel("Quick search (infinitive)");
    
    JLabel inflect = new JLabel("Inflected verb, ie tengo");
    strInflect = new JTextField();
    strInflect.setActionCommand("inflect");
    strInflect.addActionListener(this);
    strInflect.setPreferredSize(new Dimension(90,25));
    
    
    comp.setLayout(new BoxLayout(comp,BoxLayout.Y_AXIS));
    comp.add(search);
    comp.add(Box.createRigidArea(new Dimension(0,10)));
    comp.add(srlbl);
    srlbl.setAlignmentX(Component.CENTER_ALIGNMENT);
    comp.add(strSearch);
    comp.add(Box.createRigidArea(new Dimension(0,10)));
    comp.add(inflect);
    inflect.setAlignmentX(Component.CENTER_ALIGNMENT);
    comp.add(strInflect);
    comp.add(Box.createRigidArea(new Dimension(0,5)));
    comp.add(Box.createRigidArea(new Dimension(0,10)));
    JPanel butons = new JPanel();
    butons.add(jSrc);butons.add(jCan);
    comp.add(butons);     
    comp.setMaximumSize(new Dimension(45,45));
   
    
    strSearch.getDocument().addDocumentListener(new DocumentListener() {
    public void insertUpdate(DocumentEvent e) { 
    int pos = select.getNextMatch(strSearch.getText(), 0, Position.Bias.Forward);
    select.ensureIndexIsVisible(pos);
    select.setSelectedIndex(pos);
    }                  
 
    public void removeUpdate(DocumentEvent e) { 
    int pos = select.getNextMatch(strSearch.getText(), 0, Position.Bias.Forward);
    select.ensureIndexIsVisible(pos);
    select.setSelectedIndex(pos);
    }
    public void changedUpdate(DocumentEvent e) {}		
    });

   select.addKeyListener(new KeyAdapter() {
   public void keyReleased(KeyEvent ke) {
    if (ke == null) { return; }
      if (ke.getKeyCode() == KeyEvent.VK_ENTER) {
        dialog.dispose();
       
        }} 
    
   });
    
    return comp;
}

//if the user searchs, the search listener in input updates the table to reflect the list
//so for the inflected search, it cud that this class makes
public void actionPerformed(java.awt.event.ActionEvent e) {
   String eventStr;
   eventStr = e.getActionCommand();  
   if (eventStr.equals("search")) {
   int pos = select.getNextMatch(strSearch.getText(), 0, Position.Bias.Forward);
   select.ensureIndexIsVisible(pos);
   select.setSelectedIndex(pos);
   dialog.dispose();
   }
   //called when return is pressed on the inflect search box
   if (eventStr.equals("inflect") || eventStr.equals("srcBut") ) {
       eventStr = strInflect.getText();
       if (eventStr.equals("")) { return; }
       String result = inflectSearch(eventStr);
       if (result!=null){
       //set list to position of query
       int pos = select.getNextMatch(result, 0, Position.Bias.Forward);
       select.ensureIndexIsVisible(pos);
       select.setSelectedIndex(pos);
       }
       else { strInflect.setText(strInflect.getText() + " : No match"); }   
   }

}


}
