  //* @(#)GUI.Renderer  1  2006
  //Copyright (c) 2006 Ric Bottomley
  //All rights reserved. 
  //This material is provided "as is", with absolutely no warranty expressed
  //or implied. Any use is at your own risk.
  //Permission to use or copy this software is hereby granted without fee, 
  //provided this copyright notice is retained on all copies

package gui;

import javax.swing.table.DefaultTableCellRenderer;
import java.awt.Component;
import javax.swing.JTable;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
//import com.birosoft.liquid.LiquidLookAndFeel.*;

public class Renderer extends DefaultTableCellRenderer {
private ArrayList points = new ArrayList();
private ArrayList pointsSm = new ArrayList();
private boolean mode3 = false;
private boolean isAux = false;
//set the render so it knows whether it is rendering a jtable
/** Creates a new instance of Renderer */
public Renderer() {}

public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
    if (hasFocus){isSelected = true;}
    Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);

    if (mode3) { 
        //check to see if point is in arraylist
        //check which table
        if (isAux) { return this;}
        Point temp = new Point(row,column);
        if (table.getRowCount() > 1)  {
        if (existsInList(temp)) { cell.setForeground(Color.red); }
        else cell.setForeground(Color.black);
        return this; 
    }
        if (existsInListSm(temp)) { cell.setForeground(Color.red); }
        else cell.setForeground(Color.black);
        return this; 
    
    }
//check that we are dealing with the sub Table
//stripe the sub table
//whatever we do it has to be consistent as this class repaints the cells    
    return this;
}
      
protected void mode(boolean mode){ mode3 = mode; }
protected void setAux() {isAux = true;}

protected void clearPoints(){ points.clear();pointsSm.clear(); }

private boolean existsInList(Point point ){
//chek to see if in list and if yes return true
        for (int i=0; i<points.size(); i++) {
        if (point.equals((Point)points.get(i))){return true;}
        }
        return false;
}

private boolean existsInListSm(Point point ){
//chek to see if in list and if yes return true
        for (int i=0; i<pointsSm.size(); i++) {
        if (point.equals((Point)pointsSm.get(i))){return true;}
        }
        return false;
}

protected void pointToColor(Point aPoint) { points.add(aPoint); }
protected void pointSmToColor(Point aPoint) { pointsSm.add(aPoint); }

protected void align(String align){
    if (align.equals("Left")){setHorizontalAlignment( LEFT );}
    if (align.equals("Right")){setHorizontalAlignment( RIGHT );}
    if (align.equals("Centre")){setHorizontalAlignment( CENTER );}
}

}