  //* @(#)Table.java  1  2006
  //Copyright (c) 2006 Ric Bottomley
  //All rights reserved. 
  //This material is provided "as is", with absolutely no warranty expressed
  //or implied. Any use is at your own risk.
  //Permission to use or copy this software is hereby granted without fee, 
  //provided this copyright notice is retained on all copies

package gui;
import javax.swing.table.AbstractTableModel;

public class Table extends AbstractTableModel{

private String[][] data;       
private String[] colNames;
private int rows;
private boolean editable = false;

public Table(String[] collNames, int rowNo, String[][] newData) {
    data = newData;
    colNames = collNames; 
    rows = rowNo;
}

public void resetData(String[][] newData) {
    data = new String[newData.length][newData[0].length];
    for( int i = 0; i < newData.length; i++ ) { System.arraycopy( newData[i],0,data[i],0,newData[i].length ); }
    upDate();
}

//this works with align buttons
protected void upDate(){ fireTableRowsUpdated(0, data[0].length); }

protected void changeEdit(boolean edit) {editable = edit;}

protected String[][] returnData(){ return data; }

//called when a new verb is added
public void fillArraysEmpty(){
    for (int x = 0;x<data.length;x++){
        for (int y = 0;y<data[0].length;y++){
            data[x][y] = " ";
        resetData(data);
        }
    }
}

public int getRowCount() { return rows; }

public int getColumnCount() { return colNames.length; }

public Object getValueAt(int rowX, int colX) {
   //have to return something here or ther'd be a null point exception
    if ((colX==0) && (rows > 1)){return "";}
   return data[rowX][colX];   
}

//called when the cell is edited
public boolean isCellEditable(int row, int col){ return editable; }

public String getColumnName(int col) {return colNames[col];}

//when the user enters a value in a cell, this method is auto called
public void setValueAt (Object word, int row, int col){ 
    if ( word != null ) { data[row][col] = word.toString().trim(); }
    }
}
