/*
 * TableFactory.java
 *
 * Created on January 31, 2006, 2:00 AM
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package gui;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableCellRenderer;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.table.JTableHeader;
import java.awt.Dimension;
//import com.birosoft.liquid.LiquidLookAndFeel.*;
import java.awt.event.*; 
import java.util.Arrays;
/**
 *
 * @author rix
 */
//this class parses the language ob[] for the table spec and returns the required table
public class TableFactory {
    Language language; 
    Renderer renderer = new Renderer();
    Renderer render = new Renderer();
    

    
protected ArrayList initialiseLangs(ArrayList languages, DataCtrl dataCtrl, Input input) throws SQLException {
    //create the table models for each language
    
    Object[] temp;
    ArrayList tempAl;
    for (int i=0;i<languages.size();i++){
        
        language = (Language)languages.get(i);
        
        //get the arraylist of verb entries     
        tempAl = dataCtrl.getVerbs(language.returnTable2Q());
        //sort the array with the collator  
        //this should mean we dont have to resort in input class
        Object[] strVerbs = tempAl.toArray();
        Arrays.sort(strVerbs,language.returnCol());
        //change the array back to an arraylist        
        tempAl = new ArrayList( Arrays.asList(strVerbs) );
        language.setEntries(tempAl);
        
        //set the table model for the main data
        Table modelMain = new Table(language.returnCols(),language.returnRowRenderer().length, 
        dataCtrl.getMainData((String)language.returnEntries().get(0), language.returnTable2Q(),
        language.returnView()));
        
        //set the table model for the sub data
        Table modelSub = new Table(language.returnImps(),1, 
        dataCtrl.getSubData((String)language.returnEntries().get(0),language.returnTable2Q())); 
        
        //set the data for the auxillary table
        Table modelAux = new Table(language.returnAux(),language.returnAuxRenderer().length, 
        dataCtrl.getAuxData(language.returnAuxTable2Q()));
             
        JTable main = new JTable(modelMain);
        JTable sub = new JTable(modelSub);
        JTable aux = new JTable(modelAux);
        
        //used to communicxate with liquid hack
        sub.setShowVerticalLines(true);
        main.setShowVerticalLines(false);
        aux.setShowVerticalLines(false);
        
        JTableHeader header;
        header = main.getTableHeader();
        header.setPreferredSize(new Dimension(0,20));
        header = sub.getTableHeader();
        header.setPreferredSize(new Dimension(0,20));
        header = aux.getTableHeader();
        header.setPreferredSize(new Dimension(0,20));
        
        //set the data for rendering the auxillary rows         
        main.setDefaultRenderer(Object.class, renderer);
        //main.setShowGrid(false);

        sub.setDefaultRenderer(Object.class, renderer);
        
        //AlternateRender ar = new AlternateRender();
        //sub.setDefaultRenderer(Object.class, ar);

        main.setCellSelectionEnabled(true);
        sub.setCellSelectionEnabled(true);
        render.setAux();
        aux.setDefaultRenderer(Object.class, render);
        
        
        
        main.setDefaultEditor(Object.class, new CellEdit());
        sub.setDefaultEditor(Object.class, new CellEdit());
        
        main.getTableHeader().setReorderingAllowed(false);
        sub.getTableHeader().setReorderingAllowed(false);
        //set the renderer which render the 1st table coloumn as if it was a table header
        TableCellRenderer renderRows = new RowRenderer(main,language.returnRowRenderer());
        TableColumnModel columnModel = main.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        column.setCellRenderer(renderRows);
        
        renderRows = new RowRenderer(aux,language.returnAuxRenderer()); 
        columnModel = aux.getColumnModel();
        column = columnModel.getColumn(0);
        column.setCellRenderer(renderRows);
        //main.setShowHorizontalLines(false);
        //main.setShowVerticalLines(true);
                

//prevents the table from drawing rows, defualt is true
//com.birosoft.liquid.LiquidLookAndFeel.setDefaultRowBackgroundMode(false);
//prevents the liquid drawing a grid
//com.birosoft.liquid.LiquidLookAndFeel.setShowTableGrids(false);
//for some reason liquid wont do a vertical grid so ill implemet this myself    
        
        //set a better row height
        for (int j=0;j<main.getRowCount(); j++)
        {
        main.setRowHeight(j,20);
        }    
        sub.setRowHeight(0,20);
         
//set the renderer
        language.setRenderer(renderer);
        //now set the tables in the object
        language.setTable(main,sub,aux);
        //set the current verb
        language.setVerb((String)language.returnEntries().get(0));
        //add the focus listeners for the input object
  
    
    }
return languages;
    }

        
    } 
    

