import java.io.*;
import java.util.*;

import javax.swing.JOptionPane;

import net.sf.vietpad.VietComparator;
import net.sf.vietpad.VietPadWithTools;

/**
 *  Performs tasks when started by double-clicking the archive or with java -jar.
 *  A Mac OS X application bundle should start net.sf.vietpad.VietPadWithTools
 *  directly.
 *
 *@author     Gero Herrmann
 *@created    2003-04-13
 */
public class VietPad
{

    /**
     *  The main program for the VietPad class
     *
     *@param  args  The command line arguments
     */
    public static void main(String[] args) throws IOException {

        String jreVersion = System.getProperty("java.version");
        if (jreVersion.compareTo("1.4") < 0) {
            JOptionPane.showMessageDialog(null,
                            "Could not launch the application because\n" +
                            "it requires Java 1.4 or later.\n" +
                            "The current Java version is " + jreVersion + ".",
                            "Insufficient Java Version", JOptionPane.ERROR_MESSAGE);
            System.exit(1);
        }

        if (args.length > 0 && args[0].equals("-s")) {
            final List list = new ArrayList();

            final BufferedReader in = new BufferedReader(new InputStreamReader(
                    new FileInputStream(new File(args[1])), "UTF-8"));
            while (true) {
                final String line = in.readLine();
                if (line == null) {
                    break;
                }
                list.add(line);
            }
            in.close();

            final Object[] array = list.toArray();
            Arrays.sort(array, new VietComparator());
            final BufferedWriter out = new BufferedWriter(new OutputStreamWriter(
                    new FileOutputStream(new File(args[2])), "UTF-8"));
            for (int i=0; i<array.length; i++) {
                out.write(array[i].toString());
                out.newLine();
            }
            out.close();
            System.exit(0);
        }
        
        System.setProperty("swing.aatext", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        VietPadWithTools vietPad = new VietPadWithTools();
        if (args.length > 0) {
            File file = new File(args[0]);
            try {
                // get long filename for files dropped on a .bat file under
                // some versions of Windows
                file = file.getCanonicalFile();
            } catch (IOException e) {
                // will be handled by the GUI
            }
            vietPad.openDocument(file);
        }
    }

}
