package com.swabunga.spell.swing;

import com.swabunga.spell.event.SpellCheckEvent;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/** Implementation of a spell check dialog.
 *
 * @author Jason Height (jheight@chariot.net.au)
 */
public class JSpellDialog extends JDialog implements ActionListener
 {
  private JSpellForm form = new JSpellForm();
  private SpellCheckEvent event = null;

  public JSpellDialog(Frame owner, String title, boolean modal) {
    super(owner, title, modal);
    initialiseDialog();
    setResizable(false);
  }

  public JSpellDialog(Dialog owner, String title, boolean modal) {
    super(owner, title, modal);
    initialiseDialog();
  }

  private void initialiseDialog() {
    getContentPane().add(form);
    form.addActionListener(this);
    
    addWindowListener(new WindowAdapter() {
      /** Cancel the event if the Dialog Close button is pressed*/
      public void windowClosing(WindowEvent e) {
        if (event != null)
          event.cancel();
      }
    });
    //setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);
    pack();
  }

  public void show(SpellCheckEvent e) {
    // System.out.println("Show");
    this.event = e;
    form.setSpellEvent(e);
    setVisible(true);
  }

  public void actionPerformed(ActionEvent e) {
    setVisible(false);
  }
}
