package net.sf.vietpad;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.ResourceBundle;

/**
 *  Convert Dialog
 *
 *@author     Quan Nguyen
 *@created    March 11, 2005
 *@version    1.3
 */
public class ConvertDialog extends JDialog {
    private ResourceBundle myResources = ResourceBundle.getBundle("Resources");
    private final JButton jButtonClose = new JButton(myResources.getString("Close"));
    private final JButton jButtonConvert = new JButton(myResources.getString("Convert"));
    private final JCheckBox jCheckBoxHTML= new JCheckBox(myResources.getString("HTML_Source"));
    private final JComboBox jComboBoxEncoding = new JComboBox();
    private final JLabel jLabel = new JLabel(myResources.getString("From:"));
    private final JPanel jPanel = new JPanel();;


    /**
     *  Creates new form ConvertDialog
     *
     *@param  owner  the Frame from which the dialog is displayed
     *@param  modal  true for a modal dialog
     */
    public ConvertDialog(Frame owner, boolean modal) {
        super(owner, modal);
        setLocale(owner.getLocale());         
        initComponents();

        //  Handle escape key to hide the dialog
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0, false);
        Action escapeAction =
            new AbstractAction() {
                public void actionPerformed(ActionEvent e) {
                    setVisible(false);
                }
            };
        getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(escapeKeyStroke, "ESCAPE");
        getRootPane().getActionMap().put("ESCAPE", escapeAction);
    }


    /**
     *  Called from within the constructor to initialize the form
     */
    private void initComponents() {

        setTitle(myResources.getString("Convert_to_Unicode"));
        setName("dialogConvert");
        setResizable(false);
        addWindowListener(
            new WindowAdapter() {
                public void windowClosing(WindowEvent e) {
                    setVisible(false);
                }
            });

        GridBagLayout gridbag = new GridBagLayout();
        jPanel.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = GridBagConstraints.WEST;

        c.gridx = 0;
        c.gridy = 0;
        c.insets.left = 1;
        c.insets.bottom = 1;
        c.insets.right = 3;
        gridbag.setConstraints(jLabel, c);
        jLabel.setLabelFor(jComboBoxEncoding);
        jPanel.add(jLabel);
        c.insets.bottom = 0;
        
        c.gridx = 1;
        c.insets.bottom = 0;
        c.insets.top = 2;
        gridbag.setConstraints(jComboBoxEncoding, c);
        jComboBoxEncoding.setMaximumRowCount(99);
        jComboBoxEncoding.setFont(jLabel.getFont());
        jComboBoxEncoding.setModel(new DefaultComboBoxModel(VietEncodings.valueOf(new String[] {
                "ISC", "NCR", "TCVN3 (ABC)", "Unicode Composite", "UTF-8", "VIQR/Vietnet", "VISCII", "VNI", "VPS"})));
        jComboBoxEncoding.setToolTipText(myResources.getString("Source_Encoding"));
        jComboBoxEncoding.setName(myResources.getString("Source_Encoding"));
        jPanel.add(jComboBoxEncoding);

        c.gridy = 1;
        c.insets.bottom = 3;
        gridbag.setConstraints(jCheckBoxHTML, c);
        jPanel.add(jCheckBoxHTML);

        c.gridx = 2;
        c.gridy = 1;
        c.insets.left = 2;
        c.insets.bottom = 4;
        c.fill = GridBagConstraints.HORIZONTAL;
        gridbag.setConstraints(jButtonClose, c);
        jPanel.add(jButtonClose);
        
        jButtonClose.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent evt) {
                    setVisible(false);
                }
            });

        getRootPane().setDefaultButton(jButtonConvert);
        c.gridy = 0;
        c.insets.top = 2;
        c.insets.bottom = 2;
        gridbag.setConstraints(jButtonConvert, c);
        jPanel.add(jButtonConvert);

        jButtonConvert.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent evt) {
                    final VietPadWithTools frame = (VietPadWithTools) getOwner();

                    getGlassPane().setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
                    getGlassPane().setVisible(true);
                    frame.getGlassPane().setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
                    frame.getGlassPane().setVisible(true);

                    try {
                        frame.convert((VietEncodings) jComboBoxEncoding.getSelectedItem(), jCheckBoxHTML.isSelected());
                    } catch (OutOfMemoryError e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(frame, VietPad.APP_NAME
                                 + myResources.getString("_has_run_out_of_memory.\nPlease_restart_") + VietPad.APP_NAME
                                 + myResources.getString("_and_try_again."), myResources.getString("Out_of_Memory"), JOptionPane.ERROR_MESSAGE);
                    } finally {
                        SwingUtilities.invokeLater(
                            new Runnable() {
                                public void run() {
                                    frame.getGlassPane().setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
                                    frame.getGlassPane().setVisible(false);
                                    getGlassPane().setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
                                    getGlassPane().setVisible(false);
                                    getRootPane().setDefaultButton(jButtonClose);
                                }
                            });
                    }
                }
            });

        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 11, 8, 9));
        getContentPane().add(jPanel);

        pack();
        setLocationRelativeTo(getOwner());
    }


    /**
     *  Sets the source code selection
     *
     *@param  i  The new selectedIndex value
     */
    void setSelectedIndex(int i) {
        jComboBoxEncoding.setSelectedIndex(i);
    }


    /**
     *  Gets the source code selection
     *
     *@return    The selectedIndex value
     */
    int getSelectedIndex() {
        return jComboBoxEncoding.getSelectedIndex();
    }


    /**
     *  Sets the HTML attribute of the ConvertDialog object
     *
     *@param  b  The HTML value
     */
    void checkHTML(boolean b) {
        jCheckBoxHTML.setSelected(b);
    }
    
    
    /**
     *  Shows and hides the dialog
     */
    public void setVisible(final boolean flag) {
        if (flag) {
            super.setVisible(true);
            // switch default button twice to make it pulse in Mac OS X
            getRootPane().setDefaultButton(jButtonClose);
            getRootPane().setDefaultButton(jButtonConvert);
            // send to back and front to get focus in Metal and CDE/Motif
            toBack();
            toFront();
            jComboBoxEncoding.requestFocus();
        } else {
            // switch default button to make it appear immediately upon re-opening
            getRootPane().setDefaultButton(jButtonConvert);
            jPanel.paintImmediately(jPanel.getBounds());
            super.setVisible(false);
        }
    }
}
