/*
 * InputMethods.java
 *
 * Created on December 27, 2004, 11:02 AM
 */

package net.sf.vietpad;

/**
 *
 * @author Quan Nguyen
 */

// Supported Vietnamese input methods

//public enum InputMethods // Java 1.5 enum
//{
//    VNI, VIQR, Telex
//}

// The typesafe enum pattern
/**
 * Enum constants for supported Vietnamese input methods.
 */
public class InputMethods {
    private final String method;

    /**
     * Returns the string representation of this enum constant.
     */
    public String toString()  { return method; }
       
    /**
     * Returns the enum constant of <code>InputMethods</code> type with the specified method.
     *
     * @param method one of the supported input methods: VNI, VIQR, or Telex. Unsupported methods are default to Telex.
     */
    public static InputMethods valueOf(String method) {
        if (method.equals("VNI")) return VNI;
        else if (method.equals("VIQR")) return VIQR;
        else return Telex;
    }
    
    private InputMethods(String method) { this.method = method; }

    public static final InputMethods VNI = new InputMethods("VNI");
    public static final InputMethods VIQR = new InputMethods("VIQR");
    public static final InputMethods Telex = new InputMethods("Telex");
}
