package net.sf.vietpad;

import java.awt.*;
import java.awt.event.*;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.text.*;

/**
 *  Preferences dialog
 *
 *@author     Quan Nguyen
 *@created    on June 10, 2003, 2:44 PM
 *@version    1.1, 18 October 2003
 */
public class PreferencesDialog extends JDialog
{
    // Variables declaration
    private ButtonGroup buttonGroup, buttonGroup2;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxEOL, jCheckBoxRepeatKey;
    private JPanel jPanelGeneral, jPanel2, jPanel3, jPanel4, jPanel5, jPanelUI, jPanel6;
    private JRadioButton jRButtonClassic, jRButtonModern;
    private ResourceBundle myResources = ResourceBundle.getBundle("Resources");
    private JTabbedPane jTabbedPane;
    private JRadioButton jRButtonEng, jRButtonViet;
    private boolean previousLocaleVN;


    /**
     *  Creates new form PreferencesDialog
     *
     *@param  owner  Owner of Preferences dialog
     *@param  modal  modal or non-modal
     */
    public PreferencesDialog(Frame owner, boolean modal) {
        super(owner, modal);
        setLocale(owner.getLocale());
        initComponents();

        //  Handle escape key to hide the dialog
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0, false);
        Action escapeAction =
            new AbstractAction()
            {
                public void actionPerformed(ActionEvent e) {
                    setVisible(false);
                }
            };
        getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(escapeKeyStroke, "ESCAPE");
        getRootPane().getActionMap().put("ESCAPE", escapeAction);
    }


    /**
     *  Initializes the form
     */
    private void initComponents() {
        final GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jTabbedPane = new JTabbedPane();

        buttonGroup = new ButtonGroup();
        jPanelGeneral = new JPanel();
        jPanelUI = new JPanel();
        jPanel3 = new JPanel();
        jRButtonModern = new JRadioButton();
        jRButtonClassic = new JRadioButton();
        jPanel4 = new JPanel();
        jCheckBoxEOL = new JCheckBox();
        jPanel5 = new JPanel();
        jCheckBoxRepeatKey = new JCheckBox();
        buttonGroup2 = new ButtonGroup();
        jPanel6 = new JPanel();
        jRButtonEng = new JRadioButton();
        jRButtonViet = new JRadioButton();
        jButtonOK = new JButton();

        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(myResources.getString("Preferences"));
        setResizable(false);
        addWindowListener(
            new WindowAdapter()
            {
                public void windowClosing(WindowEvent evt) {
                    setVisible(false);
                    dispose();
                }
            });

        jPanelGeneral.setLayout(new GridBagLayout());

        jPanel3.setLayout(new BoxLayout(jPanel3, BoxLayout.Y_AXIS));

        jPanel3.setBorder(new TitledBorder(myResources.getString("Diacritics_Position")));
        jRButtonModern.setText(myResources.getString("Modern") + " (o\u00e0, o\u00e8, u\u00fd)");
        buttonGroup.add(jRButtonModern);
        jPanel3.add(jRButtonModern);

        jRButtonClassic.setSelected(true);
        jRButtonClassic.setText(myResources.getString("Classic") + " (\u00f2a, \u00f2e, \u00fay)");
        buttonGroup.add(jRButtonClassic);
        jPanel3.add(jRButtonClassic);

        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        jPanelGeneral.add(jPanel3, gridBagConstraints);

        jPanel5.setLayout(new BoxLayout(jPanel5, BoxLayout.Y_AXIS));

        jPanel5.setBorder(new TitledBorder(myResources.getString("Remove_Diacritics")));
        jCheckBoxRepeatKey.setText(myResources.getString("Consume_Repeat_Key"));
        jPanel5.add(jCheckBoxRepeatKey);

        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        jPanelGeneral.add(jPanel5, gridBagConstraints);

        jPanel4.setLayout(new BoxLayout(jPanel4, BoxLayout.Y_AXIS));

        jPanel4.setBorder(new TitledBorder(myResources.getString("Line_Separators") + " (CRLF, LF)"));
        jCheckBoxEOL.setText(myResources.getString("Always_Save_with_Platform_Default"));
        jPanel4.add(jCheckBoxEOL);

        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanelGeneral.add(jPanel4, gridBagConstraints);
        setOpaque(jPanelGeneral, false);
        jTabbedPane.addTab(myResources.getString("General"), jPanelGeneral);

        jPanelUI.setLayout(new GridLayout(0, 1));

        jPanel6.setLayout(new BoxLayout(jPanel6, BoxLayout.Y_AXIS));
        jPanel6.setBorder(new TitledBorder(myResources.getString("Language")));
        jRButtonEng.setText("System Default (" + VietPad.systemDefault.getDisplayLanguage() + ")");
        buttonGroup2.add(jRButtonEng);
        jPanel6.add(jRButtonEng);
        jRButtonViet.setText(VietPad.VIETNAM.getDisplayLanguage());
//      jRButtonViet.setEnabled(!VietPad.MAC_OS_X);
        buttonGroup2.add(jRButtonViet);
        jPanel6.add(jRButtonViet);
        jPanelUI.add(jPanel6);
        jPanelUI.add(Box.createVerticalGlue());
        setOpaque(jPanelUI, false);
        jTabbedPane.addTab(myResources.getString("User_Interface"), jPanelUI);

        getContentPane().add(jTabbedPane, BorderLayout.CENTER);

        jButtonOK.setText(myResources.getString("OK"));
        getRootPane().setDefaultButton(jButtonOK);
        jButtonOK.addActionListener(
            new ActionListener()
            {
                public void actionPerformed(ActionEvent evt) {
                    setVisible(false);
                    if (previousLocaleVN != isLocaleVN()) {
                        JOptionPane.showMessageDialog(PreferencesDialog.this.getOwner(),
                                myResources.getString("Restart_me"),
                                VietPad.APP_NAME, JOptionPane.INFORMATION_MESSAGE);
                    }
                    ((VietPadWithTools) getOwner()).retrieveOptions();
                }
            });

        jPanel2 = new JPanel(new FlowLayout(FlowLayout.RIGHT));
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel2.add(jButtonOK);
        getContentPane().add(jPanel2, BorderLayout.SOUTH);

        pack();
        setLocationRelativeTo(getOwner());
    }


    /**
     *  Sets the platform default EOL
     *
     *@param  defaultEOLOn
     */
    void setDefaultEOL(boolean defaultEOLOn) {
        jCheckBoxEOL.setSelected(defaultEOLOn);
    }


    /**
     *  Gets the platform default EOL
     *
     *@return    boolean is platform default EOL selected?
     */
    boolean isDefaultEOL() {
        return jCheckBoxEOL.isSelected();
    }


    /**
     *  Sets the diacritics marking classic style
     *
     *@param  classic
     */
    void setDiacriticsPosition(boolean classic) {
        if (classic) {
            jRButtonClassic.setSelected(true);
        } else {
            jRButtonModern.setSelected(true);
        }
    }


    /**
     *  Gets the diacritics marking classic style
     *
     *@return    boolean is the diacritics marking style classic?
     */
    boolean isDiacriticsPosClassic() {
        return jRButtonClassic.isSelected();
    }


    /**
     *  Sets repeatKeyConsumed
     *
     *@param  mode  The new repeatKeyConsumed value
     */
    void setRepeatKeyConsumed(boolean mode) {
        jCheckBoxRepeatKey.setSelected(mode);
    }


    /**
     *  Gets whether repeatKeyConsumed
     *
     *@return    boolean is platform default EOL selected?
     */
    boolean isRepeatKeyConsumed() {
        return jCheckBoxRepeatKey.isSelected();
    }


    /**
     *  Sets the default locale
     *
     *@param  localeVN  The new localeVN value
     */
    void setLocaleVN(boolean localeVN) {
        if (localeVN) {
            jRButtonViet.setSelected(true);
        } else {
            jRButtonEng.setSelected(true);
        }
        previousLocaleVN = localeVN;
    }


    /**
     *  Gets the default locale (this may not be the same as system's default locale)
     *
     *@return   localeVN    The new localeVN value
     */
    boolean isLocaleVN() {
        return jRButtonViet.isSelected();
    }


    /**
     *  Sets the opaque attribute of a component and subcomponents. In the Mac OS X Aqua and Windows XP
     *  look-and-feel, a JPanel in a tabbed pane should not obscure the color of the background.
     *
     *@param    component   component
     *@param    isOpaque    true if this component and subcomponents should be opaque
     */
    public static void setOpaque(JComponent component, boolean isOpaque) {
        component.setOpaque(isOpaque);
        Component[] c = component.getComponents();
        for (int i = 0; i < c.length; i++) {
            if (c[i] instanceof JComponent    // in case of heavyweights
                    && !(c[i] instanceof JTextComponent || c[i] instanceof JList)) {
                setOpaque((JComponent) c[i], isOpaque);
            }
        }
    }

}
