/*
 * ShortHandDialog.java
 *
 * @author  Quan Nguyen
 * @created on June 1, 2003, 2:52 PM
 * @version 1.3, 29 May 2004
 */

package net.sf.vietpad;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ShortHandDialog extends JDialog {
  
    // Variables declaration
    private ButtonGroup buttonGroup1;
    private JButton jButtonAdd, jButtonCancel, jButtonDelete, jButtonEdit, jButtonOK;
    private JCheckBox jCheckBox;
    private JLabel jLabelKey, jLabelValue;
    private JList jList;
    private JPanel jPanel1, jPanel2, jPanel3, jPanel4, jPanel5, jPanel6, jPanel7;
    private JScrollPane jScrollPane;
    private JTextField jTextFieldKey, jTextFieldValue;
    private String key, value;
    private DefaultListModel listModel;
    private Properties map;
    private VietKeyListener keyLst, valueLst;   
    private Font dialogFont;
    private ResourceBundle myResources = ResourceBundle.getBundle("Resources");
    
    /**
     * Creates new form ShortHandDialog
     */
    public ShortHandDialog(final Frame owner, boolean modal) {
        super(owner, modal);
        setLocale(owner.getLocale());               
        setResizable(VietPad.MAC_OS_X);        
        initComponents();       
                      
        //  Handle escape key to hide the dialog
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0, false);
        Action escapeAction =
            new AbstractAction() {
                public void actionPerformed(ActionEvent e) {
                    setVisible(false);
                }
            };
        getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(escapeKeyStroke, "ESCAPE");
        getRootPane().getActionMap().put("ESCAPE", escapeAction);
        
        WindowListener flst =
            new WindowAdapter()
            {
                public void windowActivated(WindowEvent e)
                {                   
                    // For use with VietIME input method (http://vietime.sf.net)         
                    getInputContext().selectInputMethod(owner.getInputContext().getLocale());
                }
            };
        addWindowListener(flst);        
    }
    
    /**
     * initialize the form.
     */
    private void initComponents() {
        GridBagConstraints gridBagConstraints;
        dialogFont = new Font(VietPad.MAC_OS_X ? "Lucida Grande" : "Tahoma", 0, 12);
        buttonGroup1 = new ButtonGroup();
           
        jPanel1 = new JPanel();
        jPanel3 = new JPanel();
        jPanel5 = new JPanel();
        jLabelKey = new JLabel(myResources.getString("Key:"));

        jTextFieldKey = new JTextField();
        jTextFieldKey.addKeyListener(new VietKeyListener(jTextFieldKey));      
        jTextFieldKey.setFont(dialogFont);
        jTextFieldKey.setDocument(new LimitedLengthDocument(6));        
        jPanel6 = new JPanel();
        jLabelValue = new JLabel(myResources.getString("Value:"));
        jTextFieldValue = new JTextField();
        jTextFieldValue.addKeyListener(new VietKeyListener(jTextFieldValue));         
        jTextFieldValue.setFont(dialogFont);
        jTextFieldValue.setDocument(new LimitedLengthDocument(35));             
        jPanel4 = new JPanel();
        jPanel2 = new JPanel();
        jButtonAdd = new JButton(myResources.getString("Add"));
        jButtonAdd.setMnemonic('a');
        jButtonEdit = new JButton(myResources.getString("Edit_SH"));
        jButtonEdit.setMnemonic('e');
        jButtonDelete = new JButton(myResources.getString("Delete"));
        jButtonDelete.setMnemonic('d');
//        jButtonSort = new JButton("Sort");
//        jButtonSort.setMnemonic('s');
        jPanel7 = new JPanel();
        jCheckBox = new JCheckBox(myResources.getString("Activate_Shorthand"));
        jButtonOK = new JButton(myResources.getString("OK"));
        jButtonCancel = new JButton(myResources.getString("Cancel"));
       
        listModel = new DefaultListModel();
        jList = new JList(listModel);
        jList.setVerifyInputWhenFocusTarget(false);
        jList.setFont(dialogFont);        
        jList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        jList.setVisibleRowCount(10);
        jList.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent evt) {
                if (evt.getValueIsAdjusting()) {
                    return;
                }

                String str = (String) jList.getSelectedValue();
                if (str != null) {      
                    int index = str.indexOf('=');
                    if (index != -1) {
                        jTextFieldKey.setText(str.substring(0, index));
                        jTextFieldValue.setText(str.substring(index+1));
                    }
                }
            }
        });

        setTitle(myResources.getString("Shorthand"));

        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent evt) {
                setVisible(false);
            }
        });

        jPanel1.setLayout(new BoxLayout(jPanel1, BoxLayout.Y_AXIS));
        jPanel3.setLayout(new BoxLayout(jPanel3, BoxLayout.X_AXIS));

        jPanel3.setBorder(new EmptyBorder(new Insets(19, 6, 0, 5)));
        jPanel5.setLayout(new GridLayout(0, 1));

        jPanel5.add(jLabelKey);

        jTextFieldKey.setColumns(5);
        jTextFieldKey.setInputVerifier(new InputVerifier() {
            public boolean verify(JComponent comp) {
                boolean returnValue = true;
                JTextField textField = (JTextField) comp;
                String content = textField.getText();
                if (content.length() != 0) {
                    if (content.indexOf(' ') != -1 || content.indexOf('=') != -1) {
                        returnValue = false;
                    }
                }
                return returnValue;
            }
            public boolean shouldYieldFocus(JComponent input) {
                boolean valid = super.shouldYieldFocus(input);
                if (!valid) {
                    getToolkit().beep();
                    input.setInputVerifier(null);
                    JOptionPane.showMessageDialog(null, myResources.getString("Cannot_use_space_or_=_in_Key._Please_try_again."),
                            myResources.getString("Invalid_Value"), JOptionPane.WARNING_MESSAGE);
                    input.setInputVerifier(this);
                }
                return valid;
            }

        });
        jTextFieldKey.addFocusListener(new FocusAdapter() {
            public void focusGained(FocusEvent evt) {
                jTextFieldKey.selectAll();
            }
        });

        jPanel5.add(jTextFieldKey);

        jPanel3.add(jPanel5);
        jPanel3.add(Box.createHorizontalStrut(6));

        jPanel6.setLayout(new GridLayout(0, 1));

        jPanel6.add(jLabelValue);

        jTextFieldValue.setColumns(20);
        jTextFieldValue.addFocusListener(new FocusAdapter() {
            public void focusGained(FocusEvent evt) {
                jTextFieldValue.selectAll();
            }
        });

        jPanel6.add(jTextFieldValue);

        jPanel3.add(jPanel6);

        jPanel1.add(jPanel3);

        jPanel4.setLayout(new BorderLayout());

        jPanel4.setBorder(new EmptyBorder(new Insets(7, 6, 6, 6)));
        jScrollPane = new JScrollPane(jList);
        jPanel4.add(jScrollPane);

        jPanel1.add(jPanel4);

        getContentPane().add(jPanel1);
        getContentPane().add(Box.createHorizontalStrut(13), BorderLayout.WEST);

        jPanel2.setLayout(new GridBagLayout());

        jPanel2.setBorder(new EmptyBorder(new Insets(8, 8, 12, 17)));
        jButtonAdd.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                jButtonAddActionPerformed();
            }
        });

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = GridBagConstraints.NORTHWEST;
        jPanel2.add(jButtonAdd, gridBagConstraints);
        jButtonEdit.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                int index = jList.getSelectedIndex();        
                if (index != -1) {
                    key = jTextFieldKey.getText();
                    if (!map.containsKey(key)) {
                        return;
                    }
                    value = jTextFieldValue.getText();
                    listModel.set(index, key + "=" + value);

                    map.setProperty(key, value);
                }
            }
        });

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        jPanel2.add(jButtonEdit, gridBagConstraints);
        jButtonDelete.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                jButtonDeleteActionPerformed();
            }
        });

        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        jPanel2.add(jButtonDelete, gridBagConstraints);

//        jButtonSort.addActionListener(new ActionListener() {
//            public void actionPerformed(ActionEvent evt) {
//                sort();
//            }
//        });
//
//        gridBagConstraints = new GridBagConstraints();
//        gridBagConstraints.gridx = 0;
//        gridBagConstraints.gridy = 3;
//        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
//        jPanel2.add(jButtonSort, gridBagConstraints);

        getContentPane().add(jPanel2, BorderLayout.EAST);

        jPanel7.setLayout(new BoxLayout(jPanel7, BoxLayout.X_AXIS));

        jPanel7.setBorder(new EmptyBorder(new Insets(6, 16, 16, 17)));
        jCheckBox.setVerifyInputWhenFocusTarget(false);
        jPanel7.add(jCheckBox);

        jPanel7.add(Box.createHorizontalGlue());
        getRootPane().setDefaultButton(jButtonOK);
        jButtonOK.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                ((VietPadWithFormat) getOwner()).setShortHandMap(map, jCheckBox.isSelected());
                setVisible(false); 
            }
        });

        jButtonCancel.setVerifyInputWhenFocusTarget(false);
        jButtonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                setVisible(false);
            }
        });

        if (VietPad.MAC_OS_X) {
            jPanel7.add(jButtonCancel);
            jPanel7.add(Box.createHorizontalStrut(11));
            jPanel7.add(jButtonOK);
        } else {
            jPanel7.add(jButtonOK);
            jPanel7.add(jButtonCancel);
        }

        getContentPane().add(jPanel7, BorderLayout.SOUTH);

        pack();
        setLocationRelativeTo(getOwner());        
    }

    private void jButtonDeleteActionPerformed() {
        int index = jList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        
        key = jTextFieldKey.getText();        
        if (map.containsKey(key)) {
            map.remove(key);
        }
        
        listModel.remove(index);

        int size = listModel.getSize();

        if (size != 0) {
            //Select an index.
            if (index == listModel.getSize()) {
                //removed item in last position
                index--;
            }

            jList.setSelectedIndex(index);
            jList.ensureIndexIsVisible(index);
        }      
    }

    private void jButtonAddActionPerformed() {
        key = jTextFieldKey.getText();
        
        if (key.equals("") || map.containsKey(key)) {
            return;
        }
        
        value = jTextFieldValue.getText();

        map.setProperty(key, value);
        
        int index = jList.getSelectedIndex(); //get selected index
        if (index == -1) { //no selection, so insert at beginning
            if (listModel.getSize() != 0) {
                index = 0;
                jList.setSelectedIndex(index);
            }
        } else {           //add after the selected item
            index++;
        }
        
        if (listModel.getSize() == 0) {
            listModel.addElement(key+ "="+ value);
            
            //Select the new item and make it visible.
            jList.setSelectedIndex(0);
            jList.ensureIndexIsVisible(0);            
        }        
        else if (!((String) jList.getSelectedValue()).startsWith(key+ '=')) {
            listModel.insertElementAt(key+ "="+ value, index);
        
            //Reset the text field.
            jTextFieldKey.requestFocusInWindow();
            jTextFieldKey.setText("");

            //Select the new item and make it visible.
            jList.setSelectedIndex(index);
            jList.ensureIndexIsVisible(index);
        }

    }
    
    public void setMacroMap(Properties shortHandMap, boolean shortHandOn) {
        map = new Properties();
        map.putAll(shortHandMap);
        jCheckBox.setSelected(shortHandOn);
        listModel.clear();
        TreeMap treeMap = new TreeMap(map);
        Iterator iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry) iterator.next();
            listModel.addElement(entry.getKey() + "=" + entry.getValue());
        }
    }
       
    /**
     *  Shows and hides the dialog
     */
    public void setVisible(final boolean flag) {
        if (flag) {
            super.setVisible(true);
            // switch default button twice to make it pulse in Mac OS X
            getRootPane().setDefaultButton(jButtonCancel);
            getRootPane().setDefaultButton(jButtonOK);
            // send to back and front to get focus in Metal and CDE/Motif
            toBack();
            toFront();
            jTextFieldKey.requestFocusInWindow();
        } else {
            // switch default button to make it appear immediately upon re-opening
            getRootPane().setDefaultButton(jButtonOK);
            jPanel1.paintImmediately(jPanel1.getBounds());
            super.setVisible(false);
        }    
    }
}
