/*
 *  Copyright 1999-2002 Matthew Robinson and Pavel Vorobiev.
 *  All Rights Reserved.
 *
 *  ===================================================
 *  This program contains code from the book "Swing"
 *  2nd Edition by Matthew Robinson and Pavel Vorobiev
 *  http://www.spindoczine.com/sbe
 *  ===================================================
 */
 

package net.sf.vietpad;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;


class SmallButton extends JButton implements MouseListener {

    protected Border m_raised = new SoftBevelBorder(BevelBorder.RAISED);
    protected Border m_lowered = new SoftBevelBorder(BevelBorder.LOWERED);
    protected Border m_inactive = new EmptyBorder(3, 3, 3, 3);
    protected Border m_border = m_inactive;
    protected Insets m_ins = new Insets(4,4,4,4);

    public SmallButton(Action act, String tip, ImageIcon image) {
        this(act, tip);
        setIcon(image);
    }
    
    public SmallButton(Action act, String tip) {
        super(act);
        setText("");
        setToolTipText(tip);
        setRequestFocusEnabled(false);
        addMouseListener(this);
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    // Overridden for 1.4 bug fix
    public Border getBorder() {
        return m_border;
    }

    // Overridden for 1.4 bug fix
    public Insets getInsets() {
        return m_ins;
    }

    public void mousePressed(MouseEvent e) {
        if (isEnabled()) {
            setBorder(m_border = m_lowered);
        }
    }

    public void mouseReleased(MouseEvent e) {
        setBorder(m_border = m_inactive);
    }

    public void mouseClicked(MouseEvent e) {}

    public void mouseEntered(MouseEvent e) {
        if (isEnabled()) {
            setBorder(m_border = m_raised);
        }
    }

    public void mouseExited(MouseEvent e) {
        setBorder(m_border = m_inactive);
    }
}
