/**
 *  Sort Dialog
 *
 *@author     Quan Nguyen
 *@created    April 14, 2003
 *@version    1.2, 1 January 2004
 */

package net.sf.vietpad;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.ResourceBundle;

public class SortDialog extends JDialog {
    private ResourceBundle myResources = ResourceBundle.getBundle("Resources");
    private final JCheckBox jCheckBoxReverse = new JCheckBox(myResources.getString("Reverse_Sort"));
    private final JButton jButtonSort = new JButton(myResources.getString("Sort"));
    private final JButton jButtonClose = new JButton(myResources.getString("Close"));
    private final JPanel jPanel = new JPanel();
    private final JTextField jTextFieldDelimiter = new JTextField();
    private final JLabel jLabel = new JLabel(myResources.getString("Delimiter_for_Left-to-Right"));

    /**
     *  Creates new form SortDialog
     *
     *@param  owner  the Frame from which the dialog is displayed
     *@param  modal  true for a modal dialog
     */
    public SortDialog(Frame owner, boolean modal) {
        super(owner, modal);
        setLocale(owner.getLocale()); 
        setTitle(myResources.getString("Sort_Lines"));
        setResizable(false);
        addWindowListener(
            new WindowAdapter() {
                public void windowClosing(WindowEvent evt) {
                    setVisible(false);
                }
            });

        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));

        JPanel jPanel1 = new JPanel();
        jPanel1.setLayout(new GridLayout(0, 1));
//        jPanel1.setBorder(new TitledBorder(myResources.getString("Options")));
        jPanel1.add(jCheckBoxReverse);
        
        JPanel jPanel3 = new JPanel();        
        jPanel3.setLayout(new FlowLayout(FlowLayout.LEFT));
        jTextFieldDelimiter.setColumns(2);
        jPanel3.add(jTextFieldDelimiter);
        jPanel3.add(jLabel);
        jPanel1.add(jPanel3);
        jPanel.add(jPanel1, BorderLayout.CENTER);
        
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(FlowLayout.RIGHT));
        jPanel2.add(jButtonSort);
        jPanel2.add(jButtonClose);
        jPanel.add(jPanel2, BorderLayout.SOUTH);

        getContentPane().add(jPanel);
        getRootPane().setDefaultButton(jButtonSort);
        pack();
        setLocationRelativeTo(getOwner());

        jButtonSort.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent evt) {
                    final VietPadWithTools frame = (VietPadWithTools) getOwner();

                    getGlassPane().setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
                    getGlassPane().setVisible(true);
                    frame.getGlassPane().setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
                    frame.getGlassPane().setVisible(true);

                    try {
                        frame.sort(jCheckBoxReverse.isSelected(), jTextFieldDelimiter.getText());
                    } catch (OutOfMemoryError e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(frame, VietPad.APP_NAME
                                 + myResources.getString("_has_run_out_of_memory.\nPlease_restart_") + VietPad.APP_NAME
                                 + myResources.getString("_and_try_again."), myResources.getString("Out_of_Memory"), JOptionPane.ERROR_MESSAGE);
                    } finally {
                        SwingUtilities.invokeLater(
                            new Runnable() {
                                public void run() {
                                    frame.getGlassPane().setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
                                    frame.getGlassPane().setVisible(false);
                                    getGlassPane().setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
                                    getGlassPane().setVisible(false);
                                    getRootPane().setDefaultButton(jButtonClose);
                                }
                            });
                    }

                }
            });

        jButtonClose.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent evt) {
                    setVisible(false);
                }
            });

        //  Handle escape key to hide the dialog
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0, false);
        Action escapeAction =
            new AbstractAction() {
                public void actionPerformed(ActionEvent e) {
                    setVisible(false);
                }
            };
        getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(escapeKeyStroke, "ESCAPE");
        getRootPane().getActionMap().put("ESCAPE", escapeAction);
    }


    /**
     *  Gets the reverse attribute of the SortDialog object
     *
     *@return    The reverse value
     */
    public boolean isReverse() {
        return jCheckBoxReverse.isSelected();
    }


    /**
     *  Sets the reverse attribute of the SortDialog object
     *
     *@param  reverse  The new reverse value
     */
    public void setReverse(boolean reverse) {
        jCheckBoxReverse.setSelected(reverse);
    }


    /**
     *  Shows and hides the dialog
     */
    public void setVisible(final boolean flag) {
        if (flag) {
            super.setVisible(true);
            // switch default button twice to make it pulse in Mac OS X
            getRootPane().setDefaultButton(jButtonClose);
            getRootPane().setDefaultButton(jButtonSort);
            // send to back and front to get focus in Metal and CDE/Motif
            toBack();
            toFront();
            jCheckBoxReverse.requestFocus();
        } else {
            // switch default button to make it appear immediately upon re-opening
            getRootPane().setDefaultButton(jButtonSort);
            jPanel.paintImmediately(jPanel.getBounds());
            super.setVisible(false);
        }
    }
}
