/*
 * VietEncodings.java
 *
 * Created on March 11, 2005, 12:35 AM
 * @author Quan Nguyen
 */

package net.sf.vietpad;

// Vietnamese encodings

//public enum VietEncodings // Java 1.5 enum
//{
//    ISC, NCR, TCVN3, Unicode, Unicode_Composite, UTF8, VIQR, VISCII, VNI, VPS
//}

// The typesafe enum pattern
/**
 * Enum constants for supported Vietnamese legacy encodings.
 */
public class VietEncodings {
    private final String encoding;

    /**
     * Returns the string representation of this enum constant.
     */
    public String toString()  { return encoding; }
       
    /**
     * Returns the enum constant of <code>VietEncodings</code> type with the specified encoding.
     *
     * @param encoding One of supported encodings: "VISCII", "VPS", "VNI", "VIQR/Vietnet",
     *                        "TCVN3 (ABC)", "Unicode", "Unicode Composite", "UTF-8", ISC", or "NCR"
     */
    public static VietEncodings valueOf(String encoding) {
        if (encoding.equalsIgnoreCase("VNI")) return VNI;
        else if (encoding.equalsIgnoreCase("ISC")) return ISC;
        else if (encoding.equalsIgnoreCase("NCR")) return NCR;
        else if (encoding.equalsIgnoreCase("TCVN3 (ABC)")) return TCVN3;
        else if (encoding.equalsIgnoreCase("Unicode Composite")) return Unicode_Composite;
        else if (encoding.equalsIgnoreCase("Unicode")) return Unicode;
        else if (encoding.equalsIgnoreCase("UTF-8")) return UTF8;
        else if (encoding.equalsIgnoreCase("VIQR/Vietnet")) return VIQR;
        else if (encoding.equalsIgnoreCase("VISCII")) return VISCII;
        else if (encoding.equalsIgnoreCase("VPS")) return VPS;
        else return null;
    }
    
     /**
     * A convenient method to return an array of enum constants of <code>VietEncodings</code> type.
     *
     * @param encodingStrs Array of supported encodings: "VISCII", "VPS", "VNI", "VIQR/Vietnet",
     *                        "TCVN3 (ABC)", "Unicode", "Unicode Composite", "UTF-8", ISC", or "NCR"
     */
    public static VietEncodings[] valueOf(String[] encodingStrs) {
        VietEncodings[] encodings = new VietEncodings[encodingStrs.length];
        for (int i = 0; i < encodingStrs.length; i++) {
            encodings[i] = valueOf(encodingStrs[i]);
        }
        return encodings;
    }    
    
    private VietEncodings(String encoding) { this.encoding = encoding; }

    public static final VietEncodings ISC = new VietEncodings("ISC");
    public static final VietEncodings NCR = new VietEncodings("NCR");
    public static final VietEncodings TCVN3 = new VietEncodings("TCVN3 (ABC)");
    public static final VietEncodings Unicode_Composite = new VietEncodings("Unicode Composite");
    public static final VietEncodings Unicode = new VietEncodings("Unicode");
    public static final VietEncodings UTF8 = new VietEncodings("UTF-8");
    public static final VietEncodings VIQR = new VietEncodings("VIQR/Vietnet");
    public static final VietEncodings VISCII = new VietEncodings("VISCII");
    public static final VietEncodings VNI = new VietEncodings("VNI");
    public static final VietEncodings VPS = new VietEncodings("VPS");   
}
