/*
 * @(#)LocaleElements_vi.java   1.22 04/03/10
 */

/*
 * Portions Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * (C) Copyright Taligent, Inc. 1996, 1997 - All Rights Reserved
 * (C) Copyright IBM Corp. 1996 - 1999 - All Rights Reserved
 *
 * The original version of this source code and documentation
 * is copyrighted and owned by Taligent, Inc., a wholly-owned
 * subsidiary of IBM. These materials are provided under terms
 * of a License Agreement between Taligent and Sun. This technology
 * is protected by multiple US and International patents.
 *
 * This notice and attribution to Taligent may not be removed.
 * Taligent is a registered trademark of Taligent, Inc.
 *
 */

package sun.text.resources;

import java.util.ListResourceBundle;

public class LocaleElements_vi extends ListResourceBundle {
    /**
     * Overrides ListResourceBundle
     */
    public Object[][] getContents() {
        return new Object[][] {
            { "Languages", // language names
                new String[][] {
                    { "ar", "Tiếng A-rập" },
                    { "az", "Tiếng Ai-déc-bai-gian" },//Azerbaijani
                    { "be", "Tiếng Bê-la-rút" },//or Byelorussian
                    { "bg", "Tiếng Bun-ga-ri" },//Bulgarian
                    { "bo", "Tiếng Tây Tạng" },//Tibetan
                    { "ca", "Tiếng Ca-ta-lăng" },//Catalan
                    { "cs", "Tiếng Séc" },//Czech
                    { "da", "Tiếng Đan Mạch" },//Danish
                    { "de", "Tiếng Đức" },//German
                    { "el", "Tiếng Hy Lạp" },//Greek
                    { "en", "Tiếng Anh" },
                    { "eo", "Tiếng Quốc Tế Ngữ" },//Esperanto
                    { "es", "Tiếng Tây Ban Nha" },//Spanish
                    { "et", "Tiếng E-xtô-ni-a" },//Estonian
                    { "fa", "Tiếng Ba Tư" },//Persian
                    { "fi", "Tiếng Phần Lan" },//Finnish
                    { "fr", "Tiếng Pháp" },//French
                    { "ga", "Tiếng Ai-len" },//Irish
                    { "he", "Tiếng Hê-brơ" },//Hebrew
                    { "hi", "Tiếng Hin-đi" },//Hindi
                    { "hr", "Tiếng Crô-a-ti-a" },//Croatian
                    { "hu", "Tiếng Hung-ga-ri" },//Hungarian
                    { "hy", "Tiếng Ác-mê-ni" },//Armenian
                    { "ia", "Tiếng Khoa Học Quốc Tế" },//Interlingua
                    { "id", "Tiếng In-đô-nê-xia" },//Indonesian
                    { "in", "Tiếng In-đô-nê-xia" },//Indonesian
                    { "is", "Tiếng Ai-xơ-len" },//Icelandic
                    { "it", "Tiếng Ý" },//Italian
                    { "iw", "Tiếng Hê-brơ" },//Hebrew
                    { "ja", "Tiếng Nhật" },//Japanese
                    { "jv", "Tiếng Gia-va" },//Javanese
                    { "km", "Tiếng Campuchia" },//Cambodian
                    { "kn", "Tiếng Kan-na-đa" },//Kannada
                    { "ko", "Tiếng Hàn Quốc" },//Korean
                    { "la", "Tiếng La-tinh" },//Latin
                    { "lo", "Tiếng Lào" },//Laotian
                    { "lt", "Tiếng Lít-va" },//Lithuanian
                    { "lv", "Tiếng Lát-vi-a" },//Latvian (Lettish)
                    { "mk", "Tiếng Ma-xê-đô-ni-a" },//Macedonian
                    { "mn", "Tiếng Mông Cổ" },//Mongolian
                    { "ms", "Tiếng Ma-lay-xi-a" },//Malay
                    { "ne", "Tiếng Nê-pan" },//Nepali
                    { "nl", "Tiếng Hà Lan" },//Dutch
                    { "no", "Tiếng Na Uy" },//Norwegian
                    { "pl", "Tiếng Ba Lan" },//Polish
                    { "pt", "Tiếng Bồ Đào Nha" },//Portuguese
                    { "ro", "Tiếng Ru-ma-ni" },//Romanian
                    { "ru", "Tiếng Nga" },//Russian
                    { "sa", "Tiếng Phạn" },// Sanskrit 
                    { "sk", "Tiếng Xlô-vác" },//Slovak
                    { "sl", "Tiếng Xlô-ven" },//Slovenian
                    { "so", "Tiếng Xô-ma-li" },//Somali
                    { "sq", "Tiếng An-ba-ni" },//Albanian
                    { "sr", "Tiếng Séc-bi" },//Serbian
                    { "sv", "Tiếng Thụy Điển" },//Swedish
                    { "th", "Tiếng Thái" },//Thai
                    { "tr", "Tiếng Thổ Nhĩ Kỳ" },//Turkish
                    { "uk", "Tiếng U-crai-na" },//Ukrainian
                    { "uz", "Tiếng U-dơ-bếch" },//Uzbek
                    { "vi", "Tiếng Việt" },
                    { "yi", "Tiếng Y-đit" },//Yiddish 
                    { "zh", "Tiếng Trung Quốc" }//Chinese
                }
            },
            { "Countries", // country names
                new String[][] {
                    { "AE", "Các Tiểu Vương quốc A-rập Thống nhất" },//United Arab Emirates
                    { "AF", "Áp-ga-ni-xtan" },//A Phú Hãn, Afghanistan
                    { "AG", "An-ti-gu-a và Ba-bu-đa" },//Antigua and Barbuda
                    { "AL", "An-ba-ni" },//Albania
                    { "AM", "Ác-mê-ni-a" },//Armenia
                    { "AO", "Ăng-gô-la" },//Angola
                    { "AR", "Ác-hen-ti-na" },//Argentina
                    { "AT", "Áo" },//Austria
                    { "AU", "Úc" },//Australia
                    { "AZ", "Ai-déc-bai-gian" },//Azerbaijan
                    { "BA", "Bô-xni-a Héc-xê-gô-vi-na" },//Bosnia and Herzegovina
                    { "BB", "Bác-ba-đốt" },//Barbados
                    { "BD", "Băng-la-đét" },//Bangladesh
                    { "BE", "Bỉ" },//Belgium
                    { "BF", "Buốc-ki-na Pha-xô" },//Burkina Faso
                    { "BG", "Bun-ga-ri" },//Bulgaria
                    { "BH", "Ba-ren" },//Bahrain
                    { "BI", "Bu-run-đi" },//Burundi
                    { "BJ", "Bê-nanh" },//Benin
                    { "BN", "Bru-nây" },//Brunei
                    { "BO", "Bô-li-vi-a" },//Bolivia
                    { "BR", "Bra-xin" },//Ba Tây, Brazil
                    { "BS", "Ba-ha-ma" },//Bahamas
                    { "BW", "Bốt-xoa-na" },//Botswana
                    { "BY", "Bê-la-rút" },//Belarus
                    { "BZ", "Bê-li-xê" },//Belize
                    { "CA", "Ca-na-đa" },//Gia Nã Đại, Canada
                    { "CF", "Cộng hòa Trung Phi" },//Central African Republic
                    { "CG", "Công-gô" },//Congo
                    { "CH", "Thụy Sĩ" },//Switzerland
                    { "CI", "Bờ Biển Ngà" },//Côte d'Ivoire
                    { "CL", "Chi-lê" },//Chile
                    { "CM", "Ca-mơ-run" },//Cameroon
                    { "CN", "Trung Quốc" },//China
                    { "CO", "Cô-lôm-bi-a" },//Colombia
                    { "CR", "Cốt-xta Ri-ca" },//Costa Rica
                    { "CU", "Cu Ba" },//Cuba
                    { "CV", "Cáp-ve" },//Cape Verde
                    { "CY", "Síp" },//Cyprus
                    { "CZ", "Cộng hòa Séc" },//Czech Republic
                    { "DE", "Đức" },//Germany
                    { "DJ", "Gi-bu-ti" },//Djibouti
                    { "DK", "Đan Mạch" },//Denmark
                    { "DZ", "An-giê-ri" },//Algeria
                    { "EC", "Ê-cu-a-đo" },//Ecuador
                    { "EE", "E-xtô-ni-a" },//Estonia
                    { "EG", "Ai Cập" },//Egypt
                    { "EH", "Tây Sahara" },//Western Sahara
                    { "ER", "Ê-ri-tơ-rê-a" },//Eritrea
                    { "ES", "Tây Ban Nha" },//Spain
                    { "ET", "Ê-ti-ô-pi-a" },//Ethiopia
                    { "FI", "Phần Lan" },//Finland
                    { "FJ", "Phi-gi" },//Fiji
                    { "FM", "Mi-crô-nê-xi-a" },//Micronesia
                    { "FR", "Pháp" },//France
                    { "GA", "Ga-bông" },//Gabon
                    { "GB", "Vương quốc Anh" },//United Kingdom
                    { "GD", "Grê-na-đa" },//Grenada
                    { "GE", "Gru-di-a" },//Georgia
                    { "GH", "Gha-na" },//Ghana
                    { "GM", "Găm-bi-a" },//Gambia
                    { "GN", "Ghi-nê" },//Guinea
                    { "GQ", "Ghi-nê Xích-đạo" },//Equatorial Guinea
                    { "GR", "Hy Lạp" },//Greece
                    { "GT", "Goa-tê-ma-la" },//Guatemala
                    { "GW", "Ghi-nê Bít-xao" },//Guinea-Bissau
                    { "GY", "Guy-a-na" },//Guyana
                    { "HK", "Hồng Kông" },//Hong Kong
                    { "HN", "Hôn-đu-rát" },//Honduras
                    { "HR", "Crô-a-ti-a" },//Croatia
                    { "HT", "Ha-i-ti" },//Haiti
                    { "HU", "Hung-ga-ri" },//Hungary
                    { "ID", "In-đô-nê-xia" },//Nam Dương, Indonesia
                    { "IE", "Ai-len" },//Á Nhĩ Lan, Ireland
                    { "IL", "I-xra-en" },//Israel
                    { "IN", "Ấn Độ" },//India
                    { "IQ", "I-rắc" },//Iraq
                    { "IR", "I-ran" },//Iran
                    { "IS", "Ai-xơ-len" },//Băng Đảo, Iceland
                    { "IT", "Ý" },//Italy
                    { "JM", "Ha-mai-ca" },//Jamaica
                    { "JO", "Gióc-đa-ni" },//Jordan
                    { "JP", "Nhật Bản" },//Japan
                    { "KE", "Kê-ni-a" },//Kenya
                    { "KG", "Cư-rơ-gư-xtan" },//Kyrgyzstan
                    { "KH", "Campuchia" },//Cambodia
                    { "KI", "Ki-ri-ba-ti" },//Kiribati
                    { "KM", "Cô-mô" },//Comoros
                    { "KN", "Xan-kít và Nê-vi" },//Saint Kitts and Nevis
                    { "KP", "Bắc Triều Tiên" },//Bắc Hàn, North Korea
                    { "KR", "Hàn Quốc" },//Nam Hàn, South Korea
                    { "KW", "Cô-oét" },//Kuwait
                    { "KZ", "Ka-dắc-xtan" },//Kazakhstan
                    { "LA", "Lào" },//Laos
                    { "LB", "Li-băng" },//Lebanon
                    { "LC", "Xan Lu-xi" },//Saint Lucia
                    { "LI", "Lich-ten-xtên" },//Liechtenstein
                    { "LK", "Xri Lan-ca" },//Sri Lanka
                    { "LR", "Li-bê-ri-a" },//Liberia
                    { "LS", "Lê-xô-thô" },//Lesotho
                    { "LT", "Li-tu-a-ni-a" },//Lithuania
                    { "LU", "Lúc-xăm-bua" },//Luxembourg
                    { "LV", "Lát-vi-a" },//Latvia
                    { "LY", "Li-bi" },//Libya
                    { "MA", "Ma-rốc" },//Morocco
                    { "MC", "Mô-na-cô" },//Monaco
                    { "MD", "Môn-đô-va" },//Moldova
                    { "MG", "Ma-đa-gát-xca" },//Madagascar
                    { "MH", "Quần đảo Mác-san" },//Marshall Islands
                    { "MK", "Ma-xê-đô-ni-a" },//Macedonia
                    { "ML", "Ma-li" },//Mali
                    { "MM", "Mi-an-ma" },//Miến Điện, Myanmar
                    { "MN", "Mông Cổ" },//Mongolia
                    { "MR", "Mô-ri-ta-ni" },//Mauritania
                    { "MT", "Man-ta" },//Malta
                    { "MU", "Mô-ri-xơ" },//Mauritius
                    { "MV", "Man-đi-vơ" },//Maldives
                    { "MW", "Ma-la-uy" },//Malawi
                    { "MX", "Mê-hi-cô" },//Mễ Tây Cơ, Mexico
                    { "MY", "Ma-lay-xi-a" },//Mã Lai, Malaysia
                    { "MZ", "Mô-dăm-bích" },//Mozambique
                    { "NA", "Nam-mi-bi-a" },//Namibia
                    { "NE", "Ni-giê" },//Niger
                    { "NG", "Ni-giê-ri-a" },//Nigeria
                    { "NI", "Ni-ca-ra-goa" },//Nicaragua
                    { "NL", "Hà Lan" },//Netherlands
                    { "NO", "Na Uy" },//Norway
                    { "NP", "Nê-pan" },//Nepal
                    { "NZ", "Niu Di-lân" },//Tân Tây Lan, New Zealand
                    { "OM", "Ô-man" },//Oman
                    { "PA", "Pa-na-ma" },//Panama
                    { "PE", "Pê-ru" },//Peru
                    { "PG", "Pa-pu-a Niu Ghi-nê" },//Papua New Guinea
                    { "PH", "Phi-lip-pin" },//Phi Luật Tân, Philippines
                    { "PK", "Pa-ki-xtan" },//Pakistan
                    { "PL", "Ba Lan" },//Poland
                    { "PT", "Bồ Đào Nha" },//Portugal
                    { "PY", "Pa-ra-goay" },//Paraguay
                    { "QA", "Ca-ta" },//Qatar
                    { "RO", "Ru-ma-ni" },//Romania
                    { "RU", "Nga" },//Russia
                    { "RW", "Ru-an-đa" },//Rwanda
                    { "SA", "A-rập Xê-út" },//Saudi Arabia
                    { "SB", "Quần đảo Xô-lô-mông" },//Solomon Islands
                    { "SC", "Xây-sen" },//Seychelles
                    { "SD", "Xu-đăng" },//Sudan
                    { "SE", "Thụy Điển" },//Sweden
                    { "SG", "Xin-ga-po" },//Singapore
                    { "SI", "Xlô-ven-ni-a" },//Slovenia
                    { "SK", "Xlô-va-ki-a" },//Slovakia
                    { "SL", "Xi-ê-ra Lê-ôn" },//Sierra Leone
                    { "SM", "Xan Ma-ri-nô" },//San Marino
                    { "SN", "Xê-nê-gan" },//Senegal
                    { "SO", "Xô-ma-li" },//Somalia
                    { "SP", "Séc-bia" },//Serbia
                    { "SR", "Xu-ri-nam" },//Suriname
                    { "ST", "Xao Tô-mê và Prin-xi-pê" },//Sao Tome and Principe
                    { "SV", "En-san-va-đo" },//El Salvador
                    { "SY", "Xi-ri" },//Syria
                    { "SZ", "Xoa-di-len" },//Swaziland
                    { "TD", "Sát" },//Chad
                    { "TG", "Tô-gô" },//Togo
                    { "TH", "Thái Lan" },//Thailand
                    { "TJ", "Tát-gi-ki-xtan" },//Tajikistan
                    { "TM", "Tuốc-mê-ni-xtan" },//Turkmenistan
                    { "TN", "Tuy-ni-di" },//Tunisia
                    { "TO", "Tông-ga" },//Tonga
                    { "TP", "Đông Timo" },//East Timor
                    { "TR", "Thổ Nhĩ Kỳ" },//Turkey
                    { "TT", "Tri-ni-đát và Tô-ba-gô" },//Trinidad and Tobago
                    { "TV", "Tu-va-lu" },//Tuvalu
                    { "TW", "Đài Loan" },//Taiwan
                    { "TZ", "Tan-da-ni-a" },//Tanzania
                    { "UA", "U-crai-na" },//Ukraine
                    { "UG", "U-gan-đa" },//Uganda
                    { "US", "Hoa Kỳ" },//Mỹ, United States
                    { "UY", "U-ru-goay" },//Uruguay
                    { "UZ", "U-dơ-bê-ki-xtan" },//Uzbekistan
                    { "VA", "Va-ti-căng" },//Vatican
                    { "VC", "Xan Vin-xen và Grê-na-din" },//Saint Vincent and the Grenadines
                    { "VE", "Vê-nê-zu-ê-la" },//Venezuela
                    { "VN", "Việt Nam" },//Vietnam
                    { "VU", "Va-nu-a-tu" },//Vanuatu
                    { "WS", "Xa-moa" },//Samoa
                    { "YE", "Y-ê-men" },//Yemen
                    { "YU", "Nam Tư" },//Yugoslavia
                    { "ZA", "Nam Phi" },//South Africa
                    { "ZM", "Dăm-bi-a" },//Zambia
                    { "ZW", "Dim-ba-bu-ê" }//Zimbabwe
                }
            },
            { "LocaleNamePatterns",
                /* Formats for the display name of a locale, for a list of
                 * items, and for composing two items in a list into one item.
                 * The list patterns are used in the variant name and in the
                 * full display name.
                 *
                 * This is the language-neutral form of this resource.
                 */
                new String[] {
                    "{0,choice,0#|1#{1}|2#{1} ({2})}", // Display name
                    "{0,choice,0#|1#{1}|2#{1},{2}|3#{1},{2},{3}}", // List
                    "{0},{1}" // List composition
                }
            },
            { "MonthNames",
                new String[] {
                    "tháng một", // january; "tháng giêng" as alternate form
                    "tháng hai", // february
                    "tháng ba", // march
                    "tháng tư", // april
                    "tháng năm", // may
                    "tháng sáu", // june
                    "tháng bảy", // july
                    "tháng tám", // august
                    "tháng chín", // september
                    "tháng mười", // october
                    "tháng mười một", // november
                    "tháng mười hai", // december; "tháng chạp" as alternate form
                    "" // month 13 if applicable
                }
            },
            { "MonthAbbreviations",
                new String[] {
                  "thg 1", // abb january
                  "thg 2", // abb february
                  "thg 3", // abb march
                  "thg 4", // abb april
                  "thg 5", // abb may
                  "thg 6", // abb june
                  "thg 7", // abb july
                  "thg 8", // abb august
                  "thg 9", // abb september
                  "thg 10", // abb october
                  "thg 11", // abb november
                  "thg 12", // abb december
                    "" // abb month 13 if applicable
                }
            },
            { "DayNames",
                new String[] {
                    "Chủ nhật", // Sunday
                    "Thứ hai", // Monday
                    "Thứ ba", // Tuesday
                    "Thứ tư", // Wednesday
                    "Thứ năm", // Thursday
                    "Thứ sáu", // Friday
                    "Thứ bảy" // Saturday
                }
            },
            { "DayAbbreviations",
                new String[] {
                  "CN", // abb Sunday
                  "Th 2", // abb Monday
                  "Th 3", // abb Tuesday
                  "Th 4", // abb Wednesday
                  "Th 5", // abb Thursday
                  "Th 6", // abb Friday
                  "Th 7" // abb Saturday
                }
            },
            { "AmPmMarkers",
                new String[] {
                    "SA", // am marker
                    "CH" // pm marker
                }
            },
            { "Eras",
                new String[] { // era strings
                    "tr. CN", // BC
                    "sau CN" // AD
                }
            },
            { "NumberPatterns",
                new String[] {
                    "#,##0.###;-#,##0.###", // decimal pattern
                    "#,##0.00 \u00a4 ;-#,##0.00 \u00a4", // currency pattern
                    "#,##0%" // percent pattern
                }
            },
            { "NumberElements",
                new String[] {
                    ",", // decimal separator
                    ".", // group (thousands) separator
                    ";", // list separator
                    "%", // percent sign
                    "0", // native 0 digit
                    "#", // pattern digit
                    "-", // minus sign
                    "E", // exponential
                    "\u2030", // per mille
                    "\u221e", // infinity
                    "\ufffd" // NaN
                }
            },
            { "CurrencySymbols",
                new String[][] {
                   // localized versions should have entries of the form
                   // {<ISO 4217 currency code>, <localized currency symbol>}
                   // e.g., {"USD", "US$"}
                   // There are no entries for the root locale, so we fall
                   // back onto the ISO 4217 currency code.
                 {"VND", "đ"} //"VND", "đồng"} // ₫ is not the official currency symbol
                }
            },
            { "DateTimePatterns",
                new String[] {
                  "HH:mm:ss z", // full time pattern
                  "HH:mm:ss z", // long time pattern
                  "HH:mm:ss", // medium time pattern
                  "HH:mm", // short time pattern
                  "EEEE, 'ngày' dd MMMM 'năm' yyyy", // full date pattern
                  "'Ngày' dd 'tháng' M 'năm' yyyy", // long date pattern
                  "dd 'tháng' M, yyyy", // medium date pattern
                  "dd/MM/yyyy", // short date pattern
                  "{0} {1}" // date-time pattern --> time date
                }
            },
            { "DateTimeElements",
                new String[] {
                    "2", // first day of week
                    "1" // min days in first week
                }
            },
          { "CollationElements",
                 // grave, hook above, tilde, acute, dot below
                "&\u0300;\u0309;\u0303;\u0301;\u0323"
                 // D with stroke
              + "&D<\u0111,\u0110"
                 // breve, circumflex, horn
              + "&Z<\u0306<\u0302<\u031B"
          },
        };
    }
}
