package ca.couchware.wezzle2d.tile;

import ca.couchware.wezzle2d.manager.Settings;

/**
 * A 2x tile.
 * 
 * @author cdmckay
 */

public class X2Tile extends ItemTile
{
    
    /**
     * Path to the piece selector sprite.
     */
    final private static String PATH = 
            Settings.getSpriteResourcesPath() + "/Item2x.png";       
    
    /**
     * The constructor.
     * 
     * @param boardMan
     * @param color
     * @param x
     * @param y
     */    
    public X2Tile(final TileColor color, final int x, final int y)
    {
        // Invoke super.
        super(PATH, color, x, y);
        
        // Set the type.
        this.type = TileType.X2;
    }
      
}
