Upgrading from 1.4.x to 1.5.0
=============================

This release renames a large majority of classes and methods in an effort
to clean up the codebase. Migration scripts are provided to ease the
transition, but since they're simple find-and-replace one-liners, you may
find that you need to tweak some individual files manually. Change into
the appropriate directories for your project as indicated by the
`cd /path/to/project` or the `cd /path/to/tomcat` commands, and run all the
scripts first. If the project doesn't compile afterwards, read through the
entire document and adjust your code accordingly.

Mar 12, 2011
------------

Annotations in the `RecordField` class were moved into `Recordable`.
Most models shouldn't use `RecordField`, because it's rather internal to
Dari, serving a role similar to `java.lang.reflect.Field` within Java.

    cd /path/to/project
    perl -pi -e 's/\@RecordField\./\@Field/g' `find . -name '*.java'`

May 17, 2011
------------

The `utils` project was merged into `dari`, because they heavily depended on
each other and were rarely changed independently.

*   Change project parent from `com.psddev.utils:utils-global` to
    `com.psddev.dari:dari-parent:1.5.0-SNAPSHOT` or
    `com.psddev.cms:cms-parent:1.5.0-SNAPSHOT` (depending on whether the
    project uses the CMS or not).
*   Change dependency on `com.psddev.utils:dari-servlet` to
    `com.psddev.dari:dari-web-servlet`.
*   Change dependency on `com.psddev.utils:utils-util` 
    to `com.psddev.dari:dari-util`.
*   Change dependency on `com.psddev.utils:utils-servlet` to
    `com.psddev.dari:dari-servlet`.
*   Change package namespaces:

        cd /path/to/project
        perl -pi -e 's/com.psddev.dari.servlet/com.psddev.dari.web.servlet/g' `find . -name '*.java' -or -name '*.xml' -or -name '*.jsp'`
        perl -pi -e 's/com.psddev.servlet/com.psddev.dari.servlet/g' `find . -name '*.java' -or -name '*.xml' -or -name '*.jsp'`
        perl -pi -e 's/com.psddev.util/com.psddev.dari.util/g' `find . -name '*.java' -or -name '*.xml' -or -name '*.jsp'`

The `JsonUtils` class was replaced by `JsonProcessor` to allow instantiated
use, but the static methods are still usable through the `ObjectUtils` class
with different names.

    cd /path/to/project
    perl -pi -e 's/JsonUtils.fromString/ObjectUtils.fromJson/g' `find . -name '*.java' -or -name '*.jsp'`
    perl -pi -e 's/JsonUtils.toString/ObjectUtils.toJson/g' `find . -name '*.java' -or -name '*.jsp'`

June 20, 2011
-------------

References to `record` were changed to `object` in most places throughout
the code to reduce confusion in the future when `dari-db` would support
working with non-`Recordable` classes.

    cd /path/to/project
    perl -pi -e 's/RecordField/ObjectField/g' `find . -name '*.java' -or -name '*.jsp'`
    perl -pi -e 's/RecordType/ObjectType/g' `find . -name '*.java' -or -name '*.jsp'`

The `StorageItem` classes were moved into the `dari-util` project so that
it can be used without depending on the database functionality.

    cd /path/to/project
    perl -pi -e 's/com.psddev.dari.db.StorageItem/com.psddev.dari.util.StorageItem/g' `find . -name '*.java' -or -name '*.jsp'`
    cd /path/to/tomcat
    perl -pi -e 's/com.psddev.dari.db.([^.]+StorageItem)/com.psddev.dari.util.$1/g' conf/context.xml

The `FieldValueTypes` annotation was renamed to `FieldItemTypes` to prepare
for other annotations that can differentiate between a single value and
a collection of items. For example, for the `list/number` type, `FieldMinimum`
would control the minimum number of items that must be present in the list;
`FieldItemMinimum` would control the minimum value for each individual item.

    cd /path/to/project
    perl -pi -e 's/\@FieldValueTypes/\@FieldItemTypes/g' `find . -name '*.java' -or -name '*.jsp'`

Various `Name` and `Label` annotations were renamed to `DisplayName`
and `InternalName`. In the future, other classes should also follow this
naming convention.

    perl -pi -e 's/\@FieldLabel/\@FieldDisplayName/g' `find . -name '*.java' -or -name '*.jsp'`
    perl -pi -e 's/\@FieldName/\@FieldInternalName/g' `find . -name '*.java' -or -name '*.jsp'`
    perl -pi -e 's/\@(Record|Content|ReferenceableContent)\.Name/\@$1.DisplayName/g' `find . -name '*.java' -or -name '*.jsp'`

The `org.apache.solr:solr-solrj` dependency was made optional. Most projects
will need the following added to their POM file:

    <dependency>
        <groupId>org.apache.solr</groupId>
        <artifactId>solr-solrj</artifactId>
    </dependency>

The `dari-web-servlet` project was merged into `dari-db` to simplify
dependency management.

*   Remove the dependency to `com.psddev.dari:dari-web-servlet`.
*   Change the package namespace:

        perl -pi -e 's/com.psddev.dari.web.servlet/com.psddev.dari.db/g' `find . -name '*.java' -or -name '*.xml' -or -name '*.jsp'`

The `dari-servlet` project was merged into `dari-util` to simplify
dependency management.

*   Remove the dependency to `com.psddev.dari:dari-servlet`.
*   Change the package namespace:

        perl -pi -e 's/com.psddev.dari.servlet/com.psddev.dari.util/g' `find . -name '*.java' -or -name '*.xml' -or -name '*.jsp'`

June 30, 2011
-------------

The `FieldItemTypes` annotation was renamed to `FieldTypes` because it's far
more common for a field to contain a single value. So contrary to how the
earlier example described the functionality of `FieldMinimum` and
`FieldItemMinimum` annotations, `FieldMinimum` would now control the minimum
value for each individual item, and a new annotation named
`FieldCollectionMinimum` would control the minimum number of items that
must be present in a collection.

    cd /path/to/project
    perl -pi -e 's/\@FieldItemTypes/\@FieldTypes/g' `find . -name '*.java' -or -name '*.jsp'`

The transaction methods in the `Database` interface have been renamed.

    cd /path/to/project
    perl -pi -e 's/(begin|commit|end)Write\(/$1Writes(/g' `find . -name '*.java' -or -name '*.jsp'`

Finally, run `/cms/_debug/init` (if your project depends on the CMS),
then `/_debug/init`.

August 4, 2011
--------------

The factory classes were renamed, because many of them do and will contain
miscellaneous convenience methods that are not related to creating instances.

    cd /path/to/project
    perl -pi -e 's/StorageItemFactory/StorageItemUtils/g' `find . -name '*.java' -or -name '*.jsp'`
    perl -pi -e 's/ApplicationFactory/ApplicationUtils/g' `find . -name '*.java' -or -name '*.jsp'`
    perl -pi -e 's/DatabaseFactory/DatabaseUtils/g' `find . -name '*.java' -or -name '*.jsp'`
