Upgrading from 1.8.x to 1.9.0
=============================

Jun 28, 2012
------------

*   `Index` was renamed to `ObjectIndex` to be more consistent with
    `ObjectType` and `ObjectField`.
*   `Environment` and `DatabaseBackedEnvironment` were removed and replaced
    with `DatabaseEnvironment`, because the overhead of maintaing them as
    an interface with multiple implementations was too high without any
    tangible benefit.
*   All field annotations were merged into similar type annotations or renamed
    to conform to a single naming standard. The following script should fix
    most deprecation warnings that resulted from this change:

        perl -pi -e 's/\@Field((?:CollectionMaximum|CollectionMinimum|DisplayName|Embedded|Ignored|Indexed|InternalName|Maximum|Minimum|Required|Step|Types|Unique)\W)/\@$1/g' `find . -name '*.java' -or -name '*.xml' -or -name '*.jsp'`
        perl -pi -e 's/\@FieldItemTypes(\W)/\@Types$1/g' `find . -name '*.java' -or -name '*.xml' -or -name '*.jsp'`
        perl -pi -e 's/\@FieldPattern(\W)/\@Regex$1/g' `find . -name '*.java' -or -name '*.xml' -or -name '*.jsp'`
