/*
 * Licensed to Elasticsearch under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.elasticsearch.client;

import org.apache.http.HttpHost;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertThat;

/**
 * {@link org.elasticsearch.client.RestClient.FailureListener} impl that allows to track when it gets called
 */
class TrackingFailureListener extends RestClient.FailureListener {
    private Set<HttpHost> hosts = new HashSet<>();

    @Override
    public void onFailure(HttpHost host) throws IOException {
        hosts.add(host);
    }

    void assertCalled(HttpHost... hosts) {
        assertEquals(hosts.length, this.hosts.size());
        assertThat(this.hosts, containsInAnyOrder(hosts));
        this.hosts.clear();
    }

    void assertNotCalled() {
        assertEquals(0, hosts.size());
    }
}