/*
 * Licensed to Elasticsearch under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.elasticsearch.cluster.routing.operation.hash.murmur3;

import org.elasticsearch.cluster.routing.Murmur3HashFunction;
import org.elasticsearch.test.ESTestCase;

public class Murmur3HashFunctionTests extends ESTestCase {

    public void testKnownValues() {
        assertHash(0x5a0cb7c3, "hell");
        assertHash(0xd7c31989, "hello");
        assertHash(0x22ab2984, "hello w");
        assertHash(0xdf0ca123, "hello wo");
        assertHash(0xe7744d61, "hello wor");
        assertHash(0xe07db09c, "The quick brown fox jumps over the lazy dog");
        assertHash(0x4e63d2ad, "The quick brown fox jumps over the lazy cog");
    }

    private static void assertHash(int expected, String stringInput) {
        assertEquals(expected, Murmur3HashFunction.hash(stringInput));
    }
}
