package org.numenta.nupic.util;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.Random;

import org.junit.Test;
import org.numenta.nupic.network.Persistence;
import org.numenta.nupic.network.PersistenceAPI;
import org.numenta.nupic.serialize.SerialConfig;


public class FastRandomSerializationTest {

    /**
     * Make sure that the main Random Number Generator ({@link FastRandom}) outputs
     * the same numbers when serialized as when run without serialization. This test
     * is critical for all other tests to work... The serialized RNG must be de-serialized
     * with its previous state in tact.
     */
    @Test
    public void testFastRandomSerialization() {
        int[] expected = {
            1363149450,1392426,-1321038434,178290815,1405980988,1781875497,-136869635,1868054559,-672588233,-1162151267,1720151456,-1008706495,-1365165498,915476271,-1804467553,612986230,-1256379021,-541095717,-2012950675,656634571,-45418824,1977949912,662495460,-2109045630,322871082,-2003925544,640791781,-1231402506,-721277683,-2100712695,-1362519673,2028186582,560711130,-347037183,-656185823,-47187857,-2082080606,1896440217,-2078221114,152035490,
            1828093261,1592642599,-34737991,-466000037,801626099,-1387957700,-753811349,1542243986,-1380040801,222006583,-694756685,1685865797,841017291,-279625651,-505461673,-640483855,-1553072062,-154838489,-268949482,1431256308,-937150443,-987045477,1527411637,1483789465,1706474476,-73615750,-815243696,668347339,-952146808,-460377268,-920297988,-1242230154,1507527618,-2029488663,2120685341,-471335725,-148669435,-1309852892,-2118531749,-875530488,
            -1665055448,1331313911,-985496052,-1104638456,2075261024,-1418099631,933358344,-1837571162,723792949,-248438549,1977321836,1744136790,-1287223545,-903798752,-1531699125,1007599435,640129130,-242686684,491804311,1484447861,-700858863,-73120961,-605378502,-844699220,-1304244992,1826429988,-2000074248,-1576195640,-888489255,-1189015559,-340471992,-1253067396,55050616,1052382846,-1949422320,1735439575,-1925219146,134551557,-300291316,427107256,
            -1848582229,-1711495071,1085500537,-1419122933,-388013453,2076145770,760615043,761066230,-472026868,1480686743,834866222,2118212712,606686144,-390549978,1141311302,-1736009282,-510917907,-1198996803,1665281929,-1817239004,-1423506528,1137533831,-1492295792,-1505641562,-1557805390,1151621200,1400852377,1102944893,1587134358,136657873,230686743,-1260802787,166457907,-584913462,259390830,1377617675,876174426,-2009197939,-1414715119,896588392,
            1688842739,1751255752,-1004799041,1456395449,-1789612959,-1291489890,228507714,712483515,793294482,806254303,1279453038,-1247901647,677525639,-440926130,317736875,236239110,-381660788,844122707,-1507753814,-604698247,-1585661939,-513627428,-681613198,-1257833270,123768750,-1216875702,-865066540,-339176225,-740513631,-1091570845,1010649463,239038265,154896670,-357155606,-771518394,-915071314,848473795,4185770,1875665595,9648244,
            993984507,1609396057,854818981,540426734,-638867424,-434720216,-783706677,439586107,-246760799,1060970762,1494427652,-1642656920,1661391324,-1230950852,1218477950,2051807435,1176533817,-607108292,-290793172,-1392021740,124387568,-813843426,1493832396,-1618049840,-2090253346,-2059631729,-1113209161,375558943,162181141,292536375,660519800,1055047149,-1595768674,-1442452612,817248096,1692039281,-978718072,322991552,1182263244,-1042730634,
            -16295265,1735424580,-761166821,1336794222,1114851924,1226581798,-378110488,-609814248,108139023,1320314057,-781808780,-69881408,-1519852069,1837088322,-1919429435,-1408192750,37135723,1977825324,2049663312,-280725859,-1603117607,-1278446072,173914164,-98254788,400092567,1029264766,567990741,-1909662992,522633076,697147295,439029299,-751771064,308723153,-1514767807,-1438345369,-1206910170,867636425,589760111,1985452044,2073634094,
            -402350996,1173727791,-1861445068,1617527477,585577741,-513604179,-1613634148,1531650902,385337020,887198555,-838823635,1073901779,-1519076127,793078599,1900753316,-142886075,-889154014,382276282,-75276850,-425023829,431006660,-1467611285,1958732978,-343305914,752753351,1433621253,1057019068,-1631622406,625065292,-957852241,1856131240,-343938924,-1119647185,723442053,-1656762635,-437098750,-141832186,1203460437,-2018564378,-1789789843,
            1778041297,1314344291,-1774338946,-1429079700,-608576063,359994764,-1476586377,385350019,-1368357390,-2115281055,-224458007,1326928895,-1754064199,615722269,-1693967030,-913924414,-1547956104,-1155121768,-2123346529,-1317929937,1570196302,1481621614,441677577,780227391,-1161599803,1252931520,-650370819,-699343703,-367652615,-675981063,2009356841,-103182555,-1221598707,-1468941010,1128616566,-440316027,1916388233,-1798861670,529344733,-2028172476,
            -1765396819,1007429103,968585433,-28360027,-1842625604,1335829765,-300767557,1264983090,679471369,-631992186,670506227,1373729893,1376964663,-1478435547,703692992,-1285086423,-1467788268,2064943235,2068867566,-234409412,1510395578,-1349327030,-359584006,1545118542,459645624,-1742120618,2075357295,-807727692,1696847525,-2126355103,1077880335,-605942895,-1723023820,526494896,1156919130,686371487,-747049809,811876036,-1231774767,-1478654673,
            -447470860,171338487,1469870990,-1593826184,-614647546,-376314360,-641860146,1759176455,-1585207753,943654588,2074836679,81444560,-768041956,-848058229,-947328684,1435885517,1149341222,1521361014,-1758959225,-1246117689,-108636637,-958103525,-681388075,-1587405263,1829756689,-18687984,679513471,-1614001629,-766214525,681162175,-231442129,-545566967,828241321,83153934,-627215631,774445012,-507465434,142423169,1111730563,-1623970758,
            2018483103,-552344498,-1879524116,-443913272,-1753308075,-642375383,-374605299,-1744649011,818779951,1117190487,-1440016513,-376992555,-400707643,330759725,1172490534,-295650237,-627585430,-1758646240,-1384238178,-2142700923,1952169662,-472729506,-311002299,1723469484,224725654,-1974481213,-180148553,-857503669,-623797569,-1402069892,1432260472,314204718,1365578716,-1445113606,-863363275,1779022509,2119827647,-886212607,1710446682,-516058577,
            189843746,373900297,2068848727,1366979646,849439970,-735172588,1229706503,-1654305800,962592287,1541144934,-1525778050,-25776125,-1250466821,1326529341,159015082,-23036604,-1418028809,-6206962,1797945855,202121902,-1069500977,-1589011060,1296805359,-1327597938,-382159247,-414903800,494177091,1219769007,-1473198189,2024419710,-33776487,1606141898,-1866820338,1795056119,-424636671,1105567935,-1842679595,1902632206,-960513723,-2115475797,
            -2038398709,1554609955,1090507469,1735878837,-1889444024,1906718816,-68437766,1114328452,-1477521092,-1027756582,-214677385,1929344637,-1328722975,454818723,-1494482781,285702299,-2075351527,1313136965,1642076030,590109569,-1144574462,2048640247,-1992408521,1783584971,-1006416061,-856587438,-136051859,-1476593889,-1040445897,-1843359573,1636628859,1088282161,70825528,259453290,1404136996,488520157,-1197180671,1132670812,-1963420042,-496966001,
            1996878311,34764008,-470508874,-1973031225,-2114806550,-957000983,1665978599,-373103305,975823094,1986113550,-352233508,439931453,-234066493,-678058826,1796674911,862878626,-214803455,1014946299,417444742,-827491973,-1934973751,1411193546,2114075185,2098047208,-1797080029,-1051841718,108906771,1770842110,-1754325130,2004655899,-2052297910,-437454387,845008148,913402421,32873718,-1696914067,-635062483,1495247191,-213534251,1396826763,
            1640886553,648977766,1093261669,-1168722648,828162131,-726462553,1903881649,859648854,552034128,-887955655,-593369226,-1653228308,1639168302,-459752796,120857542,-1495806039,379636555,-934177578,-1614105303,-525545584,567817472,879996476,1002502207,272338356,-807106149,-718077959,951519865,387959149,372828218,1813738140,1926653033,867995767,-551670682,-941859637,-1342135665,1454528399,-1085875295,507311353,586583487,1425292088,
            -434414346,-931848767,279352836,552122133,2030316529,-282065098,-1726764525,454496698,-1176825834,11418224,208613209,1470062784,-51327221,-37261415,738411206,1861437166,2127790931,386656021,-850047348,1865454217,-1341541846,1061214671,240956834,467318975,-1470132555,222736711,-29204661,-2092195942,-797455389,-851748457,-1719905759,698807433,1314438239,-370355464,96026437,-1952755157,658682405,1605907702,-465958971,1086741677,
            -1371737916,2040514193,1685042672,-654975696,1154685728,1555089972,-1827248655,1079015323,-1716354738,-89921884,161910048,-1579741870,972644103,176997897,-1211838017,-1521098437,688303685,-90816556,-1871338398,819443596,-1382993768,1881794867,105407122,2023051522,1801795509,-1797839078,-1140726608,-1509569201,-720745069,62559478,-555794727,-1960137005,1837695413,-589911719,-1377766901,-509460545,584652660,1876803069,950020979,2035714600,
            365750511,-754350395,-1659401845,-1632734631,135517107,603852671,1377570959,-1899708522,1198593529,-877139950,-1040634003,654345067,-1609884029,317286957,1187081232,512224346,618571758,-1153297775,1764848895,385837939,-671846491,-1468089678,1802990779,226457698,-945773237,-831656914,-1897837368,-2097921541,-1080085887,606118878,589048626,764622570,-769602600,-110486422,1814473743,246206398,488976951,164908095,1896699698,-1011223387,
            1243186462,1934032871,677742440,-1349803828,1457763195,1586466687,1031934433,1944282854,-70334562,-1040147212,757256560,932418661,1139973048,-1023540676,1440126946,1920998577,1643388915,892950354,663910111,-1827700876,-2039863637,1771800822,1969180137,-543425475,1497513199,-1116146567,-327714681,1495277978,-794242222,414110473,-893007680,-411025178,-2075429244,-1203264028,307823252,-2013356532,842298882,2016991181,-1985111386,2058573766,
            -1219724766,-408707184,753151735,540247330,-1154591424,1035370620,-1318023656,261383612,-932360931,426304328,-1997115416,-1875659519,1395379104,253178424,1479512636,-315203124,2077054739,1613017460,820235666,-1114554681,-1657811487,2101790208,1518110734,-650170173,199077204,24980454,282895315,93763960,-105512061,1204439690,903441895,898982259,-2100217451,2026810811,895188028,-314141221,1491575869,1522799661,-1406123084,-1316911733,
            -416198385,1546804856,-784194971,1948726061,1561632334,-485347369,-674654087,-49850889,-48671579,-1486745556,1643820175,-203962915,-1131871981,2104739957,1002093403,-413024901,1210295801,-472125897,-1941625515,-728696571,2106459788,1674275214,224524174,230001243,-479911345,-851147483,881527268,-1811132377,1541783271,-769138300,-1407674351,-1303129099,106091575,-156914763,-1160736586,1830699304,1017304548,1243395039,1476697733,778833185,
            111753704,-1139237830,-349100152,-1003108674,-2106019101,-1383469166,433292709,-512463330,2090203359,427861855,-1330699983,-1897852520,93819688,2098068159,-409596731,-1609482513,-2010100467,751828432,1023066336,822992914,380544815,-198442164,1335579428,1448449926,-737101038,-2061744681,1920006856,1636878312,-900214529,1460048756,-688934384,-448854144,-1622968033,-564319617,587106516,-2057608938,2090409833,-2138004531,-1076342570,1072588747,
            -46693854,-1299900956,-131871761,666704147,-1382984224,-959063832,-1935533233,1212164669,1829922142,75294594,542782818,-1485573483,-1602480512,1997797748,767200951,-1780394570,1353651793,544836192,-847128498,-1408516931,1799627955,795377129,2026369209,-176273761,1926874038,1006216192,1460167902,-1935066554,-1402101085,-1701390737,-28324169,23122886,-917166904,1010984252,1295650265,1749361647,-524000202,-1258193374,-1457797627,1036500729,
            1666860403,-846717765,840393222,819522204,1421185501,-1310586394,1826288563,-444503418,-1105480030,-1166896393,139551150,-217690049,769114765,1190505737,-208279169,1419743005,156558230,-1314725213,1011211181,-54550093,1152297821,1550199638,-691822933,-1091070310,-717982827,-1534651075,1804096796,260400234,-1528129942,212510547,1202447396,-1583284161,1666789015,508060900,-57126251,208426056,-768479857,-763635610,-1032604272,1055927283,
            135094940,1608121118,-1271040253,2124233335,1078733171,125722469,-1314613004,-1229220448,-1343809497,1897624338,438222083,-1372680470,-633434650,-1319533768,1292761252,464309478,1509677547,2032087950,1738641781,-1036989622,1797218528,1746201146,-1846008415,-1273173602,2104382280,1120131554,-748117833,683519012,-118318544,-1820305539,149292080,839463013,1355972267,-1080024418,821412786,410403338,-1137177289,-414861650,-598509939,638549265,
            528015592,1662635927,463290897,1625870703,2139810382,-852253994,-170337184,-2070424232,-1192260763,333862150,-665036773,58598876,1931514328,197066181,-1560836069,-1344729562,-1548821884,-881242685,-424563356,-2084390675,1316107778,1935208508,-164286716,2115672322,454841602,1371877577,-306683645,163652054,1257715128,-1272749788,-702982736,290495266,43578548,-603253345,-1067437435,1185256343,1379271914,532136225,856784254,-860690410,
            -194503234,1028928935,-1586101504,1597721156,1682157988,-2144759928,2128093102,-1540601202,-590075182,-139296223,-1091253757,870704505,-1785266405,-1604866263,-1898483517,-691468124,-205956366,281185382,404478913,-1469019100,-1239373943,-1273759520,-408356162,-115250036,-1584404452,229574121,818981279,1952324400,-869404671,-835383083,981550152,2082443187,-1385694355,432394241,-1443987429,-530248203,1038418706,807892619,-637872033,-53156731,
            477512131,834080000,720841183,-1394861239,-2047905181,-943702369,-1249640804,-679143448,-6300276,-1371871607,425944859,760893976,-1985503365,-156236442,2077135377,-269058120,1639760370,1569992281,943399040,1876203846,-208016774,-1909262341,-592829254,-1654041389,2142482699,-461925003,19150419,-421089969,2047100822,421038978,-798362717,678449681,389344517,1442304660,1164034585,-1506735295,-527642689,1417014099,-1136182128,88037549,
            -1951992011,169030158,1082355423,812392087,1774807866,2077580497,-1460581509,-1386409387,-2101620078,1406526299,-1441203668,310548130,1902001303,1126803139,-795644498,2022179783,-2043083860,-386641233,-521981550,-1237498186,-1730808598,1120904917,-981686672,-215795208,-236072328,-1488618108,-155916696,505056905,244674756,-471361345,-1819098370,132222293,440261573,-322289785,-1978753269,1788679035,-1592354531,-1548703445,-1919031774,-581905573,
            -385620579,-883790697,-740327032,71386087,-2018834296,-1867689951,1185802552,-544620297,448548327,-646712735,-1670081787,13172678,1331406629,1809437273,-1706828987,-1628474688,911040095,-85133072,-926789307,-1513546768,-1925123822,1003982456,1934621011,1001187340,1237102458,-1479561898,1000126931,-1204227444,-817527740,-145321407,128436440,859382967,2021331632,551972046,1340414175,-1268489085,1003622358,-523043645,311062256,61003762,
            1204320308,-962737936,1792209169,-1406261328,553802725,-1157016603,-966684494,1828730876,-2065967453,-2026049994,-562387360,1526087548,613355576,1983181405,-145523403,175679108,-110821607,-909402374,-373378179,-629887636,1432107678,-553532524,-1190782879,1213395639,-1917498365,-629072334,2093516133,-204608140,1527438421,862926729,1727963026,-1016292820,443734801,568083232,-1988281744,16193914,-1020824361,-1155684783,2104985613,-547266653,
            -1957486376,176293253,1448964647,645091031,-750890762,-890627519,-2040055925,921164710,1288298114,136739901,-2089454152,-1874554553,-223699544,302167678,1566833952,-606149292,-581483014,144413119,-1080247330,-676644913,1345442091,-1541819212,407596257,-981503099,1899349981,-1595572225,1923653795,-2003050469,398198618,-182564136,1748881058,-168084064,-411712233,-337060571,1200457518,-361167561,-1262248331,-1575497391,518514334,-272809245,
            -1241175732,-870254520,-1250140724,-207668650,-1927628718,909385281,964935669,-2116494914,-1184220233,60676171,-64395833,-361928428,807768064,-528960303,1293815566,-787868051,-1046608065,729487901,-351319111,1100245112,-298217043,1283991090,1355427006,-2036636277,-304009544,-920772123,-1065683674,-521872635,-344430323,640069093,1144812940,-1292937315,936610198,-1061559843,1277506373,-2031221258,-710814061,-1673409109,-1069145010,-853051717,
            1326323527,1313288737,-269747988,1360090802,-2017585944,303043923,1706176582,1424342176,910826672,304109337,-962171652,1302724079,899207089,-1208901053,772562182,31775313,-1335810756,-132361605,-853410125,-1769843435,-860047574,-668508767,149615787,653845878,-127173979,806119548,-1046143971,1352104910,-1980471562,-1023086803,1156406553,-550508028,845214603,-2097561810,1000983881,1586533851,-330409260,-644748087,-1060270862,1363547475,
            541616652,553113049,-777332497,1027416215,-1672901528,-457911053,-34120753,1904258558,-125750668,908366217,387585969,-1091010041,-1898126494,-100726341,-437642779,-1443864604,-50649171,1959491246,-1886622956,1768162612,-1408465933,1043104447,-1477442734,51207927,1552916066,-1121847120,-112181056,236517752,-155763092,-833620312,-851576635,2110858689,938458866,-343293780,2010906834,1442399335,1712913153,-1081786963,1657988539,-1163808938,
            -1556407100,773897168,1357441058,-1748888945,556754278,917263091,1214477044,-683829048,594220326,-912455755,1920430799,743695988,-1446111210,745621077,-1519017070,1994972086,939413554,-1503507181,-1654824063,-132743976,-273217729,-2017265792,684185356,1760552201,-1805171810,-1744722757,1018477967,501923947,1987460971,-1351946241,1111503713,-1328248491,-91642657,-1236233078,316552893,-233250088,1336133119,-872354668,128060057,-1917219172,
            -1802908777,-1858051351,176965949,1783366165,241061449,650492412,-1088082616,-1554943960,1849048311,-1667273465,-473194873,1934694209,2089812009,271351960,1494770193,821246607,-114651951,-2106844283,1313132431,-506382639,-1744260334,810255827,56324677,363236633,-915928841,838265768,-1437317687,-361922673,-433013024,-483597233,774183343,240884379,-1620108917,149464841,1927056152,2079511174,-900956095,-2049839374,-1512070553,1895889998,
            2107130215,1444553228,1556478019,875981991,-1134533080,77537797,-440173736,1321713778,-661214904,-730139290,1907207916,-1823326626,-354559073,-465470341,218416407,-1599966598,929003761,-1926430048,-461179293,-954134488,176570817,1829483508,873035459,716805607,-895634946,-243662880,683136150,-795570173,-303291011,-686006486,280740756,58923377,-1897612934,275245643,1219861252,1318497841,-1175191332,-970455778,326258307,-1683649811,
            -1977595360,-1054619773,-1587468790,1516149131,26006224,-1257539840,-937323505,387014562,1555301296,1307091495,2017328826,-1927714076,1998468630,2131989833,-1344399221,1335858336,-278902038,-816098866,1643793184,-1075353886,-1949798939,1031363057,1865294646,-1401495667,-1657226829,197683399,-13379745,1738055642,1085599867,-1187878390,1226843084,-1796273035,-1111980262,-476913285,-1202915569,-361273179,633785482,1861888919,-1984937033,-526256404,
            174087897,1904847861,-654105850,738425491,-58223128,-1630717211,-1708673636,480984812,1566142960,82309440,-1175868559,2074750026,-1754669462,1377427852,1806072535,510601775,1560760099,940519590,-525168894,-1686095702,844956418,1636617283,-1773148979,-2104015365,432899648,1897704079,2137933127,-1054080064,908873156,-1147236134,-533626685,-741488953,707198809,1040261356,-1275404574,-2086929063,-255667023,-1060546770,-337554424,-1519964515,
            588156944,127532069,-1119651697,1546419433,1155108083,997765306,-1573696306,-210104785,768905544,1508369365,692242351,-1094532242,76817251,1130928833,-916285651,1674258095,1260439489,1443786211,2031082993,-1282922119,227541004,-1583742236,-1516049368,-1604904958,1471696956,94874218,-1695738904,321458198,1544453465,-428378799,-1779097497,-1804267801,-489550878,-1537944051,-2105119464,757362794,-1804040175,1778079144,-494714789,-1847470236,
            -703781865,-1315411952,-769682654,656914425,-416947191,1002838979,521139071,276981610,291565286,1498484876,921254353,-784007772,-336331688,1012140767,831537228,-1113950428,-918971151,449853772,-1850494287,-1508942076,-112846719,-2005012580,-1596282887,-1540307234,-1554070842,-1655946671,-1374608770,2052796160,1889018789,-481703055,416602490,1492184203,-1798374331,1800341265,308660221,170182273,-1672176885,2040996680,-2023481568,1525133306,
            -1359418056,1603096632,1314867345,667665983,1343140942,2142288444,767617077,2010464707,1304229680,198892356,400891608,-1328006768,28390177,-1294351415,1903193910,1953469415,2138805143,737302369,1555977986,-292066381,-332313864,-810261347,-1409851006,-689656842,-221773497,1283466281,700404958,-70335297,1551275520,-188737595,-1125485125,-2002642158,-688143181,1635511384,2015538182,-1989911317,-1588930982,-2057412556,-832057711,291697678,
            31539950,631407968,1974358638,-1050978182,856387479,-1858655022,926609916,706407663,-103472243,845386218,1455619902,-503934759,1525037875,-595223660,-198354175,-742075356,858645623,1380775873,-1133229723,-332473703,377329553,336168372,-1203284914,2000994604,-1815144949,1928810960,-1580700696,9991363,1255647112,915876106,1741508809,-2052960435,-949033034,-770194196,1365941461,-259639476,1957800506,-1230141974,-236134074,55301029,
            -1837795090,-113859928,-247447761,-1387814983,21427289,399799036,298256291,1258207332,-1988677626,-848386892,-1404610427,45592697,-1846838682,1496183906,698757944,-268740185,-22197619,-1142509771,222024008,2015027208,-1905950881,-486061875,1794993554,-749131,-2134049317,545199331,1756739781,433879142,746810668,-776238063,234449203,-1893673850,876195456,800951296,-563052657,2028038532,-691786858,-655751276,-1875450705,2114707097,
            -1768410632,1325841188,-1067764683,-1252095898,-233012309,-1856396823,-1668728012,-1439623012,-432919767,503025895,1243745240,309122885,2025128403,218914120,-2064931402,-208782177,-1011794328,-1610268171,180213729,-12963409,-1057356750,-1843616900,533526850,151278412,1409015363,148811377,441682176,1967530702,-581300942,2140196672,47523171,-714657399,493242986,1777439837,1579416558,1205287389,-1524826178,-116312102,1350754814,-327971005,
            -2083278248,1939224459,1667023129,-3873259,1118688980,-1478274500,1969775956,1460003092,1182117102,-1351585460,-2133843034,1696271057,-81832097,1320481012,-200368332,1466357512,-359321705,192729281,1069042260,-1079312012,-904983970,-961815023,-1291590470,-180108510,-1202070783,-729016796,-829904058,1828366988,1087463487,1792348535,-1799470839,-1024517136,1147729922,-2029985738,-1246025987,502755015,659476916,698410845,-242373685,-1576788130,
            -698324594,-952270641,-779668437,98724076,-2013892422,934897197,2078800474,-249537091,11938853,-1468674263,-393300611,-1534367873,1460697096,-1627881306,-96357084,1214865335,1319611003,-272335938,-584998960,27523341,-663346803,1458800895,-1582085164,1343331656,1436408769,1048110256,1686732148,1413276764,177231492,-1410714084,1099073393,-197047268,-304400557,284004754,917249157,1370583620,-733629593,413759230,-681796447,1720254999,
            109053347,1461366747,1411988720,-1559941560,102203769,468384536,291269986,-526519823,-1816221030,1383506396,-432413515,763194127,504019728,-653680959,-245592716,-990327495,954717197,497233494,-1383282728,836545826,-665866426,-214106877,-1688474909,-693549744,-1682966069,1985515611,2057993726,-414741722,-1617571977,1586575102,-141793635,1436677378,322618670,1274312102,-281003556,-2011840995,-63061901,1692097622,240195257,1147185039,
            275490412,-362318922,-321848678,1934901818,983267560,1268528353,-111126188,-51812315,174179384,-1507066805,-505221582,2104772856,-1885965163,-1463719119,-1110543646,-1159471615,1815397218,1354195622,-390672665,-2081928209,-560538538,-2144896175,-1793031179,-795658680,2116292652,-340586596,-607027680,13961285,1793812532,-1245291464,1948318231,-1290879861,1080615463,1030695960,-728142923,416628856,-616003573,-1845983340,-1936803274,550371914,
            754990329,1933819044,932305098,1593975524,-87314772,-652632312,1103634466,-732962174,1086734505,1372607070,-875832674,1369690377,507013662,-407032238,-77331132,-2105915378,1241765527,-570036542,-1479690105,1138245720,-326318395,-755201761,-1129449479,-1712042141,71177362,-396217543,-400343293,-532635104,523480459,-431410627,1981033778,-439922120,-718800572,1816360736,-316400538,-181097875,1552606014,1534891819,-218992690,-1052980415,
            2092100323,119362791,-292171066,-602821389,832004277,-55444234,-166261878,-320120982,2136737800,1475745682,315138776,-1018332031,-1554930575,1532732429,-1572966793,-1884443117,1374014663,-2096725004,57394886,-432168774,-1275390067,72559465,-1577738427,1522972857,-1384841165,-921179769,1520980621,-2062700821,1586596029,368941859,38018381,497950873,1626492230,-1349843410,-1984014473,222126339,237919006,-2071473792,1973319259,1642258552,
            -1186344199,180236139,729656924,-416074140,-380788049,-387144484,-1506110164,2040753784,-189253835,608692839,-2138406212,-632574687,-318126783,-1337558410,1034834948,-438332986,-1255624535,961661269,2004003019,-1467704001,276750419,203291764,-24279844,-1078603435,-88847553,-802831543,-1259324155,792552788,747260900,-1943297774,-72837820,-1123567795,1243112566,195253428,559862962,-1562955222,-1119070145,1109442224,397010862,-257180930,
            2110366193,-39599733,-920859040,1969957277,-908975646,-684726511,1953584346,-1139000410,-424642117,124627780,-1179646950,662595042,-1117430567,857615218,-50491901,268801290,-1980249039,525649264,-562539182,-850570574,126181687,-1301667986,-1509817027,1561225668,340070172,855305616,-1897765192,-1706885616,1240475425,1437840822,-1759298440,-37382361,1278984898,139497136,669725992,1341348711,-1292837174,1817856796,-738675781,1047193242,
            1039690523,-617089764,1156763956,-515455487,-1952697999,-483652013,23988090,-202243195,-54899029,-274376053,-901205496,-1070961956,2092019918,1148348429,949842749,1868079332,1894786517,1647164302,-73337890,-1610665035,-178606699,1465779652,-152325471,-2099928865,400272834,1157945032,785267440,603526753,-583222342,1902857446,259694256,-1114093153,115981912,-2085587094,-262601610,-428553500,-457738509,612143442,-213906655,-1194140078,
            356777449,-476476951,-664437608,-49211361,343495896,1608534067,1797196666,518459535,-1543261266,-1048571987,1626569629,-1794499302,-739512267,-1751076351,51671882,-1540195623,-825448993,160967476,1407400503,203597974,-930728495,-2035073718,1058558549,-1591915119,-219364134,1952951382,937481952,-801448460,-521570304,-817852381,710776115,956206478,2041477662,1212190416,-1491380812,-757267280,745086216,2123767772,788941445,178437700,
            748047757,-1889047106,1825449083,1754813190,420862935,2093052999,1833488258,-1642605499,-1680166702,2041776135,253618345,657257574,1392252458,-784767413,-794479008,539248347,1099947851,-1818494801,148520167,974471902,952153783,1187598264,-208492393,1564859851,1251744677,-1490052284,-30611009,-2018202448,-644176616,-1151263682,1054050354,-151622154,1844305019,2110347231,-1479073219,-423501094,393426041,700889505,511023902,729611317,
            573634457,493669779,-1381482267,523010645,591598148,-1090614529,-1846275434,-811446440,-558214574,-983973019,-290045168,-1841122981,-88634709,-830820966,2146535032,1025324152,-1195094537,-961962422,1421019765,-882660764,1670154809,-89873425,1072164867,811617015,1757882906,1236348903,-81364428,-1777865319,-1483761914,826870087,-381680030,1747827663,-574501090,-2048494664,-56246505,-1342107433,-849057543,-875189365,172575710,479239151,
            -1965964296,-1247024364,-1195276362,-1252774873,1617015082,1571918383,1759412680,1009265021,1196471264,-1073373771,1527796464,140476546,-1286040414,-269936372,-1150520370,-772267242,1749058769,326141161,1533592746,-1983129041,414464800,892582468,1430684610,1599732274,392162039,-155827659,-1918932324,375989795,-1718864595,806551652,897178785,-1348800619,1718101295,-1536329283,-1660780461,-1291194166,1704254937,-129381960,373356477,585218066,
            157252004,-7612335,983482653,2141832399,-799684512,-2119016621,713278030,-1037367772,614600260,-113993564,289268493,-837798094,92164617,-1230614753,1914382404,-1380180387,1423619418,-1671026959,-977369321,-1625117047,-1413471051,-185042739,-2023850974,-1220050951,1632719395,292902892,-1399625400,-68473458,166933663,-774571902,-1327982167,1382190971,1719198196,437384189,1809840489,-226928962,1230096178,-336553591,374318759,-1810572768,
            -223193967,865443040,758836929,1492289092,1887400088,336665750,-287916900,927040757,-1850528322,6249282,-903969449,849458942,1092333595,-995489077,-1881566311,148965630,1039667464,2109112244,-1108376947,-1916778535,1441810607,1343731174,1157210641,134643223,2031719098,-1320432658,1143586631,-240631939,1795511508,1234972592,367182201,592359472,-1879054801,559628377,626072120,987682909,899251955,-1797835296,-281220226,123119105,
            162159961,-1635062961,-718611335,1000847907,45130473,1234255723,789383427,169683846,-1637964327,-1698479302,1079486212,-765104687,825193458,176173906,1125518108,455780354,966766960,-2116539628,-369053578,577378283,1901909379,-2023985441,445553753,-1439401779,-1705844497,143673485,-493352469,-726931061,1436261059,-186232240,1919398692,-1609477449,-1246096591,-560177752,-1800011891,125471277,-1600671289,-2070544289,24461732,-525990077,
            1687637556,518386434,-1452361714,-1297215652,-1457989823,-640044755,1756792715,-677702676,-1808812942,-301488989,196345604,142460316,-1141455470,-278901974,-652266839,489570831,-867785515,-1103073837,-2016208734,906384667,849797912,976432485,151232506,2003053684,2103992785,1287059258,68923186,-2131698839,-1205165326,61823226,-1456949950,-2137568226,-1309945785,664924105,612819279,-982018701,-1575885199,1599924770,909720848,800562912,
            -1119912265,669304114,2139664378,18869025,22484686,-613901665,-1055625225,-39238487,1775437036,-2126627185,289776577,1381803423,-1121469225,1231587282,1514411093,794602933,1898130288,-1115384690,243125420,-913589119,-843307875,1125606513,-1327665136,-1825709721,1735387010,-2010333037,-2105520556,-291309097,1810761771,729053916,878990178,-1966379273,1900259487,15469593,-747434193,-756316950,417059245,-395756547,-872954099,-618720241,
            9527647,-1723646476,-1455158433,382877058,1853537158,-1441425217,682692702,-1992578688,-1927469830,-1206691103,541145839,-257611144,-125813001,-2029350687,-1672145057,266016228,613515669,775112479,21700642,-833351830,2051780346,245112334,1061341693,2045853152,1703718837,-270522175,725310756,-1742042297,1981944605,-1253729156,1682606819,672490298,1582484590,1417196677,1940319571,-72280555,-1575568276,571281067,-935928842,-1667594151,
            946108687,1278486925,-2007020683,501584386,-2001260420,-1253335176,2039270273,399729215,1230954994,-910282862,-98936084,-1755262101,1116418894,811208884,-1992512858,-1964847258,-891379870,1707881946,-1462953540,116228057,-1214184000,-2146594744,1184286238,-1749719170,-1974506682,727884759,-1567467425,1693932136,-2110871093,51884538,572762882,1748650874,13043579,1113654062,-193336026,199025405,2022839247,1650579871,1121242492,-1560413956,
            1167820130,698971337,1638935400,1043617782,1976841867,1627587571,-2028766860,-1440012246,-1027985501,-1345280459,-333396117,853158880,-1195650775,1841891293,-1123533390,513764384,1433817631,1943487728,-614107298,-620625718,45319480,237399135,395906050,1383566246,-792929597,-581222231,1915370113,-1117082788,-928705533,-125240065,1552734104,-1377414638,-1097694746,-1603461459,441056681,-793425900,758594515,-158161519,-1551984907,-1722456539,
            470832112,-1586743534,-1646166584,1547315791,610192236,-1508252796,-538003111,-1661017201,-20534171,1167926790,-1313949675,2130021679,1643703132,474307399,-1992239215,-520459848,75299726,-1646076088,1429633747,648646349,-1621517829,1956833302,-931620681,670286172,-140948293,-467884575,-1155047357,-509779616,1187824315,-1612928654,444592481,31141228,1964433733,-1811230480,-761989546,1354878948,304599947,-1477252560,-468501640,247877217,
            -1923626708,-1820242157,-199472370,858557298,308494913,1122707649,405320297,-2070052059,1370091135,1256688235,-1569979428,-1856244939,-1318728516,2099927657,1547161281,2078428704,1237719241,525809803,1254979959,-1070584918,-703659457,-1365681495,-1894768207,-872019148,1237164434,-1326811521,1370409609,-11459498,-1023382941,668384771,-985177174,180287763,886983770,-1333653800,-468126555,-211140469,-1190443330,581332395,333306807,-354189605,
            -811106326,1830908596,2019191223,-1400884915,1532382331,-1697201089,-98899669,-1473538618,-1279301380,265843341,-765436558,1518415482,-1008278082,1105240716,-926800774,-1590215420,1603049420,-1979669256,1707340629,-1565213885,1443529007,-110943554,-986311761,1217381759,-2054504997,948555274,867018338,-492314299,1104209906,913823663,58872132,851744431,1293905680,1572096599,-796236608,562396586,132793195,-158518774,945770933,-380776898,
            -211348904,1885660360,-1500212638,-1692462131,230841121,-809527039,-231887919,-605168766,-1109922297,1023400824,1539188096,-970513886,-2108607249,1259314547,-2090453831,-1156302188,-1188649977,-1996880995,1461894699,-246084954,-209255156,113804139,-577003446,2013263913,889703132,-175225816,862692213,-2109310038,-1444262284,464587884,-499468048,-184654119,1057006762,101942173,-1990356289,-1406112697,-2191045,815801339,1786462446,-645861502,
            -389371887,-372310912,770665965,-827739991,-455995368,-1135624516,-246158603,844534531,206914424,232698946,13728622,1834402216,-1871907451,-1497549883,-1469430373,-657306131,-1777432088,-80708609,-161857202,1426967545,388438228,1409525699,-64512932,690789698,1651846914,801426307,221078524,1376008106,1503614496,-1462461192,1016979599,1826599287,166194005,1780521172,395812411,1198389004,1597334275,1009797682,-1499882316,-909294570,
            -1343718311,2041321289,-1755862943,-1544759732,1190247889,582892940,481315324,-1230180600,542295065,1796174459,1952821959,-1795571451,-1858332592,603901826,-482068372,842404325,1686901029,1349469567,834956932,-1869444087,-697267073,-634372057,-612296896,-1590040266,-1369137795,919994355,1253084762,940673740,1951936523,-468483638,-1048399933,1690643961,1403899423,243626313,-1604564315,-1890406902,394724890,2028805108,-402733995,432050137,
            1961657873,-289685776,-1829600438,-1443645068,1408307965,1815051851,2057655388,31880863,-599165372,-456094981,961385792,448055258,1056314102,1707891671,288882715,-2116057485,1699900387,-682019602,1531380641,524183226,953094634,-562426695,334372000,86376833,-410001051,-1081475680,-281831423,-1711002136,-80515038,1456530865,2008530350,1971414806,1467393344,650310133,40029930,1681102286,-2021607177,-391535341,-1255028824,1618423460,
            -773065954,-975784094,-662532107,-1546873024,1190594057,1980199312,-544909645,1614970461,-762940306,280217677,-1243188143,-1761334290,1534179333,546338001,2143624190,-1907446918,-1025028184,-1889377472,890307129,-423841007,-706408861,-871527298,-523542851,-188857559,1126899344,1758243924,-431612171,2075848755,1287908296,1021100066,1069541123,-662440991,-484858131,904878224,241887018,1315728161,-1355845666,-962445970,-1183186150,293333164,
            -398130608,-962136930,-2083397364,2105315655,-1399175391,-57916848,-411836,1245844235,772885128,-1932123076,-152386540,2060220711,-576092107,-1278131517,-2089843045,-1593223284,365681442,1762655827,667885089,2085142898,-147858227,-169630659,554286703,1136877521,-1156698581,-2041011878,147032711,1816389677,912239766,908495743,2135059223,1241504042,-983161644,664584122,-100169398,679111901,519076898,1895659037,-1130257890,121811374,
            1256878351,1430031903,-984128001,398250349,1067658074,-1749898545,-1715748078,638348737,-1311126870,-1804395223,-208392837,1809129247,921046247,-722509230,507282429,-906049767,-146397668,1606668997,632206665,-1408701865,18501135,453181265,-60363385,-231389649,-1683738878,2005659191,-1237118567,2128777450,1466747810,900922413,-1418276015,634298711,-560175398,-1960891594,-1769318452,-739514948,-1926877669,-2047925174,-30451251,2124881293,
            234932078,-1094113139,1560731795,1833406715,-1163356307,-679531625,-1085179849,-1499884043,-1330220082,591302482,1643773607,-1362353060,-1025879734,-971782777,-1694398492,208858669,2065518239,297789567,-1125648307,176053554,-2119367687,720437817,-552800796,840139902,1383417162,-617468378,1424600987,827613484,-1209359217,1968072878,-102847228,1117476536,-765065965,-673825065,1505868973,1773403893,-347677941,-1530890335,-1211468857,1103690554,
            -1768898175,1838694251,1756074134,734321882,-1828890563,-308874642,1778235109,-510966747,445691759,1796583239,-1379618454,821767682,-83024161,-938212505,450551017,515488173,1176887644,1069843846,-971787444,-2125750283,388671635,1330511069,-1780689520,-1850343161,569077388,1091828553,-785079570,-1911571627,-942409951,-635042505,-863946763,-1377885957,-112786717,-1201508494,-1668998933,1663061738,-1788087,96117355,1258718859,2048861427,
            1542414988,-1496300657,-1729183301,495949009,-325554248,1214239101,1022157171,-702978818,2016627714,-1775339985,-525558402,356249819,-1183516213,-151022604,1805080294,660286478,-1709114503,-1029455294,353902705,-1827630405,-1994729167,-1935783145,1633353025,-1926459597,615170860,-1468136340,-620670466,382190649,971851008,724918529,1860052056,1916955807,-821615298,129109752,904128920,-759080524,1383959279,-63358123,-543188029,1331361694,
            -1023757559,52616303,1587641857,-2016648823,-444558339,628563676,796305076,-778132809,370619161,-312620998,-1667708688,323790456,-1641503169,817310861,2140829287,157661443,1595567436,71958718,-224517537,-1501703422,1982298885,14581906,1095518807,-837073861,489071458,-2078522743,774559401,-1217791515,1400862917,1286966865,-1056333291,-483354166,-1028065374,887813930,1384561917,1629763183,122129652,-1142712978,915894049,-2144893905,
            -354269430,1069988090,1958101854,971685299,1794342928,87824678,1761266536,2108858975,1516452166,328404221,1355732366,1459257805,-1515209191,-309546605,737505803,642215973,2002416002,1844141754,-1808187853,1614723629,1549435617,642183211,-1295684640,-329735928,548547609,596707323,1680498598,765617725,-1944442962,407465326,1811675701,-410823990,-252202520,570844871,338317560,864942917,1047954879,590469841,-489457059,-1224199058,
            -680642226,-1886200610,516599174,-849753124,-1832957790,441774726,-879683854,-136593842,519687518,280114487,-1316160083,-1539201273,-922037919,-456669540,-1203695021,1675733976,-554289530,-902646332,2090931270,1900915524,1645004015,-1398020913,424522507,467475831,2037129305,477090842,1959990038,-1583929073,532080198,1557509425,-1238440305,2062014371,-1055704276,-211078056,1693384955,966509604,375749514,1693851858,1653497690,722197431,
            -420254768,637422472,-671788120,445866253,-1202440728,760387711,-130401112,-483980807,1877856658,1398060165,-881468508,-1063141103,539579820,914381407,1263633324,-614597601,-1371564799,-472329181,-1450578530,-357813252,-1677364544,-992035160,-966158619,-1979279898,868473521,-670872397,-1583084572,1450774597,-19453795,-368763909,-1371628294,-1723345126,-1408085253,591231277,-771954135,-1770296150,-213318421,1629804968,931406382,1492930134,
            1852919841,42745328,854710391,-2145797584,193702197,650724865,-591415890,-665642332,-222859606,-317269606,1362703851,750406021,870531663,385874904,-1321408192,213297209,666547823,-2112888385,2123780785,118751523,1145125511,2009932613,288854361,-1695912069,1308760356,622570585,1305407402,-200953465,-706243481,318118120,-1354824239,-1060928522,1951000349,1102100144,-2088529920,927262829,-1972200330,727199947,-520318502,870008601,
            1058370166,-1615370329,-1748592747,1031499447,1422043530,-843990456,331839758,1584090260,746362047,638351071,1510289611,902381684,-2110497200,-798248493,-79604360,1012621237,794544751,-399277731,1835796877,-52940066,341655879,975153668,2043570513,-327271703,-154429911,-1730495886,1979312807,2098487578,-253887480,-1470460131,-2137177180,598980528,1516930489,1999107209,656091501,1127622588,-1002732039,2143782375,-1166511579,-1018817077,
            -1315861724,-1532920595,-1151527636,-177624239,1986442850,-1694844328,-834666025,-1425257715,1904851209,-529603976,827796038,2362003,401958238,-1992869008,1813271093,-2051604756,-1868489702,-362383132,1438922289,1407891979,-1948273946,494168503,1262910680,1910121202,-971041435,-1559343350,884228010,-62080430,1608480583,639131716,38612519,-1561542946,209271204,-473608420,-1107565659,581163553,1366320225,1291379350,1714555009,1342595324,
            364365832,528197527,505439208,-278151085,1071901879,1061197041,-1359186420,-918462037,-148435077,-945102976,1615757544,-1241723434,1596833955,-516969387,-1144083271,54257065,-709961818,643592541,-408912087,840915592,-1278797522,-1263539048,-560083404,-471357101,-1221030688,-485365598,-1151916931,492925513,-1464044406,-1925466592,1819903048,529480162,-1910615703,-939039545,-1429333639,240892799,451464968,1417549292,-1382577777,-1515050459,
            -1404699524,-800477327,-1387867368,-2057618892,1423870027,1226140245,-1894407572,1478411841,1774496062,-1063038656,-1205944887,-1473579313,-293347690,-1826085960,-1913401802,1082839130,2067323023,-150099865,1715620091,286115499,-243092458,1942539126,-1766351065,-2093200764,344357740,1947188568,322815154,-658348338,414983568,-89987778,1985541938,-1794927605,753717709,1523849198,-2144681315,-1539181664,-373825797,716675320,251339341,1240786302,
            -53332502,916282595,-1481203061,420924416,1591871511,-641986637,702223949,-982160097,893588475,2042754967,-1962442910,707169731,568736830,1054322754,-847950635,1904450059,-1990180941,-84022065,-1864181512,-755017634,879613158,1657982190,-883159676,-1949575101,1995002971,-1769997811,1149159817,1928984987,1937651034,33910951,1312810510,-1419026226,1875746700,1320542959,674006142,-419060077,-1641895979,34522553,1698822546,1782299133,
            1369918774,1759210364,-1119752482,932819497,-316012464,530277769,1217511578,570813069,1883329465,711374526,-1392190867,721550766,1584978849,-1734429468,-1638711369,1783086350,2025828579,-1702527317,2125174890,1118668043,-1325771874,1424126895,-981358864,-1301566741,1012204914,-767908438,-15224445,-914409964,-270055284,511271965,-2024266930,1700442732,143371839,-818487766,141123585,-906309801,-1048823718,-1282489689,-1979035798,-560935153,
            -1712194603,-1963467878,-1681475485,-558833871,1533939107,-1493673907,1924172641,-2013170924,2047068920,-1433333766,-512672720,1323642068,-1378120182,2021931459,1473398554,-1174843080,927319094,-695114268,1141574808,712020846,476684771,-134703410,-1720556729,1670013425,-1197455257,282024620,1980522493,1389473259,-1942594208,-995787887,1317078543,1734373606,28527849,-1835205551,-1196078849,504914524,2131118359,-1422130253,607075593,470690714,
            225789826,665508277,-1211387410,1359233429,-569681154,-1863504310,-1488462701,-659019641,-58850403,-1478737460,807597669,1306608972,-650978075,2071536012,-291435933,1668333384,-653379526,-1847930655,142095134,-1456992752,-1981561998,1150959949,365987188,2130849583,469748995,1594593329,42496254,-242284254,1724590948,-1784282469,1640722458,-1669239791,-821938067,-1785626147,1585014738,1659812699,-1648917227,-533136637,-494330238,113561752,
            -1156696535,-769103960,-1667244580,987929127,662983380,1034535428,-1844110709,-1180890250,-133230528,-271081761,-1601496507,-659562189,1750603291,-1730058972,-291875279,1496604125,-1810411792,-285813439,510507125,494171829,1608443346,1584679877,310760330,-423664188,-88314687,-1196170203,660890622,1671071200,-698419810,-631395526,-2058447378,-1052911725,723791977,405283105,-1077005503,2095320319,-896550900,-211191180,-1972329586,-1130382427,
            89848047,1477270947,-337284064,-360077159,-1217635158,283260833,-71529054,-1589602326,1245969126,1355072669,905211435,791016321,-26136525,870455241,1554068642,378766398,-156735399,525716050,-1791780565,469532916,1812734636,1734789060,1353632271,462187026,-499496768,-628785651,132334458,1206031516,1567940252,169353224,-1076302777,-1844108965,-1819384071,1773590405,682841144,-1790714675,959211990,378650220,1632911706,-1408368008,
            -1401903058,1842730989,980304954,-1104656137,1928268984,949866492,437612940,977067526,1605802695,-1793569819,-1454420042,247683097,-619744635,-1377112332,-899138975,-1364874992,1276332256,354585970,1716958214,-1726745601,-815623610,359983402,-1546003246,425966321,-1567411344,933979419,849180444,518132527,-725243703,-585408935,-1708829919,909501972,1625237369,-735951341,-978188611,1783246773,1811382523,-1911109380,-708393388,-292023572,
            589860540,-1942832973,-1674899859,-1394904762,1712121432,-1378997096,1147632279,325762141,-1487308097,-1480480105,-575624504,699344642,-1418678393,1971344505,780377660,1043019714,-1229795187,1847296868,-963353838,1508005955,-1471123754,111062780,29296064,1326726011,-1744552797,-338222621,1548076351,-1954504129,1515992076,-464690376,1697036920,794199601,-1627149716,1847397220,-472122969,1059133085,185428730,-1782487891,-1487882321,-724926257,
            -354584117,1359696797,1354871813,-1025655497,-1166144186,-90899347,-1202584373,261645477,1451562836,-712230176,2101638675,1741717022,998379091,1092382253,-1569120529,1869108240,-1497524560,-324570669,47693105,-721806190,-1478172224,1003088027,-1250214868,1455880341,2060450349,-1859046054,1507057615,-1731757015,1352155871,1403138366,-460899407,6667370,1368167134,1809904399,-1727980721,-1221863259,735658633,1045505153,-620452151,-1381234526,
            64205463,1058034163,-46785120,-1087825117,839814024,-1861586038,-844954183,1621993243,-350022323,-480520160,1763509202,1735924715,-1807576526,-687296251,-241811965,1416763272,792489999,214887484,1268481864,-1605035888,-1971412095,-1415758283,-1219662940,-217053838,1902495665,-1106973829,-1163718683,-1578380566,-186771492,-101983093,-290171231,1608466476,40140736,-778044379,428383920,1466818027,-164190140,-517053620,-687266858,-1862028841

        };
        
        Random r = new FastRandom(42);
        for(int i = 0;i < 100;i++) {
            for(int j = 0;j < 40;j++) {
                int next = r.nextInt();
                assertTrue(next == expected[i * 40 + j]);
            }
        }
        
        SerialConfig config = new SerialConfig("FastRandomSerializerTest");
        PersistenceAPI api = Persistence.get(config);
        FastRandom fr = new FastRandom(42);
        
        int middle = expected.length / 2;
        for(int i = 0;i < middle;i++) {
            assertEquals(expected[i], fr.nextInt());
        }
        
        // 1. serialize
        byte[] data = api.write(fr);
        
        // 2. deserialize
        FastRandom serialized = api.read(data);
        
        for(int i = middle;i < expected.length;i++) {
            assertEquals(expected[i], serialized.nextInt());
        }
    }

}
