The ideal PR
============

Thanks for offering your help.

In order to make our cooperation as smooth as possible, we have a couple of guidelines that we'd like you to follow:

- If in doubt, please discuss your ideas first before providing a pull request. This often helps avoid a lot of unnecessary work.
- Fork the repository.
- Check out and work on your own fork.
- Try to make your commits as atomic as possible. Related changes to three files should be committed in one commit.
- The commit message should reference the issue number, e.g. `[#5873] Add Setting.quoteEscaping to allow for alternative escaping of single quotes`.
- Try not to modify anything unrelated, i.e. don't make unimportant whitespace / formatting changes, which will just distract during review.
- **In particular, please do not remove excess whitespace / unnecessary imports etc. The jOOQ Open Source Edition is a "slave clone" of the commercial jOOQ distributions. We'd like to keep all line numbers intact between the two versions!**
- Don't worry about tests. Our unit and integration tests are not open source. If your change is substantial, we'll add tests ourselves.
- Add your name to our [jOOQ/src/main/resources/META-INF/ABOUT.txt](https://github.com/jOOQ/jOOQ/blob/master/jOOQ/src/main/resources/META-INF/ABOUT.txt) file
- Be sure you agree to transfer your rights to us (see below) before contributing.

Contributing to dual-licensed Open Source
=========================================

Thank you very much for contributing to jOOQ.

jOOQ is dual-licensed Open Source software. While the version published here on GitHub is [ASL 2.0](http://www.apache.org/licenses/LICENSE-2.0) licensed, we also ship jOOQ under a commercial license to those customers who want to use jOOQ with commercial databases. For more information about commercial licensing, please refer to this website:
[http://www.jooq.org/legal/licensing](http://www.jooq.org/legal/licensing)

Our dual-licensing means that we need you to tranfer all rights to your contribution to us, [Data Geekery GmbH](http://www.datageekery.com), in order to be able to re-license your contribution also to our commercial customers, if your contribution consists in any of the following:

- Source code to be embedded into jOOQ deliverables
- Source code to be embedded into jOOQ integration tests
- Content to be embedded into our manual

No transfer of rights is needed for the following:

- Bug reports
- Feature requests and discussions
- Example code to reproduce bugs

If your contribution requires a transfer of rights, please sign the following document before proceeding:
http://www.jooq.org/legal/contributions

Thank you again very much for your contribution
The jOOQ Team
