CREATE OR REPLACE FUNCTION LICENSE_SERVER.GENERATE_KEY(
    IN license_date TIMESTAMP WITH TIME ZONE,
    IN email TEXT
) RETURNS VARCHAR
AS $$
BEGIN
    RETURN 'license-key';
END;
$$ LANGUAGE PLPGSQL;

CREATE TABLE LICENSE_SERVER.LICENSE (
  ID           SERIAL8      NOT NULL,

  LICENSE_DATE TIMESTAMP    NOT NULL,
  LICENSEE     TEXT         NOT NULL,
  LICENSE      TEXT         NOT NULL,
  VERSION      VARCHAR(50)  NOT NULL DEFAULT '.*',

  CONSTRAINT PK_LICENSE PRIMARY KEY (ID),
  CONSTRAINT UK_LICENSE UNIQUE (LICENSE)
);

CREATE TABLE LICENSE_SERVER.LOG_VERIFY (
  ID           SERIAL8      NOT NULL,

  LICENSEE     TEXT         NOT NULL,
  LICENSE      TEXT         NOT NULL,
  REQUEST_IP   VARCHAR(50)  NOT NULL,
  MATCH        BOOLEAN      NOT NULL,
  VERSION      VARCHAR(50)  NOT NULL,

  CONSTRAINT PK_LOG_VERIFY PRIMARY KEY (ID)
);
