/**
 * The MIT License
 * Copyright (c) 2014 Ilkka Seppälä
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.iluwatar.front.controller;

/**
 * 
 * The Front Controller is a presentation tier pattern. Essentially it defines a controller that
 * handles all requests for a web site.
 * <p>
 * The Front Controller pattern consolidates request handling through a single handler object (
 * {@link FrontController}). This object can carry out the common the behavior such as
 * authorization, request logging and routing requests to corresponding views.
 * <p>
 * Typically the requests are mapped to command objects ({@link Command}) which then display the
 * correct view ({@link View}).
 * <p>
 * In this example we have implemented two views: {@link ArcherView} and {@link CatapultView}. These
 * are displayed by sending correct request to the {@link FrontController} object. For example, the
 * {@link ArcherView} gets displayed when {@link FrontController} receives request "Archer". When
 * the request is unknown, we display the error view ({@link ErrorView}).
 *
 */
public class App {

  /**
   * Program entry point
   * 
   * @param args
   *          command line args
   */
  @edu.cuny.hunter.streamrefactoring.annotations.EntryPoint public static void main(String[] args) {
    FrontController controller = new FrontController();
    controller.handleRequest("Archer");
    controller.handleRequest("Catapult");
    controller.handleRequest("foobar");
  }
}
