package civvi.common;

/**
 * Utilities for handling {@link Enum}s.
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Dan Siviter</a>
 * @since v1.0.0 [22 Oct 2007]
 */
public class EnumUtil {
	private EnumUtil() {
		// prevent init!
	}

	/**
	 * A convenience method of finding an {@link Enum} by ordinal.
	 * 
	 * @param <E>
	 * @param type the enum type to find.
	 * @param ordinal the {@link Enum#ordinal()} value.
	 * @return the found Enum.
	 * @throws ArrayIndexOutOfBoundsException if ordinal isn't found.
	 * @throws IllegalArgumentException if type is not an {@link Enum}.
	 */
	public static <E extends Enum<?>> E valueOf(Class<E> type, int ordinal) {
		if (!type.isEnum())
			throw new IllegalArgumentException(String.format(
					"Type is not an enum! [%s]",
					type));
		return type.getEnumConstants()[ordinal];
	}
}
