package civvi.common;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * TODO
 *
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [27 Feb 2007]
 */
public final class JarUtil {

	private JarUtil() {
		// prevent construction!
	}

	/**
	 * TODO
	 *
	 * @param jarName
	 */
	@SuppressWarnings("deprecation")
	public static void loadJar(File jarName) throws IOException {
		loadJar(jarName.toURL());
	}

	/**
	 * TODO
	 *
	 * @param jarName
	 */
	public static void loadJar(URL jarName) {
		new JarClassLoader(jarName);
	}


	// --- Inner Classes ---

	/**
	 * A {@link URLClassLoader} for {@code .jar}s.
	 *
	 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
	 * @since v1.0.0 [27 Feb 2007]
	 */
	private static class JarClassLoader extends URLClassLoader {
		private URL url;

		/**
		 * Creates a new JarClassLoader for the specified URL.
		 *
		 * @param url the url of the jar file
		 */
		public JarClassLoader(URL url) {
			super(new URL[] { url });
			this.url = url;
		}

		/**
		 * TODO
		 *
		 * @param attributeName
		 * @return
		 * @throws IOException
		 * @see {@link Attributes.Name}
		 */
		public String getAttribute(Attributes.Name attributeName) throws IOException {
			final URL u = new URL("jar", "", this.url + "!/");
			final JarURLConnection conn = (JarURLConnection) u.openConnection();
			final Attributes attr = conn.getMainAttributes();
			return attr != null ? attr.getValue(attributeName) : null;
		}

		/**
		 * Invokes the application in this jar file given the name of the
		 * main class and an array of arguments. The class must define a
		 * static method "main" which takes an array of String arguments
		 * and is of return type "void".
		 *
		 * @param args the arguments for the application.
		 * @throws ClassNotFoundException if the specified class could not be
		 * found.
		 * @throws NoSuchMethodException if the specified class does not contain
		 * a "main" method.
		 * @throws InvocationTargetException if the application raised an
		 * exception.
		 * @throws IOException
		 */
		@SuppressWarnings("unused")
		public void invokeClass(String[] args)
		throws ClassNotFoundException, NoSuchMethodException,
		InvocationTargetException, IOException
		{
			final Class<?> c = loadClass(getAttribute(Attributes.Name.MAIN_CLASS));
			final Method m = c.getMethod("main", new Class[] { args.getClass() });
			m.setAccessible(true);
			final int mods = m.getModifiers();
			if (m.getReturnType() != void.class ||
					!Modifier.isStatic(mods) ||
					!Modifier.isPublic(mods))
			{
				throw new NoSuchMethodException("main");
			}

			try {
				m.invoke(null, new Object[] { args });
			} catch (IllegalAccessException iae) {
				final Logger log = Logger.getAnonymousLogger();
				if (log.isLoggable(Level.WARNING)) {
					log.log(Level.WARNING, iae.getMessage(), iae);
				}
			}
		}
	}
}