package civvi.common;

import static civvi.common.LdapUtil.getDomain;
import static civvi.common.LdapUtil.getLdapContext;
import static civvi.common.LdapUtil.toDC;
import static civvi.common.LdapUtil.toPrincipleName;
import static javax.naming.directory.SearchControls.SUBTREE_SCOPE;

import java.net.UnknownHostException;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

/**
 * A set of utilities for performing lookup of LDAP services.
 *   
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [23 May 2010]
 */
public class LdapSupport {
	private String domain;
	private DirContext context;

	/**
	 * 
	 * TODO
	 * @param username
	 * @param password
	 * @throws NamingException
	 */
	public void init(String username, String password) throws NamingException {
		try {
			this.domain = getDomain();
			this.context = getLdapContext(this.domain, username, password);
		} catch (UnknownHostException uhe) {
			final NamingException ne = new NamingException(
					"Unable to resolve domain automatically!");
			ne.setRootCause(uhe);
			throw ne;
		}
	}

	/**
	 * 
	 * TODO
	 * @return
	 */
	public boolean isInitialised() {
		return context != null;
	}

	/**
	 * 
	 * TODO
	 * @throws NamingException
	 */
	public void destroy() throws NamingException {
		if (!isInitialised()) {
			throw new IllegalStateException("Context not initialised!");
		}
		this.context.close();
		this.context =  null;
	}

	/**
	 * 
	 * TODO
	 * @return
	 */
	protected DirContext getContext() {
		if (!isInitialised()) {
			throw new IllegalStateException("Context not initialised!");
		}
		return this.context;
	}

	/**
	 * 
	 * TODO
	 * @param controls
	 * @param query
	 * @return
	 * @throws NamingException
	 */
	public NamingEnumeration<SearchResult> search(
			SearchControls controls,
			String query)
	throws NamingException
	{
		return getContext().search(toDC(this.domain), query, controls);
	}

	/**
	 * 
	 * TODO
	 * @param username
	 * @return
	 * @throws NamingException
	 */
	public SearchResult getUser(String username) throws NamingException {
		// locate this user's record  
		final SearchControls controls = new SearchControls();  
		controls.setSearchScope(SUBTREE_SCOPE);
		final String principalName = toPrincipleName(username, domain);
		NamingEnumeration<SearchResult> renum = search(
				controls,
				String.format("(& (userPrincipalName=%s)(objectClass=user))", principalName));
		if(!renum.hasMore()) {  
			renum = search(controls, "(& (sAMAccountName=" + username + ")(objectClass=user))");  
			if(!renum.hasMore())  
				throw new RuntimeException(String.format(
						"Unable to locate user information! [username=%s]",
						username));  
		}  
		return renum.next();  
	}
}
