package civvi.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

/**
 * Basic {@link Handler} to store the records.
 *
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since 13 Mar 2007
 */
public class LogRepositoryHandler extends Handler {
	private static Collection<LogRecord> RECORDS =
		Collections.synchronizedCollection(new ArrayList<LogRecord>());
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void close() throws SecurityException {
		RECORDS.clear();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void flush() {
		// do nothing!
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void publish(LogRecord record) {
		RECORDS.add(record);
	}
	
	
	// --- Static Methods ---
	
	/**
	 * @return returns a list of the known records.
	 */
	public static Collection<LogRecord> getRecords() {
		return RECORDS;
	}
}
