package civvi.common;

import java.lang.Thread.UncaughtExceptionHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Root application class that launches into the ADT application framework.
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since 26th October 2007
 */
public class LoggingExceptionHandler implements UncaughtExceptionHandler {
	private final Logger log = Logger.getLogger(getClass().getName());

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void uncaughtException(Thread t, Throwable e) {
		// we should never have these, so it's severe!
		this.log.log(Level.SEVERE, "Uncaught Exception!", e);
	}
}
