package civvi.common;

import java.nio.CharBuffer;

/**
 * 
 * TODO
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since 14 Apr 2009
 */
public final class NioUtil {
	public static final int DEFAULT_BUFFER = 1024;

	public NioUtil() {
		// prevent construction
	}

	/**
	 * Ensures the buffer has sufficient capacity to fit in the number of
	 * characters given by {@code size}. If not, a new {@link CharBuffer} will
	 * be allocated and the contents of the original copied into the new one. 
	 *
	 * @param buffer
	 * @param size
	 * @return
	 */
	public static CharBuffer ensureCapacity(
			CharBuffer buffer,
			int size)
	{
		return ensureCapacity(buffer, DEFAULT_BUFFER, size);
	}
	
	/**
	 * Ensures the buffer has sufficient capacity to fit in the number of
	 * characters given by {@code size}. If not, a new {@link CharBuffer} will
	 * be allocated and the contents of the original copied into the new one. 
	 *
	 * @param buffer
	 * @param bufferSize
	 * @param size
	 * @return
	 */
	public static CharBuffer ensureCapacity(
			CharBuffer buffer,
			int bufferSize,
			int size)
	{
		if (buffer.capacity() - buffer.position() >= size) {
			return buffer;
		}

		final CharBuffer newBuffer =
			CharBuffer.allocate(buffer.capacity() + bufferSize);
		buffer.flip();
		newBuffer.put(buffer);
		return newBuffer;
	}
}
