package civvi.common;

import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

/**
 * 
 * TODO
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since 14 Apr 2009
 */
public final class SoapUtil {
	
	public SoapUtil() {
		// prevent construction
	}

	/**
	 * TODO
	 * 
	 * @param port
	 * @param level
	 */
	public static void attachLogger(Object port, Level level) {
		attachLogger((BindingProvider) port, level);
	}
	
	/**
	 * TODO
	 * 
	 * @param provider
	 * @param level
	 */
	@SuppressWarnings("rawtypes")
	public static void attachLogger(BindingProvider provider, Level level) {
		final Binding binding = provider.getBinding();
		final List<Handler> handlerList = binding.getHandlerChain();
		final LoggingHandler loggingHandler = new LoggingHandler(level);
		handlerList.add(loggingHandler);
		binding.setHandlerChain(handlerList);
	}
	
	/**
	 * TODO
	 * 
	 * @author 
	 *
	 */
	private static class LoggingHandler
	implements SOAPHandler<SOAPMessageContext>
	{
		private final Logger log = Logger.getLogger(getClass().getName());
		private final Level level;

		public LoggingHandler(Level level) {
			this.level = level;
		}
		
		
	    /**
	     * {@inheritDoc}
	     */
	    @Override
	    public Set<QName> getHeaders() {
	        return null;
	    }

	    /**
	     * {@inheritDoc}
	     */
	    @Override
	    public boolean handleMessage(SOAPMessageContext smc) {
	        log(smc);
	        return true;
	    }

	    /**
	     * {@inheritDoc}
	     */
	    @Override
	    public boolean handleFault(SOAPMessageContext smc) {
	        log(smc);
	        return true;
	    }

	    /**
	     * {@inheritDoc}
	     */
	    @Override
	    public void close(MessageContext messageContext) {
	    	// nothing to clean up!
	    }
	    
	    /**
	     * Check the MESSAGE_OUTBOUND_PROPERTY in the context
	     * to see if this is an outgoing or incoming message.
	     * Write a brief message to the print stream and
	     * output the message. The writeTo() method can throw
	     * SOAPException or IOException
	     * 
	     * @param smc
	     */
	    private void log(SOAPMessageContext smc) {
	        final boolean outbound = (Boolean)
	            smc.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);
	        
	        StringBuilder builder = new StringBuilder();
	        
	        if (outbound) {
	        	builder.append("Outbound message:\n");
	        } else {
	        	builder.append("Inbound message:\n");
	        }
	        
	        final SOAPMessage message = smc.getMessage();
	        try {
				final ByteArrayOutputStream os = new ByteArrayOutputStream();
//				final PrintStream printStream = new PrintStream(os);
				message.writeTo(os);
	        	
	        	builder.append(os.toString());
	        	
	        	if (log.isLoggable(level)) {
		        	log.log(level, builder.toString());
		        }
	        } catch (Exception e) {
	        	if (log.isLoggable(Level.WARNING)) {
		        	log.log(Level.WARNING, builder.toString(), e);
		        }
	        }
	    }
	}
}
