package civvi.common;


/**
 * Utility class for thread operations.
 *
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since 09-Mar-2006
 */
public final class ThreadUtil {

	private ThreadUtil() {
		// prevent construction!
	}
	
	/**
	 * Test if the current <code>Thread</code> was interrupted and if so
	 * throws a <code>CancellationException</code>. This is useful for safely
	 * exiting out of a thread operation without calling
	 * <code>Thread.stop()</code>.
	 * For further information see
	 * <a href="http://java.sun.com/docs/books/tutorial/essential/threads/lifecycle.html">
	 * Thread Lifecycle</a> or 
	 * <a href="http://www.forward.com.au/javaProgramming/HowToStopAThread.html">
	 * How To Stop a Thread</a>.
	 * 
	 * @throws InterruptedException  Thrown to indicate the {@code Thread}
	 * has been interrupted and therefore cancelled.
	 */
	public static void wasCancelled() throws InterruptedException {
		if (Thread.interrupted()) {
			throw new InterruptedException("Thread was interrupted!");
		}
	}
}
