package civvi.common.builder;

import java.math.BigDecimal;

import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;

import civvi.common.XmlBuilder;

/**
 * 
 * TODO
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [10th October 2008]
 */
public class XmlBuilderStax extends XmlBuilder {

	static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

	static {
		// Set up stax as the default StAX parser.
		// if this is not done, the insertSubTree() fails when given a DOMSource as an input
		System.setProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
		System.setProperty("javax.xml.stream.XMLOutputFactory", "com.ctc.wstx.stax.WstxOutputFactory");
		System.setProperty("javax.xml.stream.XMLEventFactory", "com.ctc.wstx.stax.WstxEventFactory");
	}
	
    XMLStreamWriter writer;
    int depth = 0;
    
	XmlBuilderStax(XMLStreamWriter writer, String rootElementName) {
		this.writer = writer;
		element(rootElementName);
	}

	XmlBuilderStax(XMLStreamWriter writer) {
		this.writer = writer;
	}

	@Override
	public XmlBuilderStax attribute(String name, String value) {
		try {
			if (value != null) {
				writer.writeAttribute(name, value);
			}
		} catch (XMLStreamException e) {
			throw new XmlBuilderException(e);
		}
		return this;
	}

	@Override
	public XmlBuilderStax cdata(String data) {
		try {
			writer.writeCData(data);
		} catch (XMLStreamException e) {
			throw new XmlBuilderException(e);
		}
		return this;
	}

	@Override
	public XmlBuilderStax comment(String comment) {
		try {
			writer.writeComment(comment);
		} catch (XMLStreamException e) {
			throw new XmlBuilderException(e);
		}
		return this;
	}

	@Override
	public XmlBuilderStax element(String name) {
		try {
			writer.writeStartElement(name);
		} catch (XMLStreamException e) {
			throw new XmlBuilderException(e);
		}
		depth++;
		return this;
	}

	@Override
	public XmlBuilderStax instruction(String target, String data) {
		try {
			writer.writeProcessingInstruction(target, data);
		} catch (XMLStreamException e) {
			throw new XmlBuilderException(e);
		}
		return this;
	}

	@Override
	public XmlBuilderStax text(String text) {
		if (text != null) {
			try {
				writer.writeCharacters(text);
			} catch (XMLStreamException e) {
				throw new XmlBuilderException(e);
			}
		}
		return this;
	}

	@Override
	public XmlBuilderStax text(BigDecimal value) {
		if (value != null) {
			text(value.toPlainString());
		}
		return this;
	}

    @Override
    public XmlBuilderStax textElement(String name, Object value) {
    	if (value != null) {
    		element(name)
    			.text(value.toString())
    		.up();
    	}
        return this;
    }

	@Override
	public XmlBuilderStax up(int steps) {
		if (steps == 0) {
			return this;
		}
		
		try {
			writer.writeEndElement();
			depth--;
		
			if (depth == 0) {
				writer.writeEndDocument();
				return null;
			} else {
				return up(steps - 1);
			}
		} catch (XMLStreamException e) {
			throw new XmlBuilderException(e);
		}
	}

	@Override
	public XmlBuilderStax reference(String name) {
		try {
			writer.writeEntityRef(name);
		} catch (XMLStreamException e) {
			throw new XmlBuilderException(e);
		}
		return this;
	}

	@Override
	public XmlBuilderStax root() {
		return up(depth);
	}

	@Override
	public XmlBuilderStax insertSubTree(Source source) {
		try {
			final XMLStreamReader reader = xmlInputFactory.createXMLStreamReader(source);

			// move past the start of the document as we don't want to copy that
			if ( reader.getEventType() == XMLStreamConstants.START_DOCUMENT) {
				reader.next();
			}
			
			XmlStreamCopier copier = new XmlStreamCopier(reader, writer);
			copier.copy(true);
			reader.close();
			
		} catch (XMLStreamException e) {
			throw new XmlBuilderException(e);
		} catch (FactoryConfigurationError e) {
			throw new XmlBuilderException(e);
		}

		return this;
	}
}
