package civvi.osgi.desktop;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.osgi.framework.BundleContext;

import civvi.osgi.desktop.view.AbstractView;
import civvi.osgi.desktop.view.log.LogEntriesView;
import civvi.osgi.desktop.view.properties.PropertiesView;
import civvi.osgi.desktop.view.task.TasksView;
import civvi.osgi.desktop.view.welcome.WelcomeView;

/**
 * 
 * TODO
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since 14 Apr 2009
 */
public class DefaultService extends AbstractDesktopService<DesktopContext> {
	private final Logger log = Logger.getLogger(getClass().getName());
	
	private final Set<Class<? extends AbstractView>> viewSet =
		new HashSet<Class<? extends AbstractView>>();
	
	public DefaultService(BundleContext context) {
		super(context);
		viewSet.add(WelcomeView.class);
		viewSet.add(PropertiesView.class);
		viewSet.add(TasksView.class);
		viewSet.add(LogEntriesView.class);
	}

	/**
	 * {@inheritDoc}
	 */
//	@Override
	public Class<? extends AbstractView> getViewType(Object key) {
		for (Class<? extends AbstractView> type : viewSet) {
			try {
				final BeanInfo beanInfo = Introspector.getBeanInfo(type);
				if (key.equals(beanInfo.getBeanDescriptor().getValue("viewKey"))) {
					return type;
				}
			} catch (IntrospectionException ie) {
				log.log(Level.WARNING, String.format(
						"Unable to locate BeanInfo! [type=%s]", type), ie);
			}
		}

		throw new IllegalArgumentException(String.format(
				"Unknown view! [key=%s]", key));
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	@SuppressWarnings("unchecked")
	public Class<? extends AbstractView>[] getViews() {
		return viewSet.toArray(new Class[viewSet.size()]);
	}
}
