package civvi.osgi.desktop;

/**
 * Defines a basic context for a desktop plug-in. 
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [8 Jun 2010]
 */
public interface DesktopContext {
	/**
	 * Initialise the context.
	 * 
	 * @throws IllegalStateException if the context is not initialised.
	 */
	void init();

	/**
	 * @return {@code true} if the context is initialised.
	 */
	boolean isInitialised();

	/**
	 * Destroy the context.
	 * 
	 * @throws IllegalStateException if the context is not initialised.
	 */
	void destroy();
}
