package civvi.osgi.desktop;

import java.util.prefs.Preferences;

import civvi.osgi.desktop.preferences.AbstractPreferencePane;
import civvi.osgi.desktop.swingx.ActionProvider;
import civvi.osgi.desktop.view.AbstractView;

/**
 * Defines a desktop plug-in for the {@link OSGiDesktop}.
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since 24th July 2008
 */
public interface DesktopService<C extends DesktopContext> extends ActionProvider {
	/**
	 * @return all the view types for this service.
	 */
	Class<? extends AbstractView>[] getViews();

	/**
	 * @return an editor for the preferences.
	 */
	Class<? extends AbstractPreferencePane> getPreferencesEditor();

	/**
	 * @return an initialised instance of the context or {@code null}.
	 * @throws IllegalStateException if the context is not initialised.
	 */
	C getContext() throws IllegalStateException;

	/**
	 * Initialise the service.
	 * 
	 * @throws IllegalStateException if the service is already initialised.
	 */
	void init() throws IllegalStateException;

	/**
	 * @return {@code true} if the service is initialised.
	 */
	boolean isInitialised();

	/**
	 * Destroy the service.
	 * 
	 * @throws IllegalStateException if the service is not initialised.
	 */
	void destroy() throws IllegalStateException;
	
	/**
	 * @return a instance of the preferences for this service. 
	 */
	Preferences getPreferences();
}
