package civvi.osgi.desktop;

import java.util.EventObject;

import org.osgi.framework.ServiceReference;

/**
 * An {@link EventObject} for {@link DesktopService}s.
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since 19 Mar 2009
 */
public class DesktopServiceEvent extends EventObject {
	private static final long serialVersionUID = -7769396768878134841L;

	public enum Type {
		ADDED,
		REMOVED
	}

	private final DesktopService<?> service;
	private final ServiceReference ref;
	private final Type type;

	/**
	 * 
	 * TODO
	 * 
	 * @param source
	 * @param service
	 * @param ref
	 * @param type
	 */
	public DesktopServiceEvent(
			DesktopServiceManager source,
			DesktopService<?> service,
			ServiceReference ref,
			Type type)
	{
		super(source);
		this.service = service;
		this.ref = ref;
		this.type = type;
	}

	/**
	 * @return the service.
	 */
	public DesktopService<?> getService() {
		return service;
	}

	/**
	 * @return the ref.
	 */
	public ServiceReference getRef() {
		return ref;
	}

	/**
	 * @return the type.
	 */
	public Type getType() {
		return type;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public DesktopServiceManager getSource() {
		return (DesktopServiceManager) super.getSource();
	}
}
