package civvi.osgi.desktop;


import civvi.osgi.desktop.editor.Editable;
import civvi.osgi.desktop.swingx.wizard.DefaultController;
import civvi.osgi.desktop.wizard.neweditor.NewEditableModel;

/**
 * Defines an OSGi service for an editing an object.
 *  
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [13 Nov 2009]
 */
public interface EditableService<C extends DesktopContext>
extends DesktopService<C>
{
	/**
	 * @return returns the editable object type.
	 */
	Class<? extends Editable> getType();

	/**
	 * @return the wizard controller for initiating the edit of an {@link Editable}.
	 */
	Class<? extends DefaultController<NewEditableModel>> getStepPanelResolverType();
}
