package civvi.osgi.desktop;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RadialGradientPaint;

import civvi.osgi.desktop.swingx.SwingUtil;


/**
 * A Painter that can resize {@link RadialGradientPaint} which cannot be done
 * by {@link org.jdesktop.swingx.painter.MattePainter}.
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since 5 Jun 2009
 */
public class MattePainter extends org.jdesktop.swingx.painter.MattePainter {

	public MattePainter(Paint paint) {
		super(paint);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void doPaint(Graphics2D g, Object component, int width, int height) {
		Paint p = getFillPaint();
		if (p != null) {
			if(isPaintStretched()) {
				p = calculatePaint(p,width,height);
			}
			g.setPaint(p);
			g.fillRect(0, 0, width, height);
		}
	}

	private Paint calculatePaint(Paint p, int width, int height) {
		return SwingUtil.resizeGradient(p, width, height);
	}
}
