package civvi.osgi.desktop;

import java.awt.Font;
import java.io.IOException;

import org.jdesktop.application.ResourceMap;

/**
 * Allows persisting of resources or extraction of previously persisted data.
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since 24 Apr 2009
 */
public class SaveableResourceMap extends ResourceMap {

	/**
	 * 
	 * TODO
	 * 
	 * @param parent
	 * @param classLoader
	 * @param bundleNames
	 */
	public SaveableResourceMap(
			ResourceMap parent,
			ClassLoader classLoader,
			String[] bundleNames)
	{
		super(parent, classLoader, bundleNames);
	}

	/**
	 * 
	 * TODO
	 *
	 * @param key
	 * @param font
	 */
	public void putFont(String key, Font font) {
		String style = "plain";

		if (font.isBold())
			style = "bold";
		if (font.isItalic())
			style += "italic";

		put(key, String.format(
				"%s-%s-%s",
				font.getFontName(),
				style,
				font.getSize()));
	}

	/**
	 * 
	 * TODO
	 *
	 * @param key
	 * @param value
	 */
	public void put(String key, String value) {
		Object objValue = getResource(key);

		if (objValue == null) {
			throw new IllegalArgumentException(String.format(
					"Resource doesn't exit! [key=%s]", key));
		}

		if (((String) objValue).contains("${")) {
			throw new RuntimeException(String.format(
					"Resource isn't first class citizen! [key=%s]", key));
		}

		getBundlesMap().put(key, value);
	}

	/**
	 * 
	 * TODO
	 *
	 * @throws IOException
	 */
	public void load() throws IOException {
		throw new UnsupportedOperationException();
	}

	/**
	 * 
	 * TODO
	 *
	 * @throws IOException
	 */
	public void save() throws IOException {
		throw new UnsupportedOperationException();
	}
}
