package civvi.osgi.desktop.component.about;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.RadialGradientPaint;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map.Entry;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXEditorPane;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.GlossPainter;
import org.jdesktop.swingx.painter.ImagePainter;
import org.jdesktop.swingx.painter.TextPainter;
import org.jdesktop.swingx.painter.AbstractLayoutPainter.HorizontalAlignment;
import org.jdesktop.swingx.painter.AbstractLayoutPainter.VerticalAlignment;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;

import civvi.osgi.desktop.OSGiDesktop;
import civvi.osgi.desktop.swingx.AbstractListTableModel;
import civvi.osgi.desktop.swingx.AbstractTask;
import civvi.osgi.desktop.swingx.EditorComponent;
import civvi.osgi.desktop.swingx.SwingUtil;
import civvi.osgi.desktop.swingx.painter.RadialGradientPainter;
import civvi.osgi.desktop.view.properties.PropertiesTableModel;
import civvi.osgi.desktop.view.properties.PropsColumn;

import com.jhlabs.image.ShadowFilter;

/**
 * A view to display information about the application.
 *
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since 3rd Dec 2007
 */
public class AboutPanel extends EditorComponent<Void> {
	private static final long serialVersionUID = -8009238742912374786L;

	private final JXTable propertiesTable;
	private final JXTable bundleTable;

	private final OSGiDesktop desktop;
	private final AbstractListTableModel<Entry<Object, Object>, PropsColumn> propsModel;
	private final AbstractListTableModel<Bundle, BundleColumn> bundleModel;


	/**
	 * Default constructor.
	 */
	public AboutPanel(OSGiDesktop desktop) {
		super(new BorderLayout(10, 10));
		this.desktop = desktop;
		setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
		final JXPanel header = new JXPanel();
		header.setPreferredSize(new Dimension(400, 75));

		final ShadowFilter shadowFilter = new ShadowFilter();
		shadowFilter.setAngle(-90.0f);
		shadowFilter.setDistance(3.0f);
		shadowFilter.setRadius(3.0f);
		shadowFilter.setOpacity(0.75f);

		final TextPainter titlePainter = new TextPainter();
		titlePainter.setFont(new Font("Tahoma", Font.PLAIN, 32));
		titlePainter.setText(getResourceMap().getString("Application.title"));
		titlePainter.setFillPaint(Color.WHITE);
		titlePainter.setVerticalAlignment(VerticalAlignment.TOP);
		titlePainter.setHorizontalAlignment(HorizontalAlignment.LEFT);
		titlePainter.setInsets(new Insets(5,10,10,10));
		titlePainter.setFilters(shadowFilter);

		final TextPainter subtitlePainter = new TextPainter();
		final Bundle bundle = desktop.getActivator().getContext().getBundle();
		subtitlePainter.setText(bundle.getVersion().toString());
		subtitlePainter.setFillPaint(Color.WHITE);
		subtitlePainter.setVerticalAlignment(VerticalAlignment.TOP);
		subtitlePainter.setHorizontalAlignment(HorizontalAlignment.RIGHT);
		subtitlePainter.setInsets(new Insets(10,10,10,75));
		subtitlePainter.setFilters(shadowFilter);

		final TextPainter copyrightPainter = new TextPainter();
		copyrightPainter.setText(getResourceMap().getString("Application.copyright"));
		copyrightPainter.setFillPaint(Color.WHITE);
		copyrightPainter.setVerticalAlignment(VerticalAlignment.BOTTOM);
		copyrightPainter.setHorizontalAlignment(HorizontalAlignment.LEFT);
		copyrightPainter.setInsets(new Insets(10,10,10,10));
		copyrightPainter.setFilters(shadowFilter);

		final RadialGradientPaint background = new RadialGradientPaint(
				new Point2D.Double(1.0, 1.0),
				1.0f,
				new float[] { 0.0f, 1.0f },
				new Color[] { new Color(0, 0, 0, 0), new Color(0, 0, 0, 128) });

		final RadialGradientPainter rectanglePainter = 
			new RadialGradientPainter(background);
		rectanglePainter.setRounded(true);
		rectanglePainter.setRoundHeight(10);
		rectanglePainter.setRoundWidth(10);

		final BufferedImage image = SwingUtil.toBufferedImage(
				getResourceMap().getImageIcon("Application.icon.large").getImage());
		final ImagePainter imagePainter = new ImagePainter(
				image, HorizontalAlignment.RIGHT, VerticalAlignment.CENTER);
		imagePainter.setInsets(new Insets(5,5,5,10));
		
		header.setBackgroundPainter(new CompoundPainter<JXPanel>(
				rectanglePainter,
				titlePainter,
				copyrightPainter,
				subtitlePainter,
				imagePainter,
				new GlossPainter()));

		add(header, BorderLayout.NORTH);

		this.propsModel = new PropertiesTableModel<Object, Object>();
		this.propertiesTable = new JXTable(this.propsModel);
		this.propertiesTable.setColumnControlVisible(true);

		this.bundleModel = new BundleTableModel();
		this.bundleTable = new JXTable(this.bundleModel);
		this.bundleTable.setHorizontalScrollEnabled(true);
		this.bundleTable.setColumnControlVisible(true);

		final JTabbedPane tabbedPane = new JTabbedPane();
		tabbedPane.addTab(
				getResourceMap().getString("tabbedPane.tabTitle.info"),
				createTab(createInfo()));
		tabbedPane.addTab(
				getResourceMap().getString("tabbedPane.tabTitle.properties"),
				createTab(new JScrollPane(this.propertiesTable)));
		tabbedPane.addTab(
				getResourceMap().getString("tabbedPane.tabTitle.plugins"),
				createTab(new JScrollPane(this.bundleTable)));
		add(tabbedPane, BorderLayout.CENTER);
		Application.getContext().getTaskService().execute(refresh());
	}

	@Override
	protected void updateFields(Void editableBean) { }
	
	/**
	 * TODO
	 */
	@Action
	private Task<List<?>, Void> refresh() {
		return new RefreshAboutDataTask();
	}
	
	@Action
	public Task<Void, String> longRunningAction() {
		return new LongRunningTask();
	}

	/**
	 * @return a new instance of the information component.
	 */
	private JComponent createInfo() {
		final JXPanel panel = new JXPanel(new BorderLayout());
		panel.setOpaque(false);
//		final JXScene<SceneHook> scene = new JXScene<SceneHook>();
//		scene.setScene("civvi.osgi.desktop.component.about.AboutScene");
//		final SceneHook hook = scene.getScene();
//		hook.talk("hello");
//		System.out.println(hook);
		panel.add(new JLabel("TODO"), BorderLayout.CENTER);
		panel.add(new JButton(getContext().getActionMap(this).get("longRunningAction")), BorderLayout.SOUTH);
		return panel;
	}

	/**
	 * 
	 * TODO
	 *
	 * @return
	 */
	private ApplicationContext getContext() {
		return Application.getContext();
	}
	
	/**
	 * @return the resource map for the view.
	 */
	public ResourceMap getResourceMap() {
		return getContext().getResourceMap(getClass());
	}

	/**
	 * 
	 * TODO
	 *
	 * @param comp
	 * @return
	 */
	private static JComponent createTab(JComponent comp) {
		final JXPanel panel = new JXPanel(new BorderLayout());
		panel.setOpaque(false);
		panel.setBorder(BorderFactory.createEmptyBorder(2, 3, 4, 4)); // L&F issue?
		panel.add(comp, BorderLayout.CENTER);
		return panel;
	}


	// --- Inner Classes ---

	/**
	 * <p>
	 * TODO
	 * </p>
	 * 
	 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
	 * @since 3rd Dec 2007
	 */
	private class RefreshAboutDataTask
	extends AbstractTask<List<?>, Void>
	{
		@Override
		protected List<?> doInBackground() throws InvalidSyntaxException {
			final List<Object> results = new ArrayList<Object>();
			results.add(System.getProperties().entrySet());
			results.add(Arrays.asList(desktop.getActivator().getContext().getBundles()));
			return results;
		}

		@Override
		@SuppressWarnings("unchecked")
		protected void succeeded(List<?> results) {
			propsModel.set(
					(Collection<Entry<Object, Object>>) results.get(0));
			bundleModel.set(
					(Collection<Bundle>) results.get(1));
			bundleTable.packAll();
		}
	}
	
	/**
	 * Example long runing task.
	 * 
	 * 
	 */
	private class LongRunningTask extends AbstractTask<Void, String> {
		final String[] messages = {
				"I've got a band new...",
				"combine harvester,",
				"And I'll give you the key.",
				"I got twenty acres...",
				"An' you got forty-three "
		};

		@Override
		protected Void doInBackground() throws Exception {
			setMessage("Sing along...");
			Thread.sleep(5000);

			for (int i = 0; i < messages.length; i++) {
				setMessage(messages[i]);
				setProgress(i, 0, messages.length - 1);
				Thread.sleep(2500);
			}
			return null;
		}
	}
}
