package civvi.osgi.desktop.component.about;

import civvi.osgi.desktop.OSGiDesktop;
import civvi.osgi.desktop.swingx.AppFrameworkSupport;
import civvi.osgi.desktop.swingx.Column;

/**
 * Defines a column in the {@link BundleTableModel}.
 *
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [15 Aug 2008]
 */
public enum BundleColumn implements Column {
	ENABLED(Boolean.class),
	NAME(String.class),
	VERSION(String.class),
	VENDOR(String.class),
	DESCRIPTION(String.class),
	ACTIVATOR(String.class),
	STATUS(String.class);
	
	private final AppFrameworkSupport<OSGiDesktop> support;
	final Class<?> type;
	private BundleColumn(Class<?> type) {
		this.support = new AppFrameworkSupport<OSGiDesktop>(this);
		this.type = type;
	}
	@Override
	public Class<?> getType() {
		return this.type;
	}
	@Override
	public String getDisplayName() {
		return this.support.getString("column." + name() + ".name");
	}
}
