package civvi.osgi.desktop.component.about;

import java.util.Dictionary;

import javax.swing.table.TableModel;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Constants;

import civvi.osgi.desktop.swingx.AbstractListTableModel;
import civvi.osgi.desktop.swingx.AppFrameworkSupport;

/**
 * Defines a {@link TableModel} for OSGi {@link Bundle}s.
 *
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [15 Aug 2008]
 */
public class BundleTableModel
extends AbstractListTableModel<Bundle, BundleColumn>
{
	private static final long serialVersionUID = 1L;

	@Override
	protected Object getValueAt(Bundle row, BundleColumn column) {
		@SuppressWarnings("rawtypes")
		final Dictionary dic = row.getHeaders();

		switch (column) {
		case ENABLED:
			return row.getState() == Bundle.ACTIVE;
		case NAME:
			return dic.get(Constants.BUNDLE_NAME);
		case VERSION:
			return dic.get(Constants.BUNDLE_VERSION);
		case VENDOR:
			return dic.get(Constants.BUNDLE_VENDOR);
		case DESCRIPTION:
			return dic.get(Constants.BUNDLE_DESCRIPTION);
		case ACTIVATOR:
			return dic.get(Constants.BUNDLE_ACTIVATOR);
		case STATUS:
			return convertState(row.getState());
		default:
			throw new IllegalArgumentException(String.format(
					"Unknown column index! [columnIndex=%1$d]",
					column));
		}
	}

	@Override
	public boolean isCellEditable(int rowIndex, int columnIndex) {
		final int state = get(rowIndex).getState();
		return columnIndex == BundleColumn.ENABLED.ordinal() &&
				(state == Bundle.ACTIVE || state == Bundle.RESOLVED);
	}

	@Override
	protected void setValueAt(Object aValue, Bundle row, BundleColumn column) {
		try {
			if (row.getState() == Bundle.ACTIVE) {
				row.stop();
			} else {
				row.start();
			}
			final int rowIndex = indexOf(row);
			fireTableRowsUpdated(rowIndex, rowIndex);
		} catch (BundleException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * TODO i18n! {@link AppFrameworkSupport} methinks
	 *
	 * @param state
	 * @return
	 */
	private static String convertState(int state) {
		switch (state) {
		case Bundle.UNINSTALLED:
			return "Uninstalled";
		case Bundle.INSTALLED:
			return "Installed";
		case Bundle.RESOLVED:
			return "Resolved";
		case Bundle.STARTING:
			return "Starting";
		case Bundle.STOPPING:
			return "Stopping";
		case Bundle.ACTIVE:
			return "Active";
		default:
			throw new IllegalArgumentException(String.format(
					"Unknown state! [state=%1$d]",
					state));
		}
	}
}
