package civvi.osgi.desktop.component.view;

import java.awt.Component;
import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;

import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;

import civvi.osgi.desktop.DesktopRuntimeException;

/**
 * 
 * TODO
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [11 Jul 2010]
 */
public class BeanInfoCellRenderer extends DefaultListCellRenderer {
	private static final long serialVersionUID = 1L;

	@Override
	public Component getListCellRendererComponent(
			JList list,
			Object value,
			int index,
			boolean isSelected,
			boolean cellHasFocus)
	{
		super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
		decorate((Class<?>) value);
		return this;
	}

	/**
	 * TODO
	 *
	 * @param task
	 */
	private void decorate(Class<?> value) {
		try {
			final BeanInfo beanInfo = Introspector.getBeanInfo(value);
			setText(beanInfo.getBeanDescriptor().getDisplayName());
			setToolTipText(beanInfo.getBeanDescriptor().getShortDescription());
			setIcon(getIcon(BeanInfo.ICON_COLOR_16x16, beanInfo));
		} catch (IntrospectionException ie) {
			throw new DesktopRuntimeException(
					"Unable to introspect bean! [" + value + "]", ie);
		}
	}

	/**
	 * 
	 * TODO
	 * @param iconKind
	 * @param beanInfo
	 * @return
	 */
	private ImageIcon getIcon(int iconKind, BeanInfo beanInfo) {
		final Image largeIcon = beanInfo.getIcon(iconKind);
		return largeIcon != null ? new ImageIcon(largeIcon) : null;
	}
}
